/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.ccbpay.request.trade.order;

import com.fshows.ccbpay.enums.trade.CcbPayTradeApiDefinitionEnum;
import com.fshows.ccbpay.response.trade.order.CcbNormalOrderQueryResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;

import org.hibernate.validator.constraints.Length;
import com.alibaba.fastjson.annotation.JSONField;

import com.fshows.ccbpay.request.base.CcbPayBizRequest;

/**
 *
 *
 * @author
 * @version CcbOrderQueryRequest.java, v 0.1 2022-07-05 10:41:07
 */
@Data
public class CcbOrderQueryRequest extends CcbPayBizRequest<CcbNormalOrderQueryResponse, CcbPayTradeApiDefinitionEnum> {

    private static final long serialVersionUID = -2213838555881740475L;


    /**
     * 商户号
     * 请联系开立商户的分行提供
     *
     * 示例：105421097080009
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "merchantid长度不能超过15")
    @JSONField(name = "MERCHANTID")
    private String merchantid;

    /**
     * 柜台号
     * 请联系开立商户的分行提供
     *
     * 示例：902807340
     * (必填)
     */
    @NotBlank
    @Length(max = 9, message = "posid长度不能超过9")
    @JSONField(name = "POSID")
    private String posid;

    /**
     * 分行号
     * 请联系开立商户的分行提供（一级分行号）
     *
     * 示例：360000000
     * (必填)
     */
    @NotBlank
    @Length(max = 9, message = "branchid长度不能超过9")
    @JSONField(name = "BRANCHID")
    private String branchid;

    /**
     * 集团商户信息
     * （非集团商户无需上送）集团主商户代理发起子商户交易时（验证主商户柜台公钥），需将集团主商户信息填入该字段，格式为：JTSH:主商户号+主商户柜台+主商户分行号例如：JTSH:105000000000000123456789441000000其中：105000000000000为主商户号，123456789为主商户柜台号，441000000为主商户一级分行号
     *
     * 示例：JTSH:105000000000000123456789441000000
     * (特殊必填)
     */
    @Length(max = 40, message = "groupmch长度不能超过40")
    @JSONField(name = "GROUPMCH")
    private String groupmch;

    /**
     * 加密串
     * 加密串通过[4.2.请求报文加密方法]中的说明生成，加密源串参数包含以下浅蓝色底纹的参数，如：TXCODE=PAY102&amp;MERFLAG=1&amp;ORDERID=20180906101102&amp;QRCODETYPE=2
     *
     * 示例：ylQZnF9G57gKymsjC99NTUyqUwynqgeCywvYhT%2FhW1%2CFRewTw4t0nEk8Jz%2FKYI%0AY6Pa7rQPRMJ6nmkqO7B
     * (必填)
     */
    @NotBlank
    @Length(max = 6144, message = "ccbparam长度不能超过6144")
    @JSONField(name = "ccbParam")
    private String ccbparam;

    /**
     * 交易码
     * 固定值PAY102
     *
     * 示例：PAY102
     * (必填)
     */
    @NotBlank
    @Length(max = 6, message = "txcode长度不能超过6")
    @JSONField(name = "TXCODE")
    private String txcode;

    /**
     * 商户类型
     * 1：线上商户2：线下商户商户类型请与分行确认
     *
     * 示例：1
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "merflag长度不能超过1")
    @JSONField(name = "MERFLAG")
    private String merflag;

    /**
     * 终端编号1
     * 商户类型为2时上送请联系开立商户的分行提供
     *
     * 示例：1054210970800090001
     * (特殊必填)
     */
    @Length(max = 19, message = "termno1长度不能超过19")
    @JSONField(name = "TERMNO1")
    private String termno1;

    /**
     * 终端编号2
     * 商户类型为2时上送请联系开立商户的分行提供
     *
     * 示例：12345678
     * (特殊必填)
     */
    @Length(max = 8, message = "termno2长度不能超过8")
    @JSONField(name = "TERMNO2")
    private String termno2;

    /**
     * 订单号
     * 订单标识
     *
     * 示例：20180906101102
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "orderid长度不能超过30")
    @JSONField(name = "ORDERID")
    private String orderid;

    /**
     * 二维码类型
     * 2：微信3：支付宝
     *
     * 示例：2
     * (必填)
     */
    @NotBlank
    @Length(max = 2, message = "qrcodetype长度不能超过2")
    @JSONField(name = "QRCODETYPE")
    private String qrcodetype;

}