package com.fshows.ccbpay.enums.settle;

import com.fshows.ccbpay.client.base.ICcbPayApiDefinition;
import com.fshows.ccbpay.enums.base.CcbApiTypeEnum;
import com.fshows.ccbpay.request.base.CcbPayCommonRequest;
import com.fshows.ccbpay.request.settle.CcbLargeFileDownloadRequest;
import com.fshows.ccbpay.request.settle.CcbStatmentFileRequest;
import com.fshows.ccbpay.response.base.CcbPayCommonResponse;
import com.fshows.ccbpay.response.settle.CcbStatmentFileResponse;

/**
 * 建行开放平台结算相关API
 *
 * @author liluqing
 * @version CcbPaySettleApiDefinitionEnum.java, v 0.1 2022-03-01 21:53 liluqing
 */
public enum CcbPaySettleApiDefinitionEnum implements ICcbPayApiDefinition {
    STATMENT_FILE(
            "商户流水文件下载请求",
            "/5W1005",
            CcbStatmentFileRequest.class,
            CcbStatmentFileResponse.class,
            CcbApiTypeEnum.OUT_CONNECT_PLATFORM
    ),
    LARGE_FILE_DOWNLOAD(
            "大文件下载",
            "/6W0111",
            CcbLargeFileDownloadRequest.class,
            CcbPayCommonResponse.class,
            CcbApiTypeEnum.OUT_CONNECT_PLATFORM
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;
    /**
     * 请求Class类型
     */
    private Class requestClass;
    /**
     * 响应Class类型
     */
    private Class responseClass;
    /**
     * API类型
     */
    private CcbApiTypeEnum ccbApiTypeEnum;

    CcbPaySettleApiDefinitionEnum(String name, String apiSubURI, Class requestClass, Class responseClass, CcbApiTypeEnum ccbApiTypeEnum) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
        this.ccbApiTypeEnum = ccbApiTypeEnum;
    }

    @Override
    public String getApiSubURI() {
        return apiSubURI;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}