package com.fshows.ccbpay.enums.merchant;

import com.fshows.ccbpay.client.base.ICcbPayApiDefinition;

/**
 * 建行开放平台商户进件入驻相关API
 *
 * @author liluqing
 * @version CcbPayMerchantApiDefinitionEnum.java, v 0.1 2022-03-01 21:53 liluqing
 */
public enum CcbPayMerchantApiDefinitionEnum implements ICcbPayApiDefinition {
    ADD_MERCHANT(
            "商户入驻接口",
            "",
            null,
            null
    ),
    CHANGE_MERCHANT(
            "商户信息变更",
            "",
            null,
            null
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;
    /**
     * 请求Class类型
     */
    private Class requestClass;
    /**
     * 响应Class类型
     */
    private Class responseClass;


    CcbPayMerchantApiDefinitionEnum(String name,
                                    String apiSubURI,
                                    Class requestClass,
                                    Class responseClass) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiSubURI() {
        return apiSubURI;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}