/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.ccbpay.client.impl;

import com.fshows.ccbpay.client.base.ApiClientConfig;
import com.fshows.ccbpay.client.base.ICcbPayApiDefinition;
import com.fshows.ccbpay.client.base.IHttpRequest;
import com.fshows.ccbpay.client.base.ISigner;
import com.fshows.ccbpay.exception.CcbPayApiException;
import com.fshows.ccbpay.request.base.CcbPayBaseRequest;
import com.fshows.ccbpay.response.base.CcbPayBaseResponse;
import com.fshows.ccbpay.util.CcbRequestUtils;
import com.fshows.ccbpay.util.LogUtil;
import lombok.extern.slf4j.Slf4j;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;


/**
 * 建行开放平台交易接口客户端
 *
 * @author liluqing
 * @version UnionPayApiClientImpl.java, v 0.1 2022-03-04 15:02
 */
@Slf4j
public class CcbWlptApiClientImpl extends AbstractCcbPayApiClientImpl {

    public CcbWlptApiClientImpl(ApiClientConfig apiClientConfig) throws CcbPayApiException {
        this(apiClientConfig, new WlptRequestImpl(), new DefaultSignerImpl());
    }

    public CcbWlptApiClientImpl(ApiClientConfig apiClientConfig, IHttpRequest httpRequest, ISigner signer) throws CcbPayApiException {
        super(apiClientConfig, httpRequest, signer);
    }

    @Override
    public <T extends CcbPayBaseResponse, R extends ICcbPayApiDefinition> T execute(CcbPayBaseRequest<T, R> request, R tradeApiDefinitionEnum) throws CcbPayApiException {
        return super.doExecute(request, tradeApiDefinitionEnum);
    }

    /**
     * 添加对入参进行额外处理
     *
     * @param bizRequest             业务请求参数
     * @param tradeApiDefinitionEnum
     * @return
     */
    @Override
    protected CcbPayBaseRequest buildBizRequest(CcbPayBaseRequest bizRequest, ICcbPayApiDefinition tradeApiDefinitionEnum) {
        return bizRequest;
    }

    /**
     * 接口参数序列化
     *
     * @param request
     * @param tradeApiDefinitionEnum
     * @return
     */
    @Override
    protected String serializableRequest(CcbPayBaseRequest request, ICcbPayApiDefinition tradeApiDefinitionEnum) {
        Map<String, String> requstMap = CcbRequestUtils.toMap(request);
        // 转大写
        Map<String, String> newMap = new HashMap<>();

        requstMap.entrySet().stream().forEach(entry -> {
            String key = entry.getKey();
            String upKey = Arrays.stream(key.split("_")).map(String::toUpperCase).collect(Collectors.joining("_"));
            newMap.put(upKey, entry.getValue());
        });

        return CcbRequestUtils.generateXml(newMap);
    }

    /**
     * 响应结果反序列化
     *
     * @param resBody
     * @param tradeApiDefinitionEnum
     * @return
     */
    @Override
    protected CcbPayBaseResponse parseResponse(String resBody, ICcbPayApiDefinition tradeApiDefinitionEnum) {
        try {
            Map<String, String> resMap = CcbRequestUtils.getMapFromXML(resBody);
            return CcbRequestUtils.getObjectFromMap(resMap, tradeApiDefinitionEnum.getResponseClass());
        } catch (Exception e) {
            LogUtil.error(log, "【ccb-sdk】响应结果反序列化异常 >> resBody={}", e, resBody);
//            throw new CcbPayApiException("[ccb-sdk]响应结果反序列化异常");
        }

        return null;
    }
}