/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.ccbpay.client.impl;

import ccb.pay.api.util.CCBPayUtil;
import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.ccbpay.client.base.ApiClientConfig;
import com.fshows.ccbpay.client.base.IHttpRequest;
import com.fshows.ccbpay.client.base.ICcbPayApiDefinition;
import com.fshows.ccbpay.client.base.ISigner;
import com.fshows.ccbpay.exception.CcbPayApiException;
import com.fshows.ccbpay.request.base.CcbPayBaseRequest;
import com.fshows.ccbpay.request.base.CcbPayBizRequest;
import com.fshows.ccbpay.response.base.CcbPayBaseResponse;
import com.fshows.ccbpay.util.LogUtil;
import lombok.extern.slf4j.Slf4j;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;


/**
 * 建行开放平台交易接口客户端
 *
 * @author liluqing
 * @version UnionPayApiClientImpl.java, v 0.1 2022-03-04 15:02
 */
@Slf4j
public class CcbPayApiClientImpl extends AbstractCcbPayApiClientImpl {


    public CcbPayApiClientImpl(ApiClientConfig apiClientConfig) throws CcbPayApiException {
        super(apiClientConfig);
    }

    public CcbPayApiClientImpl(ApiClientConfig apiClientConfig, IHttpRequest httpRequest, ISigner signer) throws CcbPayApiException {
        super(apiClientConfig, httpRequest, signer);
    }


    @Override
    public <T extends CcbPayBaseResponse, R extends ICcbPayApiDefinition> T execute(CcbPayBaseRequest<T, R> request, R tradeApiDefinitionEnum) throws CcbPayApiException {




        return super.doExecute(request, tradeApiDefinitionEnum);
    }

    /**
     * 添加对入参进行额外处理
     *
     * @param request 业务请求参数
     * @param tradeApiDefinitionEnum
     * @return
     */
    @Override
    protected CcbPayBaseRequest buildBizRequest(CcbPayBaseRequest request, ICcbPayApiDefinition tradeApiDefinitionEnum) {
        return null;
    }
    /**
     * 接口参数序列化
     *
     * @param request
     * @param tradeApiDefinitionEnum
     * @return
     */
    @Override
    protected String serializableRequest(CcbPayBaseRequest request, ICcbPayApiDefinition tradeApiDefinitionEnum) throws CcbPayApiException {


        CcbPayBizRequest tradeRequest = BeanUtil.copyProperties(request,CcbPayBizRequest.class);
        // 商户信息组装
        StringBuilder body = new StringBuilder();
        body.append("MERCHANTID=").append(tradeRequest.getMerchantid()).append("&");
        body.append("POSID=").append(tradeRequest.getPosid()).append("&");
        body.append("BRANCHID=").append(tradeRequest.getBranchid()).append("&");

        // ccbParam
        String param = getWaitSignStr(tradeRequest);
        CCBPayUtil ccbPayUtil = new CCBPayUtil();
        try {
            String ccbParam = ccbPayUtil.makeCCBParam(param, apiClientConfig.getCcbPayPublicKey());
            body.append(ccbParam);
            return body.toString();
        } catch (UnsupportedEncodingException e) {
            LogUtil.error(log, "【ccbpay-sdk】生成ccbParam失败 >> url={}, param = {}", tradeApiDefinitionEnum.getApiSubURI(), param);
            throw new CcbPayApiException("【ccbpay-sdk】生成ccbParam失败");
        }
    }

    /**
     * 响应结果反序列化
     *
     * @param resBody
     * @param tradeApiDefinitionEnum
     * @return
     */
    @Override
    protected CcbPayBaseResponse parseResponse(String resBody, ICcbPayApiDefinition tradeApiDefinitionEnum) {
        return (CcbPayBaseResponse) JSONObject.parseObject(resBody, tradeApiDefinitionEnum.getResponseClass());
    }


    /**
     * 获取待加签字符串
     * @param request
     * @return {@link String}
     */
    private String getWaitSignStr(CcbPayBizRequest request) {

        StringBuilder queryString = new StringBuilder();
        Field[] fields = request.getClass().getDeclaredFields();
        for (Field field : fields) {
            JSONField annotation = field.getAnnotation(JSONField.class);
            if (annotation != null) {
                field.setAccessible(true);
                try {
                    Object value = field.get(request);
                    if (queryString.length() > 0) {
                        queryString.append("&");
                    }
                    queryString.append(annotation.name()).append("=").append(value == null ? "" : value);
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        return queryString.toString();
    }
}