/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.yeepay.base.utils.unionpay;

import com.fshows.yeepay.base.utils.unionpay.CertUtil;
import com.fshows.yeepay.base.utils.unionpay.SDKConfig;
import com.fshows.yeepay.base.utils.unionpay.SecureUtil;
import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDKUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SDKUtil.class);

    public static boolean sign(Map<String, String> data, String encoding) {
        if (SDKUtil.isEmpty(encoding)) {
            encoding = "UTF-8";
        }
        String signMethod = data.get("signMethod");
        String version = data.get("version");
        if (!"1.0.0".equals(version) && !"5.0.1".equals(version) && SDKUtil.isEmpty(signMethod)) {
            LOGGER.error("signMethod must Not null");
            return false;
        }
        if (SDKUtil.isEmpty(version)) {
            LOGGER.error("version must Not null");
            return false;
        }
        if ("01".equals(signMethod) || "1.0.0".equals(version) || "5.0.1".equals(version)) {
            if ("5.0.0".equals(version) || "1.0.0".equals(version) || "5.0.1".equals(version)) {
                data.put("certId", CertUtil.getSignCertId());
                String stringData = SDKUtil.coverMap2String(data);
                LOGGER.info("\u5f85\u7b7e\u540d\u8bf7\u6c42\u62a5\u6587\u4e32:[" + stringData + "]");
                byte[] byteSign = null;
                String stringSign = null;
                try {
                    byte[] signDigest = SecureUtil.sha1X16(stringData, encoding);
                    byteSign = SecureUtil.base64Encode(SecureUtil.signBySoft(CertUtil.getSignCertPrivateKey(), signDigest));
                    stringSign = new String(byteSign);
                    data.put("signature", stringSign);
                    return true;
                }
                catch (Exception e) {
                    LOGGER.error("Sign Error", (Throwable)e);
                    return false;
                }
            }
            if ("5.1.0".equals(version)) {
                data.put("certId", CertUtil.getSignCertId());
                String stringData = SDKUtil.coverMap2String(data);
                LOGGER.info("\u5f85\u7b7e\u540d\u8bf7\u6c42\u62a5\u6587\u4e32:[" + stringData + "]");
                byte[] byteSign = null;
                String stringSign = null;
                try {
                    byte[] signDigest = SecureUtil.sha256X16(stringData, encoding);
                    byteSign = SecureUtil.base64Encode(SecureUtil.signBySoft256(CertUtil.getSignCertPrivateKey(), signDigest));
                    stringSign = new String(byteSign);
                    data.put("signature", stringSign);
                    return true;
                }
                catch (Exception e) {
                    LOGGER.error("Sign Error", (Throwable)e);
                    return false;
                }
            }
        } else {
            if ("11".equals(signMethod)) {
                return SDKUtil.signBySecureKey(data, SDKConfig.getConfig().getSecureKey(), encoding);
            }
            if ("12".equals(signMethod)) {
                return SDKUtil.signBySecureKey(data, SDKConfig.getConfig().getSecureKey(), encoding);
            }
        }
        return false;
    }

    public static boolean signBySecureKey(Map<String, String> data, String secureKey, String encoding) {
        if (SDKUtil.isEmpty(encoding)) {
            encoding = "UTF-8";
        }
        if (SDKUtil.isEmpty(secureKey)) {
            LOGGER.error("secureKey is empty");
            return false;
        }
        String signMethod = data.get("signMethod");
        if (SDKUtil.isEmpty(signMethod)) {
            LOGGER.error("signMethod must Not null");
            return false;
        }
        if ("11".equals(signMethod)) {
            String stringData = SDKUtil.coverMap2String(data);
            LOGGER.info("\u5f85\u7b7e\u540d\u8bf7\u6c42\u62a5\u6587\u4e32:[" + stringData + "]");
            String strBeforeSha256 = stringData + "&" + SecureUtil.sha256X16Str(secureKey, encoding);
            String strAfterSha256 = SecureUtil.sha256X16Str(strBeforeSha256, encoding);
            data.put("signature", strAfterSha256);
            return true;
        }
        if ("12".equals(signMethod)) {
            String stringData = SDKUtil.coverMap2String(data);
            LOGGER.info("\u5f85\u7b7e\u540d\u8bf7\u6c42\u62a5\u6587\u4e32:[" + stringData + "]");
            String strBeforeSM3 = stringData + "&" + SecureUtil.sm3X16Str(secureKey, encoding);
            String strAfterSM3 = SecureUtil.sm3X16Str(strBeforeSM3, encoding);
            data.put("signature", strAfterSM3);
            return true;
        }
        return false;
    }

    public static boolean signByCertInfo(Map<String, String> data, String certPath, String certPwd, String encoding) {
        if (SDKUtil.isEmpty(encoding)) {
            encoding = "UTF-8";
        }
        if (SDKUtil.isEmpty(certPath) || SDKUtil.isEmpty(certPwd)) {
            LOGGER.error("CertPath or CertPwd is empty");
            return false;
        }
        String signMethod = data.get("signMethod");
        String version = data.get("version");
        if (!"1.0.0".equals(version) && !"5.0.1".equals(version) && SDKUtil.isEmpty(signMethod)) {
            LOGGER.error("signMethod must Not null");
            return false;
        }
        if (SDKUtil.isEmpty(version)) {
            LOGGER.error("version must Not null");
            return false;
        }
        if ("01".equals(signMethod) || "1.0.0".equals(version) || "5.0.1".equals(version)) {
            if ("5.0.0".equals(version) || "1.0.0".equals(version) || "5.0.1".equals(version)) {
                data.put("certId", CertUtil.getCertIdByKeyStoreMap(certPath, certPwd));
                String stringData = SDKUtil.coverMap2String(data);
                LOGGER.info("\u5f85\u7b7e\u540d\u8bf7\u6c42\u62a5\u6587\u4e32:[" + stringData + "]");
                byte[] byteSign = null;
                String stringSign = null;
                try {
                    byte[] signDigest = SecureUtil.sha1X16(stringData, encoding);
                    byteSign = SecureUtil.base64Encode(SecureUtil.signBySoft(CertUtil.getSignCertPrivateKeyByStoreMap(certPath, certPwd), signDigest));
                    stringSign = new String(byteSign);
                    data.put("signature", stringSign);
                    return true;
                }
                catch (Exception e) {
                    LOGGER.error("Sign Error", (Throwable)e);
                    return false;
                }
            }
            if ("5.1.0".equals(version)) {
                data.put("certId", CertUtil.getCertIdByKeyStoreMap(certPath, certPwd));
                String stringData = SDKUtil.coverMap2String(data);
                LOGGER.info("\u5f85\u7b7e\u540d\u8bf7\u6c42\u62a5\u6587\u4e32:[" + stringData + "]");
                byte[] byteSign = null;
                String stringSign = null;
                try {
                    byte[] signDigest = SecureUtil.sha256X16(stringData, encoding);
                    byteSign = SecureUtil.base64Encode(SecureUtil.signBySoft256(CertUtil.getSignCertPrivateKeyByStoreMap(certPath, certPwd), signDigest));
                    stringSign = new String(byteSign);
                    data.put("signature", stringSign);
                    return true;
                }
                catch (Exception e) {
                    LOGGER.error("Sign Error", (Throwable)e);
                    return false;
                }
            }
        }
        return false;
    }

    public static boolean validateBySecureKey(Map<String, String> resData, String secureKey, String encoding) {
        String signMethod;
        LOGGER.info("\u9a8c\u7b7e\u5904\u7406\u5f00\u59cb");
        if (SDKUtil.isEmpty(encoding)) {
            encoding = "UTF-8";
        }
        if ("11".equals(signMethod = resData.get("signMethod"))) {
            String stringSign = resData.get("signature");
            LOGGER.info("\u7b7e\u540d\u539f\u6587\uff1a[" + stringSign + "]");
            String stringData = SDKUtil.coverMap2String(resData);
            LOGGER.info("\u5f85\u9a8c\u7b7e\u8fd4\u56de\u62a5\u6587\u4e32\uff1a[" + stringData + "]");
            String strBeforeSha256 = stringData + "&" + SecureUtil.sha256X16Str(secureKey, encoding);
            String strAfterSha256 = SecureUtil.sha256X16Str(strBeforeSha256, encoding);
            return stringSign.equals(strAfterSha256);
        }
        if ("12".equals(signMethod)) {
            String stringSign = resData.get("signature");
            LOGGER.info("\u7b7e\u540d\u539f\u6587\uff1a[" + stringSign + "]");
            String stringData = SDKUtil.coverMap2String(resData);
            LOGGER.info("\u5f85\u9a8c\u7b7e\u8fd4\u56de\u62a5\u6587\u4e32\uff1a[" + stringData + "]");
            String strBeforeSM3 = stringData + "&" + SecureUtil.sm3X16Str(secureKey, encoding);
            String strAfterSM3 = SecureUtil.sm3X16Str(strBeforeSM3, encoding);
            return stringSign.equals(strAfterSM3);
        }
        return false;
    }

    public static boolean validate(Map<String, String> resData, String encoding) {
        block15: {
            LOGGER.info("\u9a8c\u7b7e\u5904\u7406\u5f00\u59cb");
            if (SDKUtil.isEmpty(encoding)) {
                encoding = "UTF-8";
            }
            String signMethod = resData.get("signMethod");
            String version = resData.get("version");
            if ("01".equals(signMethod) || "1.0.0".equals(version) || "5.0.1".equals(version)) {
                if ("5.0.0".equals(version) || "1.0.0".equals(version) || "5.0.1".equals(version)) {
                    String stringSign = resData.get("signature");
                    LOGGER.info("\u7b7e\u540d\u539f\u6587\uff1a[" + stringSign + "]");
                    String certId = resData.get("certId");
                    LOGGER.info("\u5bf9\u8fd4\u56de\u62a5\u6587\u4e32\u9a8c\u7b7e\u4f7f\u7528\u7684\u9a8c\u7b7e\u516c\u94a5\u5e8f\u5217\u53f7\uff1a[" + certId + "]");
                    String stringData = SDKUtil.coverMap2String(resData);
                    LOGGER.info("\u5f85\u9a8c\u7b7e\u8fd4\u56de\u62a5\u6587\u4e32\uff1a[" + stringData + "]");
                    try {
                        return SecureUtil.validateSignBySoft(CertUtil.getValidatePublicKey(certId), SecureUtil.base64Decode(stringSign.getBytes(encoding)), SecureUtil.sha1X16(stringData, encoding));
                    }
                    catch (UnsupportedEncodingException e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                        break block15;
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                        break block15;
                    }
                }
                if ("5.1.0".equals(version)) {
                    String strCert = resData.get("signPubKeyCert");
                    X509Certificate x509Cert = CertUtil.genCertificateByStr(strCert);
                    if (x509Cert == null) {
                        LOGGER.error("convert signPubKeyCert failed");
                        return false;
                    }
                    if (!CertUtil.verifyCertificate(x509Cert)) {
                        LOGGER.error("\u9a8c\u8bc1\u516c\u94a5\u8bc1\u4e66\u5931\u8d25\uff0c\u8bc1\u4e66\u4fe1\u606f\uff1a[" + strCert + "]");
                        return false;
                    }
                    String stringSign = resData.get("signature");
                    LOGGER.info("\u7b7e\u540d\u539f\u6587\uff1a[" + stringSign + "]");
                    String stringData = SDKUtil.coverMap2String(resData);
                    LOGGER.info("\u5f85\u9a8c\u7b7e\u8fd4\u56de\u62a5\u6587\u4e32\uff1a[" + stringData + "]");
                    try {
                        boolean result = SecureUtil.validateSignBySoft256(x509Cert.getPublicKey(), SecureUtil.base64Decode(stringSign.getBytes(encoding)), SecureUtil.sha256X16(stringData, encoding));
                        LOGGER.info("\u9a8c\u8bc1\u7b7e\u540d" + (result ? "\u6210\u529f" : "\u5931\u8d25"));
                        return result;
                    }
                    catch (UnsupportedEncodingException e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                }
            } else {
                if ("11".equals(signMethod)) {
                    String stringSign = resData.get("signature");
                    LOGGER.info("\u7b7e\u540d\u539f\u6587\uff1a[" + stringSign + "]");
                    String stringData = SDKUtil.coverMap2String(resData);
                    LOGGER.info("\u5f85\u9a8c\u7b7e\u8fd4\u56de\u62a5\u6587\u4e32\uff1a[" + stringData + "]");
                    String strBeforeSha256 = stringData + "&" + SecureUtil.sha256X16Str(SDKConfig.getConfig().getSecureKey(), encoding);
                    String strAfterSha256 = SecureUtil.sha256X16Str(strBeforeSha256, encoding);
                    boolean result = stringSign.equals(strAfterSha256);
                    LOGGER.info("\u9a8c\u8bc1\u7b7e\u540d" + (result ? "\u6210\u529f" : "\u5931\u8d25"));
                    return result;
                }
                if ("12".equals(signMethod)) {
                    String stringSign = resData.get("signature");
                    LOGGER.info("\u7b7e\u540d\u539f\u6587\uff1a[" + stringSign + "]");
                    String stringData = SDKUtil.coverMap2String(resData);
                    LOGGER.info("\u5f85\u9a8c\u7b7e\u8fd4\u56de\u62a5\u6587\u4e32\uff1a[" + stringData + "]");
                    String strBeforeSM3 = stringData + "&" + SecureUtil.sm3X16Str(SDKConfig.getConfig().getSecureKey(), encoding);
                    String strAfterSM3 = SecureUtil.sm3X16Str(strBeforeSM3, encoding);
                    boolean result = stringSign.equals(strAfterSM3);
                    LOGGER.info("\u9a8c\u8bc1\u7b7e\u540d" + (result ? "\u6210\u529f" : "\u5931\u8d25"));
                    return result;
                }
            }
        }
        return false;
    }

    public static String coverMap2String(Map<String, String> data) {
        TreeMap<String, String> tree = new TreeMap<String, String>();
        for (Map.Entry<String, String> en : data.entrySet()) {
            if ("signature".equals(en.getKey().trim())) continue;
            tree.put(en.getKey(), en.getValue());
        }
        Iterator<Map.Entry<String, String>> it = tree.entrySet().iterator();
        StringBuffer sf = new StringBuffer();
        while (it.hasNext()) {
            Map.Entry<String, String> en = it.next();
            sf.append(en.getKey() + "=" + en.getValue() + "&");
        }
        return sf.substring(0, sf.length() - 1);
    }

    public static Map<String, String> coverResultString2Map(String result) {
        return SDKUtil.convertResultStringToMap(result);
    }

    public static Map<String, String> convertResultStringToMap(String result) {
        Map<String, String> map = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)result)) {
                if (result.startsWith("{") && result.endsWith("}")) {
                    result = result.substring(1, result.length() - 1);
                }
                map = SDKUtil.parseQString(result);
            }
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return map;
    }

    public static Map<String, String> parseQString(String str) throws UnsupportedEncodingException {
        HashMap<String, String> map = new HashMap<String, String>();
        int len = str.length();
        StringBuilder temp = new StringBuilder();
        String key = null;
        boolean isKey = true;
        boolean isOpen = false;
        char openName = '\u0000';
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                char curChar = str.charAt(i);
                if (isKey) {
                    if (curChar == '=') {
                        key = temp.toString();
                        temp.setLength(0);
                        isKey = false;
                        continue;
                    }
                    temp.append(curChar);
                    continue;
                }
                if (isOpen) {
                    if (curChar == openName) {
                        isOpen = false;
                    }
                } else {
                    if (curChar == '{') {
                        isOpen = true;
                        openName = '}';
                    }
                    if (curChar == '[') {
                        isOpen = true;
                        openName = ']';
                    }
                }
                if (curChar == '&' && !isOpen) {
                    SDKUtil.putKeyValueToMap(temp, isKey, key, map);
                    temp.setLength(0);
                    isKey = true;
                    continue;
                }
                temp.append(curChar);
            }
            SDKUtil.putKeyValueToMap(temp, isKey, key, map);
        }
        return map;
    }

    private static void putKeyValueToMap(StringBuilder temp, boolean isKey, String key, Map<String, String> map) throws UnsupportedEncodingException {
        if (isKey) {
            key = temp.toString();
            if (key.length() == 0) {
                throw new RuntimeException("QString format illegal");
            }
            map.put(key, "");
        } else {
            if (key.length() == 0) {
                throw new RuntimeException("QString format illegal");
            }
            map.put(key, temp.toString());
        }
    }

    public static int getEncryptCert(Map<String, String> resData, String encoding) {
        String strCert = resData.get("encryptPubKeyCert");
        String certType = resData.get("certType");
        if (SDKUtil.isEmpty(strCert) || SDKUtil.isEmpty(certType)) {
            return -1;
        }
        X509Certificate x509Cert = CertUtil.genCertificateByStr(strCert);
        if ("01".equals(certType)) {
            if (!CertUtil.getEncryptCertId().equals(x509Cert.getSerialNumber().toString())) {
                String newLocalCertPath;
                String localCertPath = SDKConfig.getConfig().getEncryptCertPath();
                if (!SDKUtil.copyFile(localCertPath, newLocalCertPath = SDKUtil.genBackupName(localCertPath))) {
                    return -1;
                }
                if (!SDKUtil.writeFile(localCertPath, strCert, encoding)) {
                    return -1;
                }
                LOGGER.info("save new encryptPubKeyCert LOWER_CASE_SUCCESS");
                CertUtil.resetEncryptCertPublicKey();
                return 1;
            }
            return 0;
        }
        if ("02".equals(certType)) {
            return 0;
        }
        LOGGER.info("unknown cerType:" + certType);
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(String srcFile, String destFile) {
        boolean flag = false;
        FileInputStream fin = null;
        FileOutputStream fout = null;
        FileChannel fcin = null;
        FileChannel fcout = null;
        try {
            fin = new FileInputStream(srcFile);
            fout = new FileOutputStream(destFile);
            fcin = fin.getChannel();
            fcout = fout.getChannel();
            ByteBuffer buffer = ByteBuffer.allocate(1024);
            while (true) {
                buffer.clear();
                int r = fcin.read(buffer);
                if (r == -1) break;
                buffer.flip();
                fcout.write(buffer);
            }
            flag = true;
            fout.flush();
        }
        catch (IOException e) {
            LOGGER.error("CopyFile fail", (Throwable)e);
        }
        finally {
            try {
                if (null != fin) {
                    fin.close();
                }
                if (null != fout) {
                    fout.close();
                }
                if (null != fcin) {
                    fcin.close();
                }
                if (null != fcout) {
                    fcout.close();
                }
            }
            catch (IOException ex) {
                LOGGER.error("Releases any system resources fail", (Throwable)ex);
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFile(String filePath, String fileContent, String encoding) {
        FileOutputStream fout = null;
        FileChannel fcout = null;
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
        }
        try {
            fout = new FileOutputStream(filePath);
            fcout = fout.getChannel();
            ByteBuffer buffer = ByteBuffer.wrap(fileContent.getBytes(encoding));
            fcout.write(buffer);
            fout.flush();
        }
        catch (FileNotFoundException e) {
            LOGGER.error("WriteFile fail", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (IOException ex) {
            LOGGER.error("WriteFile fail", (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (null != fout) {
                    fout.close();
                }
                if (null != fcout) {
                    fcout.close();
                }
            }
            catch (IOException ex) {
                LOGGER.error("Releases any system resources fail", (Throwable)ex);
                return false;
            }
        }
        return true;
    }

    public static String genBackupName(String fileName) {
        if (SDKUtil.isEmpty(fileName)) {
            return "";
        }
        int i = fileName.lastIndexOf(".");
        String leftFileName = fileName.substring(0, i);
        String rightFileName = fileName.substring(i + 1);
        String newFileName = leftFileName + "_backup" + "." + rightFileName;
        return newFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileByNIO(String filePath) {
        FileInputStream in = null;
        FileChannel fc = null;
        ByteBuffer bf = null;
        try {
            in = new FileInputStream(filePath);
            fc = in.getChannel();
            bf = ByteBuffer.allocate((int)fc.size());
            fc.read(bf);
            byte[] byArray = bf.array();
            return byArray;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (null != fc) {
                    fc.close();
                }
                if (null != in) {
                    in.close();
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                return null;
            }
        }
    }

    public static Map<String, String> filterBlank(Map<String, String> contentData) {
        LOGGER.info("\u6253\u5370\u8bf7\u6c42\u62a5\u6587\u57df :");
        HashMap<String, String> submitFromData = new HashMap<String, String>();
        Set<String> keyset = contentData.keySet();
        for (String key : keyset) {
            String value = contentData.get(key);
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            submitFromData.put(key, value.trim());
            LOGGER.info(key + "-->" + String.valueOf(value));
        }
        return submitFromData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] inflater(byte[] inputByte) throws IOException {
        int compressedDataLength = 0;
        Inflater compresser = new Inflater(false);
        compresser.setInput(inputByte, 0, inputByte.length);
        byte[] result = new byte[1024];
        try (ByteArrayOutputStream o = new ByteArrayOutputStream(inputByte.length);){
            while (!compresser.finished()) {
                compressedDataLength = compresser.inflate(result);
                if (compressedDataLength == 0) {
                    break;
                }
                o.write(result, 0, compressedDataLength);
            }
        }
        compresser.end();
        return o.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] deflater(byte[] inputByte) throws IOException {
        int compressedDataLength = 0;
        Deflater compresser = new Deflater();
        compresser.setInput(inputByte);
        compresser.finish();
        byte[] result = new byte[1024];
        try (ByteArrayOutputStream o = new ByteArrayOutputStream(inputByte.length);){
            while (!compresser.finished()) {
                compressedDataLength = compresser.deflate(result);
                o.write(result, 0, compressedDataLength);
            }
        }
        compresser.end();
        return o.toByteArray();
    }

    public static boolean isEmpty(String s) {
        return null == s || "".equals(s.trim());
    }

    public static Map<String, String> getAllRequestParam(HttpServletRequest request) {
        HashMap res = Maps.newHashMap();
        Enumeration temp = request.getParameterNames();
        if (null != temp) {
            while (temp.hasMoreElements()) {
                String en = (String)temp.nextElement();
                String value = request.getParameter(en);
                res.put(en, value);
                if (null != res.get(en) && !"".equals(res.get(en))) continue;
                res.remove(en);
            }
        }
        return res;
    }
}

