/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.yeepay.base.utils;

import com.fshows.yeepay.base.enums.FileStatusEnum;
import com.fshows.yeepay.base.enums.FileTypeEnum;
import com.fshows.yeepay.base.enums.PayPlatformEnum;
import com.fshows.yeepay.base.enums.PayTypeEnum;
import com.fshows.yeepay.base.enums.WxTypeEnum;
import com.fshows.yeepay.base.exception.CommonOrderException;
import com.fshows.yeepay.base.utils.DateUtil;
import java.math.BigDecimal;
import java.util.UUID;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;

public class LiquidationUtils {
    public static final String WX_CODE = "01";
    public static final String ALI_CODE = "02";
    public static final String QQ_CODE = "06";
    public static final String JD_CODE = "09";

    public static final String createLiquidatorId() {
        String orderSn = DateUtil.getNowDateTimeStr();
        String s = RandomStringUtils.randomNumeric((int)3);
        return orderSn + s;
    }

    public static final String createStoreId(String platformSystermType) {
        String s = RandomStringUtils.randomNumeric((int)4);
        String storeId = DateUtil.getNowDateTimeStr() + platformSystermType + s;
        return storeId;
    }

    public static final String createMerchantIdNew(String platformSystermType) {
        String s = RandomStringUtils.randomNumeric((int)4);
        String storeId = DateUtil.getNowDateTimeStr() + platformSystermType + s;
        return storeId;
    }

    public static final String createBusiId(String type) {
        String s = RandomStringUtils.randomNumeric((int)4);
        String storeId = DateUtil.getNowDateTimeStr() + type + s;
        return storeId;
    }

    public static final String createRefundOrderSn(PayPlatformEnum payPlatform) {
        return LiquidationUtils.createOrderSn(payPlatform) + "T";
    }

    public static final String createOrderSn(PayPlatformEnum payPlatform) {
        String orderSn = DateUtil.getNowDateTimeStr();
        orderSn = payPlatform.equals((Object)PayPlatformEnum.ALIPAY) ? orderSn + ALI_CODE : (payPlatform.equals((Object)PayPlatformEnum.WX) ? orderSn + WX_CODE : (payPlatform.equals((Object)PayPlatformEnum.QPAY) ? orderSn + QQ_CODE : (payPlatform.equals((Object)PayPlatformEnum.JD) ? orderSn + JD_CODE : orderSn + WX_CODE)));
        String s = RandomStringUtils.randomNumeric((int)12);
        return orderSn + s;
    }

    public static BigDecimal formatYuan2Fen(BigDecimal fee) {
        return fee.multiply(new BigDecimal("100")).setScale(0, 6);
    }

    public static String createEveryFinanceFileName(Integer createDay, PayPlatformEnum payPlatform) {
        String platform = "\u5fae\u4fe1";
        if (PayPlatformEnum.ALIPAY.equals((Object)payPlatform)) {
            platform = "\u652f\u4ed8\u5b9d";
        }
        if (PayPlatformEnum.JD.equals((Object)payPlatform)) {
            platform = "\u4eac\u4e1c";
        }
        if (PayPlatformEnum.BESTPAY.equals((Object)payPlatform)) {
            platform = "\u7ffc\u652f\u4ed8";
        }
        return StringUtils.replaceEach((String)"\u79fb\u52a8\u652f\u4ed8\u5e73\u53f0platformcreateday\u5bf9\u8d26\u6587\u4ef6", (String[])new String[]{"platform", "createday"}, (String[])new String[]{platform, String.valueOf(createDay)});
    }

    public static Integer getDownBillFileType(PayPlatformEnum payPlatform, FileStatusEnum payStatus) {
        if (FileStatusEnum.PAY_SUCCESS_FILE.value() == payStatus.value()) {
            if (payPlatform.getValue() == PayPlatformEnum.ALIPAY.getValue()) {
                return FileTypeEnum.ALI_PAY_SUCCESS.value();
            }
            if (payPlatform.getValue() == PayPlatformEnum.WX.getValue()) {
                return FileTypeEnum.WX_PAY_SUCCESS.value();
            }
            if (payPlatform.getValue() == PayPlatformEnum.JD.getValue()) {
                return FileTypeEnum.JD_PAY_SUCCESS.value();
            }
            if (payPlatform.getValue() == PayPlatformEnum.BESTPAY.getValue()) {
                return FileTypeEnum.BEST_PAY_SUCCESS.value();
            }
            if (payPlatform.getValue() == PayPlatformEnum.UNIONPAY.getValue()) {
                return FileTypeEnum.BANK_PAY_SUCCESS.value();
            }
            throw CommonOrderException.ORDER_FILE_TYPE_NOT_EXIST_ERROR;
        }
        if (FileStatusEnum.PAY_REFUND_FILE.value() == payStatus.value()) {
            if (payPlatform.getValue() == PayPlatformEnum.ALIPAY.getValue()) {
                return FileTypeEnum.ALI_PAY_REFUND.value();
            }
            if (payPlatform.getValue() == PayPlatformEnum.WX.getValue()) {
                return FileTypeEnum.WX_PAY_REFUND.value();
            }
            throw CommonOrderException.ORDER_FILE_TYPE_NOT_EXIST_ERROR;
        }
        if (payPlatform.getValue() == payStatus.value()) {
            throw CommonOrderException.ORDER_FILE_TYPE_NOT_EXIST_ERROR;
        }
        throw CommonOrderException.ORDER_FILE_TYPE_NOT_EXIST_ERROR;
    }

    public static String createDataId() {
        StringBuffer sb = new StringBuffer();
        sb.append(DateUtil.getNowDateTimeStr());
        sb.append(RandomStringUtils.randomNumeric((int)6));
        int hashCodeV = UUID.randomUUID().toString().hashCode();
        if (hashCodeV < 0) {
            hashCodeV = -hashCodeV;
        }
        sb.append(String.format("%010d", hashCodeV));
        return sb.toString();
    }

    public static String generateJdOrderSn(String sourceOrderSn) {
        String beforeStr = sourceOrderSn.substring(0, 14);
        String afterStr = sourceOrderSn.substring(16);
        String jdOrderSn = beforeStr + JD_CODE + afterStr;
        return jdOrderSn;
    }

    public static boolean isJdNewOrderSn(String orderSn) {
        String code = orderSn.substring(14, 16);
        return JD_CODE.equals(code);
    }

    public static boolean isOasisOrder(String orderSn) {
        return StringUtils.endsWith((CharSequence)orderSn, (CharSequence)"g");
    }

    public static boolean isUnionOrder(String orderSn) {
        return StringUtils.endsWith((CharSequence)orderSn, (CharSequence)"N");
    }

    public static Integer getServerType(Integer isNew, Integer payType) {
        if (isNew == 0) {
            return payType;
        }
        Integer serverType = payType;
        if (payType.intValue() == PayTypeEnum.WX_FACE_PAY.getValue()) {
            serverType = WxTypeEnum.INTER_PAY.value();
        } else if (payType.intValue() == PayTypeEnum.WX_ONLINE_PAY.getValue()) {
            serverType = WxTypeEnum.INTER_ONLINE_PAY.value();
        } else if (payType.intValue() == PayTypeEnum.WX_OASIS.getValue()) {
            serverType = WxTypeEnum.INTER_WX_OASIS.value();
        }
        return serverType;
    }

    public static String getTransferOrderSn() {
        String orderSn = DateUtil.getNowDateTimeStr();
        String s = org.apache.commons.lang.RandomStringUtils.randomNumeric((int)4);
        return orderSn + WX_CODE + s;
    }
}

