/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.yeepay.base.utils;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonUtil.class);

    public static <T> T parse(String json, Class<T> clazz) {
        try {
            MAPPER.setPropertyNamingStrategy(PropertyNamingStrategy.LOWER_CAMEL_CASE);
            MAPPER.setDefaultPropertyInclusion(JsonInclude.Include.ALWAYS);
            return (T)MAPPER.readValue(json, clazz);
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static String toJson(Object object) {
        try {
            MAPPER.setPropertyNamingStrategy(PropertyNamingStrategy.LOWER_CAMEL_CASE);
            MAPPER.setDefaultPropertyInclusion(JsonInclude.Include.ALWAYS);
            return MAPPER.writeValueAsString(object);
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static String toUnderlineJSonByJackson(Object object) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
        return mapper.writeValueAsString(object);
    }

    public static Map toHashMap(String text) {
        return (Map)JSON.parseObject((String)text, LinkedHashMap.class);
    }

    public static String toJSonByJackson(Object object) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString(object);
    }
}

