/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.yeepay.base.utils;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downLoadFromUrl(String urlStr, String fileName, String savePath) {
        LOGGER.info("\u6587\u4ef6\u4e0b\u8f7d\uff0curl = {}\uff0csavePath = {}\uff0cfileName = {}", new Object[]{urlStr, savePath, fileName});
        FileOutputStream fos = null;
        InputStream inputStream = null;
        try {
            int readLength;
            File file;
            URL url = new URL(urlStr);
            HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
            httpURLConnection.setConnectTimeout(3000);
            httpURLConnection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            httpURLConnection.connect();
            inputStream = httpURLConnection.getInputStream();
            File saveDir = new File(savePath);
            File parentSaveDir = saveDir.getParentFile();
            if (!parentSaveDir.exists()) {
                parentSaveDir.mkdirs();
            }
            if (!saveDir.exists()) {
                saveDir.mkdir();
            }
            if (!(file = new File(saveDir + File.separator + fileName)).exists()) {
                file.setWritable(true, false);
                file.setExecutable(true, false);
                file.setReadable(true, false);
                file.createNewFile();
            }
            fos = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((readLength = inputStream.read(buffer)) != -1) {
                fos.write(buffer, 0, readLength);
            }
            fos.flush();
        }
        catch (IOException e) {
            LOGGER.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff0c{}", (Object)e.getMessage());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) throws FileNotFoundException {
        FileUtil.downLoadFromUrlNew("https://img.51youdian.com/data/img/201811/20181113204402941758.jpg", "test.jpg", "E:\\test");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String downLoadFromUrlNew(String urlStr, String fileName, String savePath) {
        LOGGER.info("\u6587\u4ef6\u4e0b\u8f7d\uff0curl = {}, fileName = {}, savePath = {}", new Object[]{urlStr, fileName, savePath});
        FileOutputStream fos = null;
        InputStream inputStream = null;
        InputStream inputStreamTemp = null;
        try {
            int readLength;
            File file;
            URL url = new URL(urlStr);
            HttpsURLConnection httpURLConnection = (HttpsURLConnection)url.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setConnectTimeout(3000);
            httpURLConnection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            httpURLConnection.setHostnameVerifier(new FileUtil().new TrustAnyHostnameVerifier());
            httpURLConnection.connect();
            inputStream = httpURLConnection.getInputStream();
            File saveDir = new File(savePath);
            File parentSaveDir = saveDir.getParentFile();
            if (!parentSaveDir.exists()) {
                parentSaveDir.mkdirs();
            }
            if (!saveDir.exists()) {
                saveDir.mkdir();
            }
            if (!(file = new File(saveDir + File.separator + fileName)).exists()) {
                file.setWritable(true, false);
                file.setExecutable(true, false);
                file.setReadable(true, false);
                file.createNewFile();
            }
            fos = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((readLength = inputStream.read(buffer)) != -1) {
                fos.write(buffer, 0, readLength);
            }
            fos.flush();
            File fileTemp = new File(saveDir + File.separator + fileName);
            inputStreamTemp = new FileInputStream(fileTemp);
            String fileType = FileUtil.getfileTypeByInputStream(inputStreamTemp);
            if (StringUtils.isBlank((CharSequence)fileType)) {
                LOGGER.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff0c{}", (Object)"\u6587\u4ef6\u7c7b\u578b\u4e0d\u6b63\u786e");
                String string = "";
                return string;
            }
            String string = fileName + "." + fileType;
            return string;
        }
        catch (IOException e) {
            LOGGER.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff0c{}", (Object)e.getMessage());
            String string = "";
            return string;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (inputStreamTemp != null) {
                    inputStreamTemp.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void downloadPicture(String urlList, String imageName) {
        URL url = null;
        boolean imageNumber = false;
        try {
            int length;
            url = new URL(urlList);
            DataInputStream dataInputStream = new DataInputStream(url.openStream());
            FileOutputStream fileOutputStream = new FileOutputStream(new File(imageName));
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = dataInputStream.read(buffer)) > 0) {
                output.write(buffer, 0, length);
            }
            byte[] context = output.toByteArray();
            fileOutputStream.write(output.toByteArray());
            dataInputStream.close();
            fileOutputStream.close();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getPicPath() {
        return SystemUtils.getUserHome() + SystemUtils.FILE_SEPARATOR + "files" + SystemUtils.FILE_SEPARATOR + "upload" + SystemUtils.FILE_SEPARATOR + "temp" + SystemUtils.FILE_SEPARATOR + "liquidation-openapi" + SystemUtils.FILE_SEPARATOR + "img" + SystemUtils.FILE_SEPARATOR;
    }

    public static String getfileTypeByInputStream(InputStream inputStream) {
        try {
            String res = null;
            byte[] b = new byte[3];
            inputStream.read(b, 0, b.length);
            String fileCode = FileUtil.bytesToHexString(b);
            Map<String, String> FILE_TYPE_MAP = FileUtil.fileType();
            for (String key : FILE_TYPE_MAP.keySet()) {
                if (!key.toLowerCase().startsWith(fileCode.toLowerCase()) && !fileCode.toLowerCase().startsWith(key.toLowerCase())) continue;
                res = FILE_TYPE_MAP.get(key);
                break;
            }
            return res;
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u6587\u4ef6\u7c7b\u578b\u5f02\u5e38{}", (Throwable)e);
            return "";
        }
    }

    public static Map<String, String> fileType() {
        HashMap<String, String> FILE_TYPE_MAP = new HashMap<String, String>();
        FILE_TYPE_MAP.put("ffd8ffe000104a464946", "jpg");
        FILE_TYPE_MAP.put("89504e470d0a1a0a0000", "png");
        FILE_TYPE_MAP.put("47494638396126026f01", "gif");
        FILE_TYPE_MAP.put("424d228c010000000000", "bmp");
        FILE_TYPE_MAP.put("424d8240090000000000", "bmp");
        FILE_TYPE_MAP.put("424d8e1b030000000000", "bmp");
        return FILE_TYPE_MAP;
    }

    private static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder();
        if (null == src || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMD5(File file) {
        FileInputStream fileInputStream = null;
        try {
            int length;
            MessageDigest MD5 = MessageDigest.getInstance("MD5");
            fileInputStream = new FileInputStream(file);
            byte[] buffer = new byte[8192];
            while ((length = fileInputStream.read(buffer)) != -1) {
                MD5.update(buffer, 0, length);
            }
            String string = new String(Hex.encodeHex((byte[])MD5.digest()));
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = "";
            return string;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public class TrustAnyHostnameVerifier
    implements HostnameVerifier {
        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

