/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.yeepay.base.utils;

import com.alibaba.common.lang.StringUtil;
import com.google.common.collect.Maps;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil
extends DateUtils {
    public static final String SIMPLE_DATE_FORMAT = "yyyy-MM-dd";
    public static final String SIMPLE_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String SIMPLE_TIME_FORMAT = "HH:mm:ss";
    public static final String NUMBER_DATE_FORMAT = "yyyyMMdd";
    public static final String NUMBER_DATE_TIME_FORMAT = "yyyyMMddHHmmss";
    private static final Logger LOGGER = LoggerFactory.getLogger(DateUtil.class);
    private static final TimeZone TIMEZONE_EST = TimeZone.getTimeZone("EST");
    private static final TimeZone TIMEZONE_GMT = TimeZone.getTimeZone("GMT+8");
    private static final long DAY_MILLI = 86400000L;

    public static Date parseDate(String str, String parsePatterns) throws ParseException {
        return DateUtil.parseDate((String)str, (String[])new String[]{parsePatterns});
    }

    public static int compareDate(Date date, Date otherDate, int withUnit) {
        Calendar dateCal = Calendar.getInstance();
        dateCal.setTime(date);
        Calendar otherDateCal = Calendar.getInstance();
        otherDateCal.setTime(otherDate);
        switch (withUnit) {
            case 1: {
                dateCal.clear(2);
                otherDateCal.clear(2);
                break;
            }
            case 2: {
                dateCal.set(5, 1);
                otherDateCal.set(5, 1);
                break;
            }
            case 5: {
                dateCal.set(11, 0);
                otherDateCal.set(11, 0);
                break;
            }
            case 10: {
                dateCal.clear(12);
                otherDateCal.clear(12);
                break;
            }
            case 12: {
                dateCal.clear(13);
                otherDateCal.clear(13);
                break;
            }
            case 13: {
                dateCal.clear(14);
                otherDateCal.clear(14);
                break;
            }
            case 14: {
                break;
            }
            default: {
                throw new IllegalArgumentException("withUnit \u5355\u4f4d\u5b57\u6bb5 " + withUnit + " \u4e0d\u5408\u6cd5\uff01\uff01");
            }
        }
        return dateCal.compareTo(otherDateCal);
    }

    public static int compareTime(Date date, Date otherDate, int withUnit) {
        Calendar dateCal = Calendar.getInstance();
        dateCal.setTime(date);
        Calendar otherDateCal = Calendar.getInstance();
        otherDateCal.setTime(otherDate);
        dateCal.clear(1);
        dateCal.clear(2);
        dateCal.set(5, 1);
        otherDateCal.clear(1);
        otherDateCal.clear(2);
        otherDateCal.set(5, 1);
        switch (withUnit) {
            case 10: {
                dateCal.clear(12);
                otherDateCal.clear(12);
                break;
            }
            case 12: {
                dateCal.clear(13);
                otherDateCal.clear(13);
                break;
            }
            case 13: {
                dateCal.clear(14);
                otherDateCal.clear(14);
                break;
            }
            case 14: {
                break;
            }
            default: {
                throw new IllegalArgumentException("withUnit \u5355\u4f4d\u5b57\u6bb5 " + withUnit + " \u4e0d\u5408\u6cd5\uff01\uff01");
            }
        }
        return dateCal.compareTo(otherDateCal);
    }

    public static long nowTimeMillis() {
        return System.currentTimeMillis();
    }

    public static Timestamp nowTimeStamp() {
        return new Timestamp(DateUtil.nowTimeMillis());
    }

    public static String getReqDate() {
        return DateFormatUtils.format((Date)new Date(), (String)SIMPLE_DATE_FORMAT);
    }

    public static String getReqDate(Date date) {
        return DateFormatUtils.format((Date)date, (String)SIMPLE_DATE_FORMAT);
    }

    public static String getReqDateyyyyMMdd(Date date) {
        return DateFormatUtils.format((Date)date, (String)NUMBER_DATE_FORMAT);
    }

    public static String timestampToDateStr(Timestamp tmp) {
        return DateFormatUtils.format((Date)tmp, (String)SIMPLE_DATE_FORMAT);
    }

    public static String getReqTime() {
        return DateFormatUtils.format((Date)new Date(), (String)SIMPLE_TIME_FORMAT);
    }

    public static String getReqTime(Date date) {
        return DateFormatUtils.format((Date)date, (String)SIMPLE_TIME_FORMAT);
    }

    public static String getTimeStampStr(Date date) {
        return DateFormatUtils.format((Date)date, (String)SIMPLE_DATETIME_FORMAT);
    }

    public static String getLongDateStr() {
        return DateFormatUtils.format((Date)new Date(), (String)SIMPLE_DATETIME_FORMAT);
    }

    public static String getLongDateStr(Timestamp time) {
        return DateFormatUtils.format((Date)time, (String)SIMPLE_DATETIME_FORMAT);
    }

    public static String getShortDateStr(Date date) {
        return DateFormatUtils.format((Date)date, (String)SIMPLE_DATE_FORMAT);
    }

    public static String getShortDateStr() {
        return DateFormatUtils.format((Date)new Date(), (String)SIMPLE_DATE_FORMAT);
    }

    public static Date addSecond(Date date, int second) {
        return DateUtil.addSeconds((Date)date, (int)second);
    }

    public static Date addMinute(Date date, int minute) {
        return DateUtil.addMinutes((Date)date, (int)minute);
    }

    public static Date addHour(Date date, int hour) {
        return DateUtil.addHours((Date)date, (int)hour);
    }

    public static Date addDay(Date date, int day) {
        return DateUtil.addDays((Date)date, (int)day);
    }

    public static Date addYear(Date date, int year) {
        return DateUtil.addYears((Date)date, (int)year);
    }

    public static Date getDayStart(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getDayEnd(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(5, 1);
        calendar.add(14, -1);
        return calendar.getTime();
    }

    public static Date getMonthEnd(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(2, 1);
        calendar.add(14, -1);
        return calendar.getTime();
    }

    public static long daysBetween(Timestamp t1, Timestamp t2) {
        return (t2.getTime() - t1.getTime()) / 86400000L;
    }

    public static int getWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        return cal.get(7);
    }

    public static Date getWeekStart(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.get(3);
        int firstDay = calendar.getFirstDayOfWeek();
        calendar.set(7, firstDay);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getWeekEnd(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.get(3);
        int firstDay = calendar.getFirstDayOfWeek();
        calendar.set(7, 8 - firstDay);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getMonthStart(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getYearStart(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(1, calendar.get(1));
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getYearEnd(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(1, calendar.get(1));
        calendar.set(2, 11);
        calendar.set(5, 31);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static int getDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.getActualMaximum(5);
    }

    public static Date getFirstDateOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, c.getActualMinimum(5));
        return c.getTime();
    }

    public static Date getLastDateOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, c.getActualMaximum(5));
        return c.getTime();
    }

    public static Date getSeasonStart(Date date) {
        return DateUtil.getDayStart(DateUtil.getFirstDateOfMonth(DateUtil.getSeasonDate(date)[0]));
    }

    public static Date getSeasonEnd(Date date) {
        return DateUtil.getDayEnd(DateUtil.getLastDateOfMonth(DateUtil.getSeasonDate(date)[2]));
    }

    public static Date[] getSeasonDate(Date date) {
        Date[] season = new Date[3];
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int nSeason = DateUtil.getSeason(date);
        if (nSeason == 1) {
            c.set(2, 0);
            season[0] = c.getTime();
            c.set(2, 1);
            season[1] = c.getTime();
            c.set(2, 2);
            season[2] = c.getTime();
        } else if (nSeason == 2) {
            c.set(2, 3);
            season[0] = c.getTime();
            c.set(2, 4);
            season[1] = c.getTime();
            c.set(2, 5);
            season[2] = c.getTime();
        } else if (nSeason == 3) {
            c.set(2, 6);
            season[0] = c.getTime();
            c.set(2, 7);
            season[1] = c.getTime();
            c.set(2, 8);
            season[2] = c.getTime();
        } else if (nSeason == 4) {
            c.set(2, 9);
            season[0] = c.getTime();
            c.set(2, 10);
            season[1] = c.getTime();
            c.set(2, 11);
            season[2] = c.getTime();
        }
        return season;
    }

    public static int getSeason(Date date) {
        int season = 0;
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int month = c.get(2);
        switch (month) {
            case 0: 
            case 1: 
            case 2: {
                season = 1;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                season = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                season = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                season = 4;
                break;
            }
        }
        return season;
    }

    public static int getWeekIndex(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(7);
    }

    public static Date subDays(int days) {
        Date date = DateUtil.addDay(new Date(), -days);
        String dateStr = DateUtil.getReqDate(date);
        Date date1 = null;
        try {
            date1 = DateUtil.parseDate(dateStr, SIMPLE_DATE_FORMAT);
        }
        catch (ParseException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return date1;
    }

    public static boolean isOverIntervalLimit(Date startDate, Date endDate, int interval, int dateUnit) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(dateUnit, interval * -1);
        Date curDate = DateUtil.getDayStart(cal.getTime());
        return DateUtil.getDayStart(startDate).compareTo(curDate) < 0 || DateUtil.getDayStart(endDate).compareTo(curDate) < 0;
    }

    public static boolean isOverIntervalLimit(Date startDate, Date endDate, int interval) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(5, interval * -1);
        Date curDate = DateUtil.getDayStart(cal.getTime());
        return DateUtil.getDayStart(startDate).compareTo(curDate) < 0 || DateUtil.getDayStart(endDate).compareTo(curDate) < 0;
    }

    public static boolean isOverIntervalLimit(String startDateStr, String endDateStr, int interval) {
        Date startDate = null;
        Date endDate = null;
        try {
            startDate = DateUtil.parseDate(startDateStr, SIMPLE_DATE_FORMAT);
            endDate = DateUtil.parseDate(endDateStr, SIMPLE_DATE_FORMAT);
        }
        catch (ParseException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return DateUtil.isOverIntervalLimit(startDate, endDate, interval);
    }

    public static String getYesterday() {
        return DateFormatUtils.format((Date)DateUtil.addDay(new Date(), -1), (String)SIMPLE_DATE_FORMAT);
    }

    public static List<String> getLastDays(int countDay) {
        ArrayList<String> listDate = new ArrayList<String>();
        for (int i = 0; i < countDay; ++i) {
            listDate.add(DateUtil.getReqDateyyyyMMdd(DateUtil.addDay(new Date(), -i)));
        }
        return listDate;
    }

    public static Date dateFormat(Date date) throws ParseException {
        return DateUtil.parseDate(DateFormatUtils.format((Date)date, (String)SIMPLE_DATE_FORMAT), SIMPLE_DATE_FORMAT);
    }

    public static String formatDateTime(Date date) {
        return FastDateFormat.getInstance((String)SIMPLE_DATETIME_FORMAT).format(date);
    }

    public static String format(Date date, String pattern) {
        return DateFormatUtils.format((Date)date, (String)pattern);
    }

    public static boolean isScopeByThreeMonth(Integer createDay) {
        Integer today = Integer.valueOf(DateTime.now().toString(NUMBER_DATE_FORMAT));
        Integer threeMonth = Integer.valueOf(DateTime.now().plusMonths(-3).toString(NUMBER_DATE_FORMAT));
        return createDay >= threeMonth && createDay < today;
    }

    public static boolean isScopeByThreeMonthAndToday(Integer createDay) {
        Integer today = Integer.valueOf(DateTime.now().toString(NUMBER_DATE_FORMAT));
        Integer threeMonth = Integer.valueOf(DateTime.now().plusMonths(-3).toString(NUMBER_DATE_FORMAT));
        return createDay >= threeMonth && createDay <= today;
    }

    public static String getNowDateTimeStr() {
        return DateTime.now().toString(NUMBER_DATE_TIME_FORMAT);
    }

    public static String getNowDateStr() {
        return DateTime.now().toString(NUMBER_DATE_FORMAT);
    }

    public static int getNowDate() {
        return Integer.valueOf(DateTime.now().toString(NUMBER_DATE_FORMAT));
    }

    public static Date getWxPayAcrossDayTime() {
        DateTime now = DateTime.now();
        DateTime endTime = new DateTime(now.getYear(), now.getMonthOfYear(), now.getDayOfMonth(), 23, 54, 59);
        if (endTime.isBeforeNow()) {
            endTime = now.plusMinutes(5);
        }
        return endTime.toDate();
    }

    public static String getWxPayAcrossDayTimeNew() {
        Calendar todayEnd = Calendar.getInstance();
        todayEnd.set(11, 23);
        todayEnd.set(12, 59);
        todayEnd.set(13, 59);
        SimpleDateFormat format = new SimpleDateFormat(NUMBER_DATE_TIME_FORMAT);
        return format.format(todayEnd.getTime());
    }

    public static Date toDate(String dateStr, String dateFormat) {
        String str = dateStr.trim();
        if (StringUtil.isEmpty((String)dateFormat)) {
            if (str.matches("\\d{4}-\\d{1,2}-\\d{1,2}\\s+\\d{1,2}:\\d{1,2}:\\d{1,2}")) {
                dateFormat = SIMPLE_DATETIME_FORMAT;
            } else if (str.matches("\\d{4}-\\d{1,2}-\\d{1,2}")) {
                dateFormat = SIMPLE_DATE_FORMAT;
            }
        }
        SimpleDateFormat df = new SimpleDateFormat(dateFormat);
        try {
            return df.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, Long> getStartAndEndByDay(String day) {
        DateTime dayTime = DateTime.parse((String)day, (DateTimeFormatter)DateTimeFormat.forPattern((String)NUMBER_DATE_FORMAT));
        long startTime = dayTime.withTimeAtStartOfDay().getMillis();
        long endTime = dayTime.plusDays(1).withTimeAtStartOfDay().getMillis();
        HashMap params = Maps.newHashMap();
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        return params;
    }

    public static Map<String, Long> getCurrentStartAndEnd() {
        return DateUtil.getStartAndEndByDay(DateTime.now().toString(NUMBER_DATE_FORMAT));
    }

    public static Date toDate(long m) {
        Calendar c1 = Calendar.getInstance();
        c1.setTimeInMillis(m);
        return c1.getTime();
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.getWxPayAcrossDayTimeNew());
    }

    public static long formatMillis(String time, String formatType) {
        SimpleDateFormat format = new SimpleDateFormat(formatType);
        try {
            Date date = format.parse(time);
            return date.getTime();
        }
        catch (ParseException e) {
            return 0L;
        }
    }

    public static String getDateByDay(String day) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(NUMBER_DATE_FORMAT);
            Date date = simpleDateFormat.parse(day);
            return new SimpleDateFormat(SIMPLE_DATE_FORMAT).format(date);
        }
        catch (Exception e) {
            return day.toString();
        }
    }
}

