/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.yeepay.base.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtil {
    private static Logger LOGGER = LoggerFactory.getLogger(CommonUtil.class);

    public static String getDealStr(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return "";
        }
        return str;
    }

    public static String getDefaultIfBlank(Object obj, String defaultStr) {
        if (StringUtils.isEmpty((CharSequence)defaultStr)) {
            defaultStr = "";
        }
        if (obj == null) {
            return defaultStr;
        }
        String tmp = obj.toString();
        return (String)StringUtils.defaultIfBlank((CharSequence)tmp, (CharSequence)defaultStr);
    }

    public static Map<String, String> checkMethodIsNull(Object obj, Set<String> set) {
        if (CollectionUtils.isEmpty(set) || null == obj) {
            return null;
        }
        int initialCapacity = set.size() * 2;
        HashMap<String, String> resultMap = new HashMap<String, String>(initialCapacity);
        try {
            Class<?> aClass = obj.getClass();
            for (String methodStr : set) {
                Method method = aClass.getMethod(methodStr, new Class[0]);
                Object invoke = method.invoke(obj, new Object[0]);
                if (invoke == null || "".equals(invoke)) continue;
                resultMap.put(invoke.toString(), methodStr);
            }
        }
        catch (IllegalAccessException e) {
            LOGGER.error("checkMethodIsNull >> IllegalAccessException >> {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (InvocationTargetException e) {
            LOGGER.error("checkMethodIsNull >> InvocationTargetException >> {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("checkMethodIsNull >> NoSuchMethodException >> {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
        return resultMap;
    }
}

