/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.yeepay.base.redis;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.redisson.Redisson;
import org.redisson.api.RBucket;
import org.redisson.api.RList;
import org.redisson.api.RLock;
import org.redisson.api.RMapCache;
import org.redisson.api.RSet;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RedisCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisCache.class);
    private static final Long DEFAULT_EXPIRED = 300L;
    private RedissonClient redisson;
    private String host;
    private String password;
    private Integer connectTimeout;
    private static final String REDIS_KEY_PREFIX = "yeepay.sxpay.";

    @PostConstruct
    public void init() throws IOException {
        Config config = new Config();
        ((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)config.useSingleServer().setAddress(this.host).setPassword(this.password)).setDatabase(0).setFailedAttempts(3)).setPingTimeout(3000)).setTimeout(5000)).setSubscriptionConnectionMinimumIdleSize(1).setSubscriptionConnectionPoolSize(256).setConnectTimeout(this.connectTimeout.intValue())).setReconnectionTimeout(3000)).setConnectionPoolSize(256).setConnectionMinimumIdleSize(1).setRetryAttempts(3)).setRetryInterval(3000)).setIdleConnectionTimeout(30000)).setClientName("com.fshows.yeepay.redisclient");
        if (this.redisson == null) {
            this.redisson = Redisson.create((Config)config);
            LOGGER.info("redis\u8fde\u63a5\u6210\u529f,server={}", (Object)this.host);
        } else {
            LOGGER.warn("redis \u91cd\u590d\u8fde\u63a5,config={}", (Object)config);
        }
    }

    public <T> T get(String key) {
        RBucket bucket = this.redisson.getBucket(REDIS_KEY_PREFIX + key);
        return (T)bucket.get();
    }

    public <T> void put(String key, T value) {
        RBucket bucket = this.redisson.getBucket(REDIS_KEY_PREFIX + key);
        bucket.set(value, DEFAULT_EXPIRED.longValue(), TimeUnit.SECONDS);
    }

    public <T> void put(String key, T value, int expired) {
        RBucket bucket = this.redisson.getBucket(REDIS_KEY_PREFIX + key);
        bucket.set(value, expired <= 0 ? DEFAULT_EXPIRED : (long)expired, TimeUnit.SECONDS);
    }

    public void remove(String key) {
        this.redisson.getBucket(REDIS_KEY_PREFIX + key).delete();
    }

    public boolean exists(String key) {
        return this.redisson.getBucket(REDIS_KEY_PREFIX + key).isExists();
    }

    public <T> RList<T> getRedisList(String key) {
        return this.redisson.getList(REDIS_KEY_PREFIX + key);
    }

    public <K, V> RMapCache<K, V> getRedisMap(String key) {
        return this.redisson.getMapCache(REDIS_KEY_PREFIX + key);
    }

    public <T> RSet getRedisSet(String key) {
        return this.redisson.getSet(REDIS_KEY_PREFIX + key);
    }

    public RLock getRedisLock(String key) {
        return this.redisson.getLock(REDIS_KEY_PREFIX + key);
    }

    @PreDestroy
    public void close() {
        try {
            if (this.redisson != null) {
                this.redisson.shutdown();
            }
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }
}

