/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.yeepay.base.utils.unionpay;

import com.fshows.yeepay.base.utils.unionpay.SDKConfig;
import com.fshows.yeepay.base.utils.unionpay.SDKUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.spec.RSAPublicKeySpec;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CertUtil.class);
    private static final Map<String, KeyStore> keyStoreMap = new ConcurrentHashMap<String, KeyStore>();
    private static SDKConfig config = SDKConfig.getConfig();
    private static KeyStore keyStore = null;
    private static X509Certificate encryptCert = null;
    private static PublicKey encryptTrackKey = null;
    private static X509Certificate validateCert = null;
    private static X509Certificate middleCert = null;
    private static X509Certificate rootCert = null;
    private static Map<String, X509Certificate> certMap = new HashMap<String, X509Certificate>();

    private static void init() {
        try {
            CertUtil.addProvider();
            CertUtil.initSignCert();
            CertUtil.initMiddleCert();
            CertUtil.initRootCert();
            CertUtil.initEncryptCert();
            CertUtil.initTrackKey();
            CertUtil.initValidateCertFromDir();
        }
        catch (Exception e) {
            LOGGER.error("init\u5931\u8d25\u3002\uff08\u5982\u679c\u662f\u7528\u5bf9\u79f0\u5bc6\u94a5\u7b7e\u540d\u7684\u53ef\u65e0\u89c6\u6b64\u5f02\u5e38\u3002\uff09", (Throwable)e);
        }
    }

    private static void addProvider() {
        if (Security.getProvider("BC") == null) {
            LOGGER.info("add BC provider");
            Security.addProvider((Provider)new BouncyCastleProvider());
        } else {
            Security.removeProvider("BC");
            Security.addProvider((Provider)new BouncyCastleProvider());
            LOGGER.info("re-add BC provider");
        }
        CertUtil.printSysInfo();
    }

    private static void initSignCert() {
        if (!"01".equals(config.getSignMethod())) {
            LOGGER.info("\u975ersa\u7b7e\u540d\u65b9\u5f0f\uff0c\u4e0d\u52a0\u8f7d\u7b7e\u540d\u8bc1\u4e66\u3002");
            return;
        }
        if (config.getSignCertPath() == null || config.getSignCertPwd() == null || config.getSignCertType() == null) {
            LOGGER.error("WARN: acpsdk.signCert.path\u6216acpsdk.signCert.pwd\u6216acpsdk.signCert.type\u4e3a\u7a7a\u3002 \u505c\u6b62\u52a0\u8f7d\u7b7e\u540d\u8bc1\u4e66\u3002");
            return;
        }
        if (null != keyStore) {
            keyStore = null;
        }
        try {
            keyStore = CertUtil.getKeyInfo(config.getSignCertPath(), config.getSignCertPwd(), SDKConfig.getConfig().getSignCertType());
            LOGGER.info("InitSignCert Successful. CertId=[" + CertUtil.getSignCertId() + "]");
        }
        catch (IOException e) {
            LOGGER.error("InitSignCert Error", (Throwable)e);
        }
    }

    private static void initMiddleCert() {
        LOGGER.info("\u52a0\u8f7d\u4e2d\u7ea7\u8bc1\u4e66==>" + config.getMiddleCertPath());
        if (!SDKUtil.isEmpty(config.getMiddleCertPath())) {
            middleCert = CertUtil.initCert(config.getMiddleCertPath());
            LOGGER.info("Load MiddleCert Successful");
        } else {
            LOGGER.info("WARN: acpsdk.middle.path is empty");
        }
    }

    private static void initRootCert() {
        LOGGER.info("\u52a0\u8f7d\u6839\u8bc1\u4e66==>" + config.getRootCertPath());
        if (!SDKUtil.isEmpty(config.getRootCertPath())) {
            rootCert = CertUtil.initCert(config.getRootCertPath());
            LOGGER.info("Load RootCert Successful");
        } else {
            LOGGER.info("WARN: acpsdk.rootCert.path is empty");
        }
    }

    private static void initEncryptCert() {
        LOGGER.info("\u52a0\u8f7d\u654f\u611f\u4fe1\u606f\u52a0\u5bc6\u8bc1\u4e66==>" + config.getEncryptCertPath());
        if (!SDKUtil.isEmpty(config.getEncryptCertPath())) {
            encryptCert = CertUtil.initCert(config.getEncryptCertPath());
            LOGGER.info("Load EncryptCert Successful");
        } else {
            LOGGER.info("WARN: acpsdk.encryptCert.path is empty");
        }
    }

    private static void initTrackKey() {
        if (!SDKUtil.isEmpty(config.getEncryptTrackKeyModulus()) && !SDKUtil.isEmpty(config.getEncryptTrackKeyExponent())) {
            encryptTrackKey = CertUtil.getPublicKey(config.getEncryptTrackKeyModulus(), config.getEncryptTrackKeyExponent());
            LOGGER.info("LoadEncryptTrackKey Successful");
        } else {
            LOGGER.info("WARN: acpsdk.encryptTrackKey.modulus or acpsdk.encryptTrackKey.exponent is empty");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initValidateCertFromDir() {
        if (!"01".equals(config.getSignMethod())) {
            LOGGER.info("\u975ersa\u7b7e\u540d\u65b9\u5f0f\uff0c\u4e0d\u52a0\u8f7d\u9a8c\u7b7e\u8bc1\u4e66\u3002");
            return;
        }
        certMap.clear();
        String dir = config.getValidateCertDir();
        LOGGER.info("\u52a0\u8f7d\u9a8c\u8bc1\u7b7e\u540d\u8bc1\u4e66\u76ee\u5f55==>" + dir + " \u6ce8\uff1a\u5982\u679c\u8bf7\u6c42\u62a5\u6587\u4e2dversion=5.1.0\u90a3\u4e48\u6b64\u9a8c\u7b7e\u8bc1\u4e66\u76ee\u5f55\u4f7f\u7528\u4e0d\u5230\uff0c\u53ef\u4ee5\u4e0d\u9700\u8981\u8bbe\u7f6e\uff08version=5.0.0\u5fc5\u987b\u8bbe\u7f6e\uff09\u3002");
        if (SDKUtil.isEmpty(dir)) {
            LOGGER.error("WARN: acpsdk.validateCert.dir is empty");
            return;
        }
        CertificateFactory cf = null;
        InputStream in = null;
        try {
            cf = CertificateFactory.getInstance("X.509", "BC");
        }
        catch (NoSuchProviderException e) {
            LOGGER.error("LoadVerifyCert Error: No BC Provider", (Throwable)e);
            return;
        }
        catch (CertificateException e) {
            LOGGER.error("LoadVerifyCert Error", (Throwable)e);
            return;
        }
        File fileDir = new File(dir);
        File[] files = fileDir.listFiles(new CerFilter());
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            try {
                System.out.println("====initValidateCertFromDir===" + file.getAbsolutePath());
                in = new FileInputStream(file.getAbsolutePath());
                validateCert = (X509Certificate)cf.generateCertificate(in);
                if (validateCert == null) {
                    LOGGER.error("Load verify cert error, " + file.getAbsolutePath() + " has error cert content.");
                    continue;
                }
                certMap.put(validateCert.getSerialNumber().toString(), validateCert);
                LOGGER.info("[" + file.getAbsolutePath() + "][CertId=" + validateCert.getSerialNumber().toString() + "]");
                continue;
            }
            catch (CertificateException e) {
                LOGGER.error("LoadVerifyCert Error", (Throwable)e);
                continue;
            }
            catch (FileNotFoundException e) {
                LOGGER.error("LoadVerifyCert Error File Not Found", (Throwable)e);
                continue;
            }
            finally {
                if (null != in) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        LOGGER.error(e.toString());
                    }
                }
            }
        }
        LOGGER.info("LoadVerifyCert Finish");
    }

    private static void loadSignCert(String certFilePath, String certPwd) {
        KeyStore keyStore = null;
        try {
            keyStore = CertUtil.getKeyInfo(certFilePath, certPwd, "PKCS12");
            keyStoreMap.put(certFilePath, keyStore);
            LOGGER.info("LoadRsaCert Successful");
        }
        catch (IOException e) {
            LOGGER.error("LoadRsaCert Error", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate initCert(String path) {
        X509Certificate encryptCertTemp = null;
        CertificateFactory cf = null;
        InputStream in = null;
        try {
            cf = CertificateFactory.getInstance("X.509", "BC");
            in = CertUtil.class.getResourceAsStream(path);
            encryptCertTemp = (X509Certificate)cf.generateCertificate(in);
            LOGGER.info("[" + path + "][CertId=" + encryptCertTemp.getSerialNumber().toString() + "]");
        }
        catch (CertificateException e) {
            LOGGER.error("InitCert Error", (Throwable)e);
        }
        catch (NoSuchProviderException e) {
            LOGGER.error("LoadVerifyCert Error No BC Provider", (Throwable)e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOGGER.error(e.toString());
                }
            }
        }
        return encryptCertTemp;
    }

    public static PrivateKey getSignCertPrivateKey() {
        try {
            Enumeration<String> aliasenum = keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(keyAlias, config.getSignCertPwd().toCharArray());
            return privateKey;
        }
        catch (KeyStoreException e) {
            LOGGER.error("getSignCertPrivateKey Error", (Throwable)e);
            return null;
        }
        catch (UnrecoverableKeyException e) {
            LOGGER.error("getSignCertPrivateKey Error", (Throwable)e);
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("getSignCertPrivateKey Error", (Throwable)e);
            return null;
        }
    }

    public static PrivateKey getSignCertPrivateKeyByStoreMap(String certPath, String certPwd) {
        if (!keyStoreMap.containsKey(certPath)) {
            CertUtil.loadSignCert(certPath, certPwd);
        }
        try {
            Enumeration<String> aliasenum = keyStoreMap.get(certPath).aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            PrivateKey privateKey = (PrivateKey)keyStoreMap.get(certPath).getKey(keyAlias, certPwd.toCharArray());
            return privateKey;
        }
        catch (KeyStoreException e) {
            LOGGER.error("getSignCertPrivateKeyByStoreMap Error", (Throwable)e);
            return null;
        }
        catch (UnrecoverableKeyException e) {
            LOGGER.error("getSignCertPrivateKeyByStoreMap Error", (Throwable)e);
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("getSignCertPrivateKeyByStoreMap Error", (Throwable)e);
            return null;
        }
    }

    public static PublicKey getEncryptCertPublicKey() {
        if (null == encryptCert) {
            String path = config.getEncryptCertPath();
            if (!SDKUtil.isEmpty(path)) {
                encryptCert = CertUtil.initCert(path);
                return encryptCert.getPublicKey();
            }
            LOGGER.error("acpsdk.encryptCert.path is empty");
            return null;
        }
        return encryptCert.getPublicKey();
    }

    public static void resetEncryptCertPublicKey() {
        encryptCert = null;
    }

    public static PublicKey getEncryptTrackPublicKey() {
        if (null == encryptTrackKey) {
            CertUtil.initTrackKey();
        }
        return encryptTrackKey;
    }

    public static PublicKey getValidatePublicKey(String certId) {
        X509Certificate cf = null;
        if (certMap.containsKey(certId)) {
            cf = certMap.get(certId);
            return cf.getPublicKey();
        }
        CertUtil.initValidateCertFromDir();
        if (certMap.containsKey(certId)) {
            cf = certMap.get(certId);
            return cf.getPublicKey();
        }
        LOGGER.error("\u7f3a\u5c11certId=[" + certId + "]\u5bf9\u5e94\u7684\u9a8c\u7b7e\u8bc1\u4e66.");
        return null;
    }

    public static String getSignCertId() {
        try {
            Enumeration<String> aliasenum = keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            X509Certificate cert = (X509Certificate)keyStore.getCertificate(keyAlias);
            return cert.getSerialNumber().toString();
        }
        catch (Exception e) {
            LOGGER.error("getSignCertId Error", (Throwable)e);
            return null;
        }
    }

    public static String getEncryptCertId() {
        if (null == encryptCert) {
            String path = config.getEncryptCertPath();
            if (!SDKUtil.isEmpty(path)) {
                encryptCert = CertUtil.initCert(path);
                return encryptCert.getSerialNumber().toString();
            }
            LOGGER.error("acpsdk.encryptCert.path is empty");
            return null;
        }
        return encryptCert.getSerialNumber().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore getKeyInfo(String pfxkeyfile, String keypwd, String type) throws IOException {
        LOGGER.info("\u52a0\u8f7d\u7b7e\u540d\u8bc1\u4e66==>" + pfxkeyfile);
        InputStream fis = null;
        try {
            KeyStore ks = KeyStore.getInstance(type, "BC");
            LOGGER.info("Load RSA CertPath=[" + pfxkeyfile + "],Pwd=[" + keypwd + "],type=[" + type + "]");
            fis = CertUtil.class.getResourceAsStream(pfxkeyfile);
            char[] nPassword = null;
            char[] cArray = nPassword = null == keypwd || "".equals(keypwd.trim()) ? null : keypwd.toCharArray();
            if (null != ks) {
                ks.load(fis, nPassword);
            }
            System.out.println("=====load key info LOWER_CASE_SUCCESS=====");
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (Exception e) {
            LOGGER.error("getKeyInfo Error", (Throwable)e);
            KeyStore keyStore = null;
            return keyStore;
        }
        finally {
            if (null != fis) {
                fis.close();
            }
        }
    }

    public static String getCertIdByKeyStoreMap(String certPath, String certPwd) {
        if (!keyStoreMap.containsKey(certPath)) {
            CertUtil.loadSignCert(certPath, certPwd);
        }
        return CertUtil.getCertIdIdByStore(keyStoreMap.get(certPath));
    }

    private static String getCertIdIdByStore(KeyStore keyStore) {
        Enumeration<String> aliasenum = null;
        try {
            aliasenum = keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            X509Certificate cert = (X509Certificate)keyStore.getCertificate(keyAlias);
            return cert.getSerialNumber().toString();
        }
        catch (KeyStoreException e) {
            LOGGER.error("getCertIdIdByStore Error", (Throwable)e);
            return null;
        }
    }

    private static PublicKey getPublicKey(String modulus, String exponent) {
        try {
            BigInteger b1 = new BigInteger(modulus);
            BigInteger b2 = new BigInteger(exponent);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(b1, b2);
            return keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            LOGGER.error("\u6784\u9020RSA\u516c\u94a5\u5931\u8d25\uff1a" + e);
            return null;
        }
    }

    public static X509Certificate genCertificateByStr(String x509CertString) {
        X509Certificate x509Cert = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            ByteArrayInputStream tIn = new ByteArrayInputStream(x509CertString.getBytes("ISO-8859-1"));
            x509Cert = (X509Certificate)cf.generateCertificate(tIn);
        }
        catch (Exception e) {
            LOGGER.error("gen certificate error", (Throwable)e);
        }
        return x509Cert;
    }

    public static X509Certificate getMiddleCert() {
        if (null == middleCert) {
            String path = config.getMiddleCertPath();
            if (!SDKUtil.isEmpty(path)) {
                CertUtil.initMiddleCert();
            } else {
                LOGGER.error("acpsdk.middleCert.path not set in " + SDKConfig.FILE_NAME);
                return null;
            }
        }
        return middleCert;
    }

    public static X509Certificate getRootCert() {
        if (null == rootCert) {
            String path = config.getRootCertPath();
            if (!SDKUtil.isEmpty(path)) {
                CertUtil.initRootCert();
            } else {
                LOGGER.error("acpsdk.rootCert.path not set in " + SDKConfig.FILE_NAME);
                return null;
            }
        }
        return rootCert;
    }

    private static String getIdentitiesFromCertficate(X509Certificate aCert) {
        String[] tSplitStr;
        String tDN = aCert.getSubjectDN().toString();
        String tPart = "";
        if (tDN != null && (tSplitStr = tDN.substring(tDN.indexOf("CN=")).split("@")) != null && tSplitStr.length > 2 && tSplitStr[2] != null) {
            tPart = tSplitStr[2];
        }
        return tPart;
    }

    private static boolean verifyCertificateChain(X509Certificate cert) {
        if (null == cert) {
            LOGGER.error("cert must Not null");
            return false;
        }
        X509Certificate middleCert = CertUtil.getMiddleCert();
        if (null == middleCert) {
            LOGGER.error("middleCert must Not null");
            return false;
        }
        X509Certificate rootCert = CertUtil.getRootCert();
        if (null == rootCert) {
            LOGGER.error("rootCert or cert must Not null");
            return false;
        }
        try {
            X509CertSelector selector = new X509CertSelector();
            selector.setCertificate(cert);
            HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
            trustAnchors.add(new TrustAnchor(rootCert, null));
            PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(trustAnchors, (CertSelector)selector);
            HashSet<X509Certificate> intermediateCerts = new HashSet<X509Certificate>();
            intermediateCerts.add(rootCert);
            intermediateCerts.add(middleCert);
            intermediateCerts.add(cert);
            pkixParams.setRevocationEnabled(false);
            CertStore intermediateCertStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(intermediateCerts), "BC");
            pkixParams.addCertStore(intermediateCertStore);
            CertPathBuilder builder = CertPathBuilder.getInstance("PKIX", "BC");
            PKIXCertPathBuilderResult result = (PKIXCertPathBuilderResult)builder.build(pkixParams);
            LOGGER.info("verify certificate chain succeed.");
            return true;
        }
        catch (CertPathBuilderException e) {
            LOGGER.error("verify certificate chain fail.", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("verify certificate chain exception: ", (Throwable)e);
        }
        return false;
    }

    public static boolean verifyCertificate(X509Certificate cert) {
        if (null == cert) {
            LOGGER.error("cert must Not null");
            return false;
        }
        try {
            cert.checkValidity();
            if (!CertUtil.verifyCertificateChain(cert)) {
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.error("verifyCertificate fail", (Throwable)e);
            return false;
        }
        if (config.isIfValidateCNName()) {
            if (!"\u4e2d\u56fd\u94f6\u8054\u80a1\u4efd\u6709\u9650\u516c\u53f8".equals(CertUtil.getIdentitiesFromCertficate(cert))) {
                LOGGER.error("cer owner is not CUP:" + CertUtil.getIdentitiesFromCertficate(cert));
                return false;
            }
        } else if (!"\u4e2d\u56fd\u94f6\u8054\u80a1\u4efd\u6709\u9650\u516c\u53f8".equals(CertUtil.getIdentitiesFromCertficate(cert)) && !"00040000:SIGN".equals(CertUtil.getIdentitiesFromCertficate(cert))) {
            LOGGER.error("cer owner is not CUP:" + CertUtil.getIdentitiesFromCertficate(cert));
            return false;
        }
        return true;
    }

    private static void printSysInfo() {
        LOGGER.info("================= SYS INFO begin====================");
        LOGGER.info("os_name:" + System.getProperty("os.name"));
        LOGGER.info("os_arch:" + System.getProperty("os.arch"));
        LOGGER.info("os_version:" + System.getProperty("os.version"));
        LOGGER.info("java_vm_specification_version:" + System.getProperty("java.vm.specification.version"));
        LOGGER.info("java_vm_specification_vendor:" + System.getProperty("java.vm.specification.vendor"));
        LOGGER.info("java_vm_specification_name:" + System.getProperty("java.vm.specification.name"));
        LOGGER.info("java_vm_version:" + System.getProperty("java.vm.version"));
        LOGGER.info("java_vm_name:" + System.getProperty("java.vm.name"));
        LOGGER.info("java.version:" + System.getProperty("java.version"));
        LOGGER.info("java.vm.vendor=[" + System.getProperty("java.vm.vendor") + "]");
        LOGGER.info("java.version=[" + System.getProperty("java.version") + "]");
        CertUtil.printProviders();
        LOGGER.info("================= SYS INFO end=====================");
    }

    private static void printProviders() {
        LOGGER.info("Providers List:");
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            LOGGER.info(i + 1 + "." + providers[i].getName());
        }
    }

    public static void main(String[] args) {
        System.out.println("a");
    }

    static {
        System.out.println("===init====== start==");
        CertUtil.init();
        System.out.println("===init======== end==");
    }

    static class CerFilter
    implements FilenameFilter {
        CerFilter() {
        }

        public boolean isCer(String name) {
            return name.toLowerCase().endsWith(".cer");
        }

        @Override
        public boolean accept(File dir, String name) {
            return this.isCer(name);
        }
    }
}

