/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.yeepay.base.utils;

import com.alibaba.fastjson.JSON;
import com.fshows.yeepay.base.constants.UnionComConstants;
import com.fshows.yeepay.base.utils.XMLParser;
import com.google.common.collect.Maps;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;

public class StringUtil {
    public static String getPostXml(Map map) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version='1.0' encoding='UTF-8'?>");
        sb.append("<xml>");
        for (String tmpKey : map.keySet()) {
            if (map.get(tmpKey) == null) continue;
            sb.append("<" + tmpKey + ">");
            sb.append("<![CDATA[").append(map.get(tmpKey)).append("]]>");
            sb.append("</" + tmpKey + ">");
        }
        sb.append("</xml>");
        return sb.toString();
    }

    public static Map<String, String> dealRspData(String rspData, String paraType) throws Exception {
        Map<String, String> retMap = new HashMap<String, String>();
        if (UnionComConstants.COMMEN.PARAM_TYPE_XML.equalsIgnoreCase(paraType)) {
            retMap = XMLParser.getMapFromXML(new String(rspData.getBytes("UTF-8")));
        } else if (UnionComConstants.COMMEN.PARAM_TYPE_JSON.equalsIgnoreCase(paraType)) {
            retMap = (Map)JSON.parseObject((String)rspData, Map.class);
        }
        return retMap;
    }

    public static <T> T map2Bean(Map<String, String> map, Class<T> class1) {
        T bean = null;
        try {
            bean = class1.newInstance();
            BeanUtils.populate(bean, map);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return bean;
    }

    public static Map<String, Object> bean2Map(Object javaBean) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(javaBean.getClass());
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            if (propertyDescriptors != null && propertyDescriptors.length > 0) {
                String propertyName = null;
                Object propertyValue = null;
                for (PropertyDescriptor pd : propertyDescriptors) {
                    Method readMethod;
                    propertyName = pd.getName();
                    if (propertyName.equals("class") || null == (propertyValue = (readMethod = pd.getReadMethod()).invoke(javaBean, new Object[0]))) continue;
                    map.put(propertyName, propertyValue);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static <T> T reflectSetFieldValue(T t) {
        try {
            for (Field f : t.getClass().getDeclaredFields()) {
                f.setAccessible(true);
                Class<?> c = f.getType();
                if (c != String.class || null != f.get(t)) continue;
                f.set(t, "");
            }
        }
        catch (IllegalAccessException e) {
            e.getStackTrace();
        }
        return t;
    }

    public static String formatUrlMap(Map<String, String> paraMap, boolean urlEncode, boolean keyToLower) {
        String buff = "";
        Map<String, String> tmpMap = paraMap;
        try {
            ArrayList<Map.Entry<String, String>> infoIds = new ArrayList<Map.Entry<String, String>>(tmpMap.entrySet());
            Collections.sort(infoIds, new Comparator<Map.Entry<String, String>>(){

                @Override
                public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                    return o1.getKey().toString().compareTo(o2.getKey());
                }
            });
            StringBuilder buf = new StringBuilder();
            for (Map.Entry entry : infoIds) {
                if (!StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getKey()))) continue;
                String key = (String)entry.getKey();
                String val = (String)entry.getValue();
                if (urlEncode) {
                    val = URLEncoder.encode(val, "utf-8");
                }
                if (keyToLower) {
                    buf.append(key.toLowerCase() + "=" + val);
                } else {
                    buf.append(key + "=" + val);
                }
                buf.append("&");
            }
            buff = buf.toString();
            if (!buff.isEmpty()) {
                buff = buff.substring(0, buff.length() - 1);
            }
        }
        catch (Exception e) {
            return null;
        }
        return buff;
    }
}

