/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.yeepay.base.utils;

import com.fshows.yeepay.base.unionpay.BaseHttpSSLSocketFactory;
import com.fshows.yeepay.base.utils.AsyncCallback;
import com.fshows.yeepay.base.utils.StringMap;
import com.fshows.yeepay.base.utils.SystemClock;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    public static final String JSON_MIME = "application/json";
    public static final String XML_MIME = "text/xml";
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpUtil.class);
    private static final int CONNECTION_TIME_OUT = 10;
    private static final int READ_TIME_OUT = 10;
    private static final int WRITE_TIME_OUT = 0;
    private static HttpUtil mInstance;
    private volatile OkHttpClient httpClient;

    private HttpUtil(int timeout, SSLSocketFactory socketFactory) {
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequests(64);
        dispatcher.setMaxRequestsPerHost(16);
        ConnectionPool connectionPool = new ConnectionPool();
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.dispatcher(dispatcher);
        builder.connectionPool(connectionPool);
        builder.addNetworkInterceptor(chain -> {
            Request request = chain.request();
            Response response = chain.proceed(request);
            IpTag tag = (IpTag)request.tag();
            try {
                tag.ip = chain.connection().socket().getRemoteSocketAddress().toString();
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                tag.ip = "";
            }
            return response;
        });
        builder.connectTimeout(10L, TimeUnit.SECONDS);
        builder.readTimeout(timeout == 0 ? 10L : (long)timeout, TimeUnit.SECONDS);
        builder.writeTimeout(0L, TimeUnit.SECONDS);
        builder.retryOnConnectionFailure(true);
        if (socketFactory == null) {
            socketFactory = HttpUtil.createSSLSocketFactory();
        }
        builder.sslSocketFactory(socketFactory, (X509TrustManager)new TrustAllManager());
        builder.hostnameVerifier((HostnameVerifier)new BaseHttpSSLSocketFactory.TrustAnyHostnameVerifier());
        this.httpClient = builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpUtil getInstance(int timeout, SSLSocketFactory socketFactory) {
        HttpUtil inst = mInstance;
        if (inst != null) return inst;
        Class<HttpUtil> clazz = HttpUtil.class;
        synchronized (HttpUtil.class) {
            inst = mInstance;
            if (inst != null) return inst;
            mInstance = inst = new HttpUtil(timeout, socketFactory);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return inst;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpUtil getInstance(int timeout) {
        HttpUtil inst = mInstance;
        if (inst != null) return inst;
        Class<HttpUtil> clazz = HttpUtil.class;
        synchronized (HttpUtil.class) {
            inst = mInstance;
            if (inst != null) return inst;
            mInstance = inst = new HttpUtil(timeout, null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return inst;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpUtil getInstance() {
        HttpUtil inst = mInstance;
        if (inst != null) return inst;
        Class<HttpUtil> clazz = HttpUtil.class;
        synchronized (HttpUtil.class) {
            inst = mInstance;
            if (inst != null) return inst;
            mInstance = inst = new HttpUtil(0, null);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return inst;
        }
    }

    private static SSLSocketFactory createSSLSocketFactory() {
        SSLSocketFactory sSLSocketFactory = null;
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, new TrustManager[]{new TrustAllManager()}, new SecureRandom());
            sSLSocketFactory = sc.getSocketFactory();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return sSLSocketFactory;
    }

    private static String utf8String(byte[] bytes) {
        return new String(bytes, Charset.forName("UTF-8"));
    }

    private static RequestBody create(final MediaType contentType, final byte[] content, final int offset, final int size) {
        if (content == null) {
            throw new NullPointerException("content == null");
        }
        return new RequestBody(){

            public MediaType contentType() {
                return contentType;
            }

            public long contentLength() {
                return size;
            }

            public void writeTo(BufferedSink sink) throws IOException {
                sink.write(content, offset, size);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url, Map<String, Object> params) {
        int statusCode;
        String result;
        String apiUrl;
        StringBuilder builder;
        long start;
        block9: {
            start = System.currentTimeMillis();
            builder = new StringBuilder();
            int i = 0;
            for (String key : params.keySet()) {
                if (i == 0) {
                    builder.append("?");
                } else {
                    builder.append("&");
                }
                builder.append(key).append("=").append(params.get(key));
                ++i;
            }
            apiUrl = url + builder.toString();
            result = null;
            CloseableHttpClient httpclient = HttpClients.createDefault();
            statusCode = -999;
            try {
                HttpGet httpGet = new HttpGet(apiUrl);
                RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(10000).setConnectTimeout(10000).setSocketTimeout(10000).build();
                httpGet.setConfig(requestConfig);
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
                statusCode = response.getStatusLine().getStatusCode();
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    InputStream instream = entity.getContent();
                    result = IOUtils.toString((InputStream)instream, (String)"UTF-8");
                }
                if (httpclient == null) break block9;
            }
            catch (Exception ex) {
                block10: {
                    try {
                        LOGGER.error("httputil get error:" + ex.getMessage(), (Throwable)ex);
                        if (httpclient == null) break block10;
                    }
                    catch (Throwable throwable) {
                        if (httpclient != null) {
                            HttpClientUtils.closeQuietly((HttpClient)httpclient);
                        }
                        LOGGER.info("request to:{},builder:{},response code:{},result:{},cost {} ms", new Object[]{apiUrl, builder.toString(), statusCode, result, System.currentTimeMillis() - start});
                        throw throwable;
                    }
                    HttpClientUtils.closeQuietly((HttpClient)httpclient);
                }
                LOGGER.info("request to:{},builder:{},response code:{},result:{},cost {} ms", new Object[]{apiUrl, builder.toString(), statusCode, result, System.currentTimeMillis() - start});
            }
            HttpClientUtils.closeQuietly((HttpClient)httpclient);
        }
        LOGGER.info("request to:{},builder:{},response code:{},result:{},cost {} ms", new Object[]{apiUrl, builder.toString(), statusCode, result, System.currentTimeMillis() - start});
        return result;
    }

    public String get(String url, Charset encoding) {
        try {
            Request.Builder requestBuilder = new Request.Builder().get().url(url).header("Connection", "close");
            byte[] bytes = this.send(requestBuilder).body().bytes();
            if (bytes != null && bytes.length > 0) {
                return new String(bytes, encoding);
            }
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    public String get(String url) {
        try {
            Request.Builder requestBuilder = new Request.Builder().get().url(url).header("Connection", "close");
            byte[] bytes = this.send(requestBuilder).body().bytes();
            if (bytes != null && bytes.length > 0) {
                return HttpUtil.utf8String(bytes);
            }
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    public String post2(String url, StringMap params) throws IOException {
        byte[] bytes;
        FormBody.Builder f = new FormBody.Builder();
        params.forEach((key, value) -> {
            if (value != null) {
                f.add(key, value.toString());
            }
        });
        Response response = this.post(url, (RequestBody)f.build());
        if (response == null) {
            return "";
        }
        ResponseBody body = response.body();
        if (body != null && (bytes = body.bytes()) != null && bytes.length > 0) {
            return HttpUtil.utf8String(bytes);
        }
        return "";
    }

    public String post2(String url, String params) throws IOException {
        byte[] bytes;
        RequestBody requestBody = FormBody.create((MediaType)MediaType.parse((String)"application/x-www-form-urlencoded"), (String)params);
        Response response = this.post(url, requestBody);
        if (response == null) {
            return "";
        }
        ResponseBody body = response.body();
        if (body != null && (bytes = body.bytes()) != null && bytes.length > 0) {
            return HttpUtil.utf8String(bytes);
        }
        return "";
    }

    @Deprecated
    public String post(String url, StringMap params) {
        try {
            return this.post2(url, params);
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public String postByJSON(String url, String json) throws IOException {
        byte[] bytes;
        Request.Builder requestBuilder = new Request.Builder().url(url).post(RequestBody.create((MediaType)MediaType.parse((String)JSON_MIME), (String)json)).header("Connection", "close");
        Response response = this.send(requestBuilder);
        if (response == null) {
            return "";
        }
        ResponseBody body = response.body();
        if (body != null && (bytes = body.bytes()) != null && bytes.length > 0) {
            return HttpUtil.utf8String(bytes);
        }
        return "";
    }

    private Response send(Request.Builder requestBuilder) throws IOException {
        IpTag tag = new IpTag();
        long start = SystemClock.millisClock().now();
        Response res = null;
        Request request = requestBuilder.tag((Object)tag).build();
        res = this.httpClient.newCall(request).execute();
        long duration = SystemClock.millisClock().now() - start;
        LOGGER.debug("request {} duration {} ms", (Object)request, (Object)duration);
        if (res.isSuccessful()) {
            return res;
        }
        LOGGER.error("\u670d\u52a1\u7aef\u8fd4\u56de\u7684\u72b6\u6001\u7801\u4e0d\u662f200,request={},response={}", (Object)request, (Object)res);
        return res;
    }

    private Response post(String url, RequestBody body) throws IOException {
        Request.Builder requestBuilder = new Request.Builder().url(url).post(body).addHeader("content-type", "application/json;charset:utf-8");
        return this.send(requestBuilder);
    }

    private void asyncSend(Request.Builder requestBuilder, final AsyncCallback cb) {
        IpTag tag = new IpTag();
        this.httpClient.newCall(requestBuilder.tag((Object)tag).build()).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                cb.complete(response);
            }
        });
    }

    public String postByXML(String url, String xml) {
        try {
            Request.Builder requestBuilder = new Request.Builder().url(url).post(RequestBody.create((MediaType)MediaType.parse((String)XML_MIME), (String)xml)).header("Connection", "close");
            byte[] bytes = this.send(requestBuilder).body().bytes();
            if (bytes != null && bytes.length > 0) {
                return HttpUtil.utf8String(bytes);
            }
        }
        catch (IOException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    private static class IpTag {
        public String ip = null;

        private IpTag() {
        }
    }

    private static class TrustAllManager
    implements X509TrustManager {
        private TrustAllManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

