/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.yeepay.base.utils;

import com.fshows.yeepay.base.enums.PayTypeEnum;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientWxUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientWxUtil.class);
    @Resource(name="httpClientWxScan")
    private CloseableHttpClient httpClientWxScan;
    @Resource(name="requestConfigWxScan")
    private RequestConfig requestConfigWxScan;
    @Resource(name="httpClientWxApp")
    private CloseableHttpClient httpClientWxApp;
    @Resource(name="requestConfigWxApp")
    private RequestConfig requestConfigWxApp;
    @Resource(name="httpClientOasis")
    private CloseableHttpClient httpClientWxOasis;
    @Resource(name="requestConfigOasis")
    private RequestConfig requestConfigWxOasis;

    public String get(String url, Map<String, String> queries, Integer serverType) throws IOException {
        if (serverType == 3) {
            return this.get(url, queries, this.httpClientWxScan, this.requestConfigWxScan);
        }
        if (serverType == 152) {
            return this.get(url, queries, this.httpClientWxOasis, this.requestConfigWxOasis);
        }
        return this.get(url, queries, this.httpClientWxApp, this.requestConfigWxApp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String get(String url, Map<String, String> queries, CloseableHttpClient httpClient, RequestConfig requestConfig) throws IOException {
        String responseBody = "";
        StringBuffer sb = new StringBuffer(url);
        if (queries != null && queries.keySet().size() > 0) {
            boolean firstFlag = true;
            for (Map.Entry<String, String> entry : queries.entrySet()) {
                if (firstFlag) {
                    sb.append("?" + entry.getKey() + "=" + entry.getValue());
                    firstFlag = false;
                    continue;
                }
                sb.append("&" + entry.getKey() + "=" + entry.getValue());
            }
        }
        HttpGet httpGet = new HttpGet(sb.toString());
        httpGet.setConfig(requestConfig);
        CloseableHttpResponse response = null;
        try {
            response = httpClient.execute((HttpUriRequest)httpGet);
            int status = response.getStatusLine().getStatusCode();
            if (status == 200) {
                HttpEntity entity = response.getEntity();
                responseBody = EntityUtils.toString((HttpEntity)entity);
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
        catch (Exception ex) {
            logger.error("http error >> ex = {}", (Object)ExceptionUtils.getStackTrace((Throwable)ex));
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    logger.error("http close error >> ex = {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
        return responseBody;
    }

    public File getFile(String url, Map<String, String> queries, File file, Integer serverType) throws IOException {
        if (serverType == 3) {
            return this.getFile(url, queries, file, this.httpClientWxScan, this.requestConfigWxScan);
        }
        if (serverType == 6) {
            return this.getFile(url, queries, file, this.httpClientWxOasis, this.requestConfigWxOasis);
        }
        return this.getFile(url, queries, file, this.httpClientWxApp, this.requestConfigWxApp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getFile(String url, Map<String, String> queries, File file, CloseableHttpClient httpClient, RequestConfig requestConfig) throws IOException {
        StringBuffer sb = new StringBuffer(url);
        if (queries != null && queries.keySet().size() > 0) {
            boolean firstFlag = true;
            for (Map.Entry<String, String> entry : queries.entrySet()) {
                if (firstFlag) {
                    sb.append("?" + entry.getKey() + "=" + entry.getValue());
                    firstFlag = false;
                    continue;
                }
                sb.append("&" + entry.getKey() + "=" + entry.getValue());
            }
        }
        HttpGet httpGet = new HttpGet(sb.toString());
        httpGet.setConfig(requestConfig);
        CloseableHttpResponse response = null;
        try {
            response = httpClient.execute((HttpUriRequest)httpGet);
            int status = response.getStatusLine().getStatusCode();
            if (status == 200) {
                HttpEntity entity = response.getEntity();
                BufferedInputStream bis = new BufferedInputStream(entity.getContent());
                if (bis.available() < 1024) {
                    bis.close();
                    File file2 = null;
                    return file2;
                }
                FileOutputStream fos = new FileOutputStream(file);
                byte[] buf = new byte[1024];
                int size = 0;
                while ((size = bis.read(buf)) != -1) {
                    fos.write(buf, 0, size);
                }
                fos.close();
                bis.close();
            }
        }
        catch (Exception ex) {
            logger.error("http error >> ex = {}", (Object)ExceptionUtils.getStackTrace((Throwable)ex));
            file.delete();
            File file3 = null;
            return file3;
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    logger.error("http close error >> ex = {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
        return file;
    }

    public String post(String url, Map<String, String> queries, Map<String, String> params, Integer serverType) throws IOException {
        if (serverType == 3) {
            return this.post(url, queries, params, this.httpClientWxScan, this.requestConfigWxScan);
        }
        if (serverType == 6) {
            return this.post(url, queries, params, this.httpClientWxOasis, this.requestConfigWxOasis);
        }
        return this.post(url, queries, params, this.httpClientWxApp, this.requestConfigWxApp);
    }

    private String post(String url, Map<String, String> queries, Map<String, String> params, CloseableHttpClient httpClient, RequestConfig requestConfig) throws IOException {
        StringBuffer sb = new StringBuffer(url);
        if (queries != null && queries.keySet().size() > 0) {
            boolean firstFlag = true;
            for (Map.Entry<String, String> entry : queries.entrySet()) {
                if (firstFlag) {
                    sb.append("?" + entry.getKey() + "=" + entry.getValue());
                    firstFlag = false;
                    continue;
                }
                sb.append("&" + entry.getKey() + "=" + entry.getValue());
            }
        }
        HttpPost httpPost = new HttpPost(sb.toString());
        httpPost.setConfig(requestConfig);
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        if (params != null && params.keySet().size() > 0) {
            for (String key : params.keySet()) {
                nvps.add(new BasicNameValuePair(key, params.get(key)));
            }
        }
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, Consts.UTF_8));
        return this.getResponseBody(httpClient, httpPost);
    }

    public String post(String url, String data, Integer serverType) throws IOException {
        if (serverType == 3) {
            return this.post(url, data, this.httpClientWxScan, this.requestConfigWxScan);
        }
        if (serverType == 6) {
            return this.post(url, data, this.httpClientWxOasis, this.requestConfigWxOasis);
        }
        return this.post(url, data, this.httpClientWxApp, this.requestConfigWxApp);
    }

    private String post(String url, String data, CloseableHttpClient httpClient, RequestConfig requestConfig) throws IOException {
        StringBuffer sb = new StringBuffer(url);
        HttpPost httpPost = new HttpPost(sb.toString());
        httpPost.setConfig(requestConfig);
        StringEntity se = new StringEntity(data, "utf-8");
        se.setContentEncoding((Header)new BasicHeader("Content-Type", "application/json"));
        httpPost.setEntity((HttpEntity)se);
        return this.getResponseBody(httpClient, httpPost);
    }

    public String postFile(String url, HttpEntity reqEntity, Integer serverType) throws Exception {
        if (serverType == 3) {
            return this.postFile(url, reqEntity, this.httpClientWxScan, this.requestConfigWxScan);
        }
        if (serverType.intValue() == PayTypeEnum.WX_OASIS.getValue()) {
            return this.postFile(url, reqEntity, this.httpClientWxOasis, this.requestConfigWxOasis);
        }
        return this.postFile(url, reqEntity, this.httpClientWxApp, this.requestConfigWxApp);
    }

    private String postFile(String url, HttpEntity reqEntity, CloseableHttpClient httpClient, RequestConfig requestConfig) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setConfig(requestConfig);
        httpPost.setEntity(reqEntity);
        return this.getResponseBody(httpClient, httpPost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResponseBody(CloseableHttpClient httpClient, HttpPost httpPost) {
        String responseBody = "";
        CloseableHttpResponse response = null;
        try {
            response = httpClient.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() == 200) {
                HttpEntity entity = response.getEntity();
                responseBody = EntityUtils.toString((HttpEntity)entity);
            }
        }
        catch (IOException ex) {
            logger.error("http error >> ex = {}", (Object)ExceptionUtils.getStackTrace((Throwable)ex));
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    logger.error("http close error >> ex = {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
        return responseBody;
    }
}

