/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.yeepay.base.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSVUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createCSVFile(List exportData, LinkedHashMap rowMapper, String outPutPath, String filename) {
        File csvFile = null;
        BufferedWriter csvFileOutputStream = null;
        try {
            csvFile = new File(outPutPath + filename + ".csv");
            File parent = csvFile.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            csvFile.createNewFile();
            csvFileOutputStream = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(csvFile), "GBK"), 1024);
            Iterator propertyIterator = rowMapper.entrySet().iterator();
            while (propertyIterator.hasNext()) {
                Map.Entry propertyEntry = propertyIterator.next();
                csvFileOutputStream.write("\"" + propertyEntry.getValue().toString() + "\"");
                if (!propertyIterator.hasNext()) continue;
                csvFileOutputStream.write(",");
            }
            csvFileOutputStream.newLine();
            Iterator iterator = exportData.iterator();
            while (iterator.hasNext()) {
                LinkedHashMap row = (LinkedHashMap)iterator.next();
                Iterator propertyIterator2 = row.entrySet().iterator();
                while (propertyIterator2.hasNext()) {
                    Map.Entry propertyEntry = propertyIterator2.next();
                    csvFileOutputStream.write("\"" + propertyEntry.getValue().toString() + "\"");
                    if (!propertyIterator2.hasNext()) continue;
                    csvFileOutputStream.write(",");
                }
                if (!iterator.hasNext()) continue;
                csvFileOutputStream.newLine();
            }
            csvFileOutputStream.flush();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                csvFileOutputStream.close();
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return csvFile;
    }

    public static void main(String[] args) {
        ArrayList exportData = new ArrayList();
        LinkedHashMap<String, String> row1 = new LinkedHashMap<String, String>();
        row1.put("1", "11");
        row1.put("2", "12");
        row1.put("3", "13");
        row1.put("4", "14");
        exportData.add(row1);
        row1 = new LinkedHashMap();
        row1.put("1", "21");
        row1.put("2", "22");
        row1.put("3", "23");
        row1.put("4", "24");
        exportData.add(row1);
        ArrayList propertyNames = new ArrayList();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("1", "\u7b2c\u4e00\u5217");
        map.put("2", "\u7b2c\u4e8c\u5217");
        map.put("3", "\u7b2c\u4e09\u5217");
        map.put("4", "\u7b2c\u56db\u5217");
        CSVUtil.createCSVFile(exportData, map, "d:/", "12");
    }

    public static List<String[]> parseCsvFile(String filePath) {
        ArrayList<String[]> list = new ArrayList<String[]>();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "GBK"));
            reader.readLine();
            String line = null;
            String[] items = null;
            while ((line = reader.readLine()) != null) {
                line = line.replace("\t", "");
                line = line.replace("\"", "");
                items = line.split(",");
                list.add(items);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }
}

