/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.yeepay.base.utils;

import com.alipay.api.AlipayApiException;
import com.alipay.api.internal.util.AlipaySignature;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class AlipaySignUtil {
    public static String createSign(Map<String, Object> params, String prikey) {
        HashMap<String, String> map = new HashMap<String, String>(params.size());
        for (String s : params.keySet()) {
            Object o = params.get(s);
            if (o == null) continue;
            map.put(s, o.toString());
        }
        map.remove("sign");
        map.remove("sign_type");
        try {
            return AlipaySignature.rsaSign(map, (String)prikey, (String)"utf-8");
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String createSign2(Map<String, Object> params, String prikey) {
        HashMap<String, String> map = new HashMap<String, String>(params.size());
        for (String s : params.keySet()) {
            Object o = params.get(s);
            if (o == null) continue;
            map.put(s, o.toString());
        }
        map.remove("sign");
        map.remove("sign_type");
        try {
            String sign = AlipaySignature.rsa256Sign((String)AlipaySignUtil.generateSignSrc(map), (String)prikey, (String)"utf-8");
            return sign;
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String generateSignSrc(Map<String, String> map) {
        TreeMap<String, String> sortMap = new TreeMap<String, String>();
        sortMap.putAll(map);
        StringBuilder builder = new StringBuilder();
        for (Map.Entry s : sortMap.entrySet()) {
            String k = (String)s.getKey();
            String v = (String)s.getValue();
            if (StringUtils.isBlank((CharSequence)v)) continue;
            builder.append(k).append("=").append(v).append("&");
        }
        if (!sortMap.isEmpty()) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }
}

