/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.yeepay.base.result;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class ResultModel
implements Serializable {
    private static final long serialVersionUID = -9204659000311373130L;
    private boolean isSuccess;
    private Object returnValue;
    private String errorCode;
    private String errorMessage;

    public ResultModel(Object returnValue) {
        this.returnValue = returnValue;
        this.isSuccess = true;
    }

    public ResultModel(String errorCode, String errorMessage) {
        this.isSuccess = false;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public ResultModel(String errorCode, String errorMessage, Object returnValue) {
        this.isSuccess = false;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.returnValue = returnValue;
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public void setSuccess(boolean isSuccess) {
        this.isSuccess = isSuccess;
    }

    public Object getReturnValue() {
        return this.returnValue;
    }

    public void setReturnValue(Object returnValue) {
        this.returnValue = returnValue;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public static ResultModel success(Object returnValue) {
        return new ResultModel(returnValue);
    }

    public static ResultModel customError(String errorCode, String errorMessage) {
        return new ResultModel(errorCode, errorMessage);
    }

    public static ResultModel userPaying() {
        return new ResultModel("100", "\u7528\u6237\u6b63\u5728\u652f\u4ed8\u4e2d\u3002\u3002\u3002");
    }

    public static ResultModel userPaying(Object returnValue) {
        return new ResultModel("100", "\u7528\u6237\u6b63\u5728\u652f\u4ed8\u4e2d\u3002\u3002\u3002", returnValue);
    }

    public static ResultModel signError() {
        return new ResultModel("-100", "\u65e0\u6548\u7b7e\u540d");
    }

    public static ResultModel paramError() {
        return new ResultModel("-101", "\u65e0\u6548\u53c2\u6570");
    }

    public static ResultModel paramError(String column) {
        if (StringUtils.isBlank((CharSequence)column)) {
            return new ResultModel("-101", "\u65e0\u6548\u53c2\u6570");
        }
        return new ResultModel("-101", "\u65e0\u6548\u53c2\u6570 >> " + column);
    }

    public static ResultModel perssionError() {
        return new ResultModel("-102", "\u6743\u9650\u4e0d\u8db3");
    }

    public static ResultModel commonError(String msg) {
        if (StringUtils.isBlank((CharSequence)msg)) {
            return new ResultModel("-103", "\u901a\u7528\u9519\u8bef");
        }
        return new ResultModel("-103", msg);
    }

    public static ResultModel loginError(String msg) {
        if (StringUtils.isBlank((CharSequence)msg)) {
            return new ResultModel("-104", "\u767b\u5f55\u5931\u6548");
        }
        return new ResultModel("-104", "\u767b\u5f55\u5931\u6548>>" + msg);
    }

    public static ResultModel serverError() {
        return new ResultModel("-200", "\u670d\u52a1\u5668\u5f02\u5e38");
    }

    public static ResultModel serverError(String msg) {
        if (StringUtils.isBlank((CharSequence)msg)) {
            return new ResultModel("-200", "\u670d\u52a1\u5668\u5f02\u5e38");
        }
        return new ResultModel("-200", "\u670d\u52a1\u5668\u5f02\u5e38 >> " + msg);
    }

    public static ResultModel platformError(String msg) {
        if (StringUtils.isBlank((CharSequence)msg)) {
            return new ResultModel("-300", "\u5e73\u53f0\u65b9\u9519\u8bef");
        }
        return new ResultModel("-300", "\u5e73\u53f0\u65b9\u9519\u8bef >> " + msg);
    }

    public static ResultModel payError(String msg) {
        if (StringUtils.isBlank((CharSequence)msg)) {
            return new ResultModel("-301", "\u652f\u4ed8\u5931\u8d25");
        }
        return new ResultModel("-301", "\u652f\u4ed8\u5931\u8d25 >> " + msg);
    }

    public static ResultModel refundError(String msg) {
        if (StringUtils.isBlank((CharSequence)msg)) {
            return new ResultModel("-302", "\u9000\u6b3e\u5931\u8d25");
        }
        return new ResultModel("-302", "\u9000\u6b3e\u5931\u8d25 >> " + msg);
    }

    public static ResultModel liquidatorError(String liquidatorId) {
        if (StringUtils.isBlank((CharSequence)liquidatorId)) {
            return new ResultModel("-201", "\u6e05\u7b97\u65b9\u65e0\u6548");
        }
        return new ResultModel("-201", "\u6e05\u7b97\u65b9\u65e0\u6548 >> " + liquidatorId);
    }

    public static ResultModel storeError(String storeId) {
        if (StringUtils.isBlank((CharSequence)storeId)) {
            return new ResultModel("-202", "\u5546\u6237\u65e0\u6548");
        }
        return new ResultModel("-202", "\u5546\u6237\u65e0\u6548 >> " + storeId);
    }

    public static ResultModel subMchError(String subMchId) {
        if (StringUtils.isBlank((CharSequence)subMchId)) {
            return new ResultModel("-203", "\u5b50\u5546\u6237\u53f7\u65e0\u6548");
        }
        return new ResultModel("-203", "\u5b50\u5546\u6237\u53f7\u65e0\u6548 >> " + subMchId);
    }

    public static ResultModel shopError(String shopId) {
        if (StringUtils.isBlank((CharSequence)shopId)) {
            return new ResultModel("-204", "\u95e8\u5e97\u65e0\u6548");
        }
        return new ResultModel("-204", "\u95e8\u5e97\u65e0\u6548 >> " + shopId);
    }

    public static ResultModel channleError(String channleId) {
        if (StringUtils.isBlank((CharSequence)channleId)) {
            return new ResultModel("-205", "\u6e20\u9053\u53f7\u65e0\u6548");
        }
        return new ResultModel("-205", "\u6e20\u9053\u53f7\u65e0\u6548 >> " + channleId);
    }

    public static ResultModel reOrderError(String orderSn) {
        if (StringUtils.isBlank((CharSequence)orderSn)) {
            return new ResultModel("-206", "\u91cd\u590d\u8ba2\u5355\u53f7");
        }
        return new ResultModel("-206", "\u91cd\u590d\u8ba2\u5355\u53f7 >> " + orderSn);
    }

    public static ResultModel noOrderError(String orderSn) {
        if (StringUtils.isBlank((CharSequence)orderSn)) {
            return new ResultModel("-207", "\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        return new ResultModel("-207", "\u8ba2\u5355\u4e0d\u5b58\u5728 >> " + orderSn);
    }

    public static ResultModel payPlatformError(String payPlatform) {
        if (StringUtils.isBlank((CharSequence)payPlatform)) {
            return new ResultModel("-208", "\u652f\u4ed8\u5e73\u53f0\u65e0\u6548");
        }
        return new ResultModel("-208", "\u652f\u4ed8\u5e73\u53f0\u65e0\u6548 >> " + payPlatform);
    }

    public static ResultModel fileError() {
        return new ResultModel("-209", "\u6587\u4ef6\u672a\u751f\u6210");
    }

    public static ResultModel fileTypeError(String fileType) {
        if (StringUtils.isBlank((CharSequence)fileType)) {
            return new ResultModel("-210", "\u6587\u4ef6\u7c7b\u578b\u9519\u8bef");
        }
        return new ResultModel("-210", "\u6587\u4ef6\u7c7b\u578b\u9519\u8bef >> " + fileType);
    }

    public static ResultModel rateError(String rate) {
        if (StringUtils.isBlank((CharSequence)rate)) {
            return new ResultModel("-211", "\u65e0\u6548\u8d39\u7387");
        }
        return new ResultModel("-211", "\u65e0\u6548\u8d39\u7387>>" + rate);
    }

    public static ResultModel rateTypeError(String rateType) {
        if (StringUtils.isBlank((CharSequence)rateType)) {
            return new ResultModel("-212", "\u8d39\u7387\u7c7b\u578b\u9519\u8bef");
        }
        return new ResultModel("-212", "\u8d39\u7387\u7c7b\u578b\u9519\u8bef >> " + rateType);
    }

    public static ResultModel witnessError() {
        return new ResultModel("-213", "\u672a\u5f00\u901a\u89c1\u8bc1\u5b9d");
    }

    public static ResultModel reBindError(String bankno) {
        if (StringUtils.isBlank((CharSequence)bankno)) {
            return new ResultModel("-214", "\u91cd\u590d\u7ed1\u5361");
        }
        return new ResultModel("-214", "\u91cd\u590d\u7ed1\u5361 >> " + bankno);
    }

    public static ResultModel noBindError() {
        return new ResultModel("-215", "\u6682\u672a\u7ed1\u5361");
    }

    public static ResultModel balanceError() {
        return new ResultModel("-216", "\u4f59\u989d\u4e0d\u8db3");
    }

    public static ResultModel allocateError(String allocateId) {
        if (StringUtils.isBlank((CharSequence)allocateId)) {
            return new ResultModel("-217", "\u5355\u7b14\u767b\u8bb0\u6302\u8d26\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        return new ResultModel("-217", "\u5355\u7b14\u767b\u8bb0\u6302\u8d26\u8bb0\u5f55\u4e0d\u5b58\u5728 >> " + allocateId);
    }

    public static ResultModel withdrawError(String withdrawId) {
        if (StringUtils.isBlank((CharSequence)withdrawId)) {
            return new ResultModel("-218", "\u63d0\u73b0\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        return new ResultModel("-218", "\u63d0\u73b0\u8bb0\u5f55\u4e0d\u5b58\u5728 >> " + withdrawId);
    }

    public static ResultModel transferError(String transferId) {
        if (StringUtils.isBlank((CharSequence)transferId)) {
            return new ResultModel("-219", "\u8f6c\u8d26\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        return new ResultModel("-219", "\u8f6c\u8d26\u8bb0\u5f55\u4e0d\u5b58\u5728 >> " + transferId);
    }

    public static ResultModel operError(String msg) {
        if (StringUtils.isBlank((CharSequence)msg)) {
            return new ResultModel("-220", "\u65e0\u6548\u64cd\u4f5c");
        }
        return new ResultModel("-220", "\u65e0\u6548\u64cd\u4f5c >> " + msg);
    }

    public static ResultModel requestError() {
        return new ResultModel("-221", "\u8bf7\u6c42\u8fc7\u4e8e\u9891\u7e41\uff0c\u8bf7\u7a0d\u5019\u91cd\u8bd5");
    }

    public static ResultModel payTypeError(String payType) {
        if (StringUtils.isBlank((CharSequence)payType)) {
            return new ResultModel("-222", "\u652f\u4ed8\u7c7b\u578b\u9519\u8bef");
        }
        return new ResultModel("-222", "\u652f\u4ed8\u7c7b\u578b\u9519\u8bef >> " + payType);
    }

    public static ResultModel parseError(String msg) {
        if (StringUtils.isBlank((CharSequence)msg)) {
            return new ResultModel("-223", "\u89e3\u6790\u9519\u8bef");
        }
        return new ResultModel("-223", "\u89e3\u6790\u9519\u8bef >> " + msg);
    }

    public static ResultModel configError() {
        return new ResultModel("-224", "\u914d\u7f6e\u4e0d\u5b58\u5728");
    }

    public String toString() {
        return "ResultModel{isSuccess=" + this.isSuccess + ", returnValue=" + this.returnValue + ", errorCode='" + this.errorCode + '\'' + ", errorMessage='" + this.errorMessage + '\'' + '}';
    }
}

