/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.auth.common.redis;

import com.alibaba.fastjson.JSONArray;
import com.fshows.auth.common.redis.RedisClient;
import com.fshows.auth.common.redis.RedisRangScoresModel;
import com.fshows.auth.common.util.JsonSerializer;
import com.fshows.auth.common.util.SystemClock;
import com.fshows.auth.common.util.TimeUnitUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BinaryJedis;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;
import redis.clients.jedis.Tuple;

@Component
public class RedisCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisCache.class);
    private static final int ZERO = 0;
    private static final int FIVE = 5;
    private static final String OK = "OK";
    private static final Long LONG_ONE = 1L;
    private static final Long LONG_ZERO = 0L;
    public static final int DEFAULT_CACHE_SECONDS = TimeUnitUtil.getSeconds(TimeUnit.SECONDS, 5);
    public static final long DEFAULT_CACHE_MILLIS = TimeUnitUtil.getMillis(TimeUnit.MINUTES, 5);
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private RedisClient redisClient;

    public Boolean exists(String key) {
        this.validateKeyParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.exists(key.getBytes()));
    }

    public Boolean expire(String key, int seconds) {
        return this.expire(key, seconds, TimeUnit.SECONDS);
    }

    public Boolean expire(String key, int duration, TimeUnit timeUnit) {
        this.validateKeyParam(key);
        long millis = TimeUnitUtil.getMillis(timeUnit, duration);
        Long lResult = this.redisClient.invoke(this.jedisPool, jedis -> jedis.pexpire(key.getBytes(), millis));
        return this.isLongEquals(LONG_ONE, lResult);
    }

    public Long getExpiresTtl(String key) {
        this.validateKeyParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.ttl(key.getBytes()));
    }

    public Long getExpiresPttl(String key) {
        this.validateKeyParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.pttl(key.getBytes()));
    }

    public Boolean persist(String key) {
        this.validateKeyParam(key);
        Long lResult = this.redisClient.invoke(this.jedisPool, jedis -> jedis.persist(key.getBytes()));
        return this.isLongEquals(LONG_ONE, lResult);
    }

    public String getType(String key) {
        this.validateKeyParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.type(key.getBytes()));
    }

    public Long del(String key) {
        this.validateKeyParam(key);
        if (this.exists(key).booleanValue()) {
            return this.redisClient.invoke(this.jedisPool, jedis -> jedis.del(key.getBytes()));
        }
        return LONG_ZERO;
    }

    public Boolean set(String key, Object value) {
        return this.set(key, value, 5, TimeUnit.MINUTES);
    }

    public Boolean set(String key, Object value, int duration, TimeUnit timeUnit) {
        this.validateParam(key, value);
        String result = this.redisClient.invoke(this.jedisPool, jedis -> {
            String srtResult = jedis.set(key.getBytes(), JsonSerializer.serialize(value));
            if (duration <= 0) {
                jedis.pexpire(key.getBytes(), DEFAULT_CACHE_MILLIS);
            } else {
                long millis = TimeUnitUtil.getMillis(timeUnit, duration);
                jedis.pexpire(key.getBytes(), millis);
            }
            return srtResult;
        });
        return this.isStringEquals(OK, result);
    }

    public Boolean putNeverExpires(String key, Object value) {
        this.validateParam(key, value);
        String result = this.redisClient.invoke(this.jedisPool, jedis -> {
            String srtResult = jedis.set(key.getBytes(), JsonSerializer.serialize(value));
            return srtResult;
        });
        return this.isStringEquals(OK, result);
    }

    public <T> T get(String key, Class<T> clazz) {
        this.validateKeyParam(key);
        byte[] result = this.redisClient.invoke(this.jedisPool, jedis -> jedis.get(key.getBytes()));
        if (result == null) {
            return null;
        }
        return JsonSerializer.deserialize(result, clazz);
    }

    public <T> List<T> mget(List<String> keys, Class<T> classz) {
        if (CollectionUtils.isEmpty(keys)) {
            return Lists.newArrayList();
        }
        String[] strings = new String[keys.size()];
        keys.toArray(strings);
        List result = this.redisClient.invoke(this.jedisPool, jedis -> {
            List list = jedis.mget(strings);
            ArrayList resultList = Lists.newArrayList();
            if (CollectionUtils.isEmpty((Collection)list)) {
                return new ArrayList();
            }
            for (String str : list) {
                Object t = JsonSerializer.deserialize(str.getBytes(), classz);
                resultList.add(t);
            }
            return resultList;
        });
        return result;
    }

    public String get(String key) {
        return this.get(key, String.class);
    }

    public <T> List<T> getList(String key, Class<T> clazz) {
        String str = this.get(key, String.class);
        return JSONArray.parseArray((String)str, clazz);
    }

    public Boolean setNx(String key) {
        return this.setNx(key, SystemClock.millisClock().now(), 5, TimeUnit.MINUTES);
    }

    public Boolean setNx(String key, Object value) {
        return this.setNx(key, value, 5, TimeUnit.MINUTES);
    }

    public Boolean setNx(String key, int seconds) {
        return this.setNx(key, SystemClock.millisClock().now(), seconds, TimeUnit.SECONDS);
    }

    public Boolean setNx(String key, Object value, int seconds) {
        return this.setNx(key, value, seconds, TimeUnit.SECONDS);
    }

    public Boolean setNx(String key, Object value, int duration, TimeUnit timeUnit) {
        this.validateParam(key, value);
        return this.redisClient.invoke(this.jedisPool, jedis -> {
            long result = jedis.setnx(key.getBytes(), JsonSerializer.serialize(value));
            if (result >= 1L) {
                if (duration <= 0) {
                    jedis.pexpire(key.getBytes(), DEFAULT_CACHE_MILLIS);
                    return true;
                }
                long millis = TimeUnitUtil.getMillis(timeUnit, duration);
                jedis.pexpire(key.getBytes(), millis);
                return true;
            }
            return false;
        });
    }

    public String getSet(String key, String value) {
        return this.getSet(key, value, 5, TimeUnit.MINUTES);
    }

    public String getSet(String key, String value, int duration, TimeUnit timeUnit) {
        this.validateParam(key, value);
        return this.redisClient.invoke(this.jedisPool, jedis -> {
            String result = jedis.getSet(key, value);
            if (duration <= 0) {
                jedis.pexpire(key.getBytes(), DEFAULT_CACHE_MILLIS);
                return result;
            }
            long millis = TimeUnitUtil.getMillis(timeUnit, duration);
            jedis.pexpire(key.getBytes(), millis);
            return result;
        });
    }

    public Long getStrLen(String key) {
        this.validateKeyParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.strlen(key.getBytes()));
    }

    public Long incr(String key) {
        this.validateKeyParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.incr(key.getBytes()));
    }

    public Long incrBy(String key, long value) {
        this.validateKeyParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.incrBy(key.getBytes(), value));
    }

    public Double incrByFloat(String key, Double value) {
        this.validateKeyParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.incrByFloat(key.getBytes(), value.doubleValue()));
    }

    public Long decr(String key) {
        this.validateKeyParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.decr(key.getBytes()));
    }

    public Long decrBy(String key, long value) {
        this.validateKeyParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.decrBy(key.getBytes(), value));
    }

    public Long append(String key, Object value) {
        this.validateKeyParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.append(key.getBytes(), JsonSerializer.serialize(value)));
    }

    public Long zAdd(String key, Object obj, double score) {
        this.validateParam(key, obj);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.zadd(key.getBytes(), score, JsonSerializer.serialize(obj)));
    }

    public void zaddWithMapScore(String key, Map<byte[], Double> members) {
        this.redisClient.invoke(this.jedisPool, jedis -> {
            jedis.zadd(key.getBytes(), members);
            return null;
        });
    }

    public long zCard(String key) {
        this.validateKeyParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.zcard(key.getBytes()));
    }

    public Long zCount(String key, double minScore, double maxScore) {
        this.validateKeyParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.zcount(key.getBytes(), minScore, maxScore));
    }

    public <T> List<T> zRange(String key, Class<T> clazz, int start, int end) {
        this.validateKeyParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> {
            Set set = jedis.zrange(key.getBytes(), (long)start, (long)end);
            ArrayList list = new ArrayList(set.size());
            if (CollectionUtils.isEmpty((Collection)set)) {
                return new ArrayList(0);
            }
            for (byte[] bytes : set) {
                Object t = JsonSerializer.deserialize(bytes, clazz);
                list.add(t);
            }
            return list;
        });
    }

    public <T> List<RedisRangScoresModel<T>> zrevrangeWithScores(String key, Class<T> clazz, int start, int end) {
        this.validateKeyParam(key);
        List result = this.redisClient.invoke(this.jedisPool, jedis -> {
            Set set = jedis.zrevrangeWithScores(key.getBytes(), (long)start, (long)end);
            ArrayList list = new ArrayList(set.size());
            if (CollectionUtils.isEmpty((Collection)set)) {
                return new ArrayList();
            }
            RedisRangScoresModel rangScores = null;
            for (Tuple bytes : set) {
                rangScores = new RedisRangScoresModel();
                Object t = JsonSerializer.deserialize(bytes.getBinaryElement(), clazz);
                rangScores.setObj(t);
                rangScores.setScore(bytes.getScore());
                list.add(rangScores);
            }
            return list;
        });
        return result;
    }

    public <T> List<T> zRevRange(String key, Class<T> clazz, int start, int end) {
        this.validateKeyParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> {
            Set set = jedis.zrevrange(key.getBytes(), (long)start, (long)end);
            ArrayList list = new ArrayList(set.size());
            if (CollectionUtils.isEmpty((Collection)set)) {
                return new ArrayList(0);
            }
            for (byte[] bytes : set) {
                Object t = JsonSerializer.deserialize(bytes, clazz);
                list.add(t);
            }
            return list;
        });
    }

    public <T> List<T> zRangeByScore(String key, Class<T> clazz, double minScore, double maxScore) {
        this.validateKeyParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> {
            Set set = jedis.zrangeByScore(key.getBytes(), minScore, maxScore);
            ArrayList list = new ArrayList(set.size());
            if (CollectionUtils.isEmpty((Collection)set)) {
                return new ArrayList(0);
            }
            for (byte[] bytes : set) {
                Object t = JsonSerializer.deserialize(bytes, clazz);
                list.add(t);
            }
            return list;
        });
    }

    public <T> List<T> zRevRangeByScore(String key, Class<T> clazz, double minScore, double maxScore) {
        this.validateKeyParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> {
            Set set = jedis.zrevrangeByScore(key.getBytes(), maxScore, minScore);
            ArrayList list = new ArrayList(set.size());
            if (CollectionUtils.isEmpty((Collection)set)) {
                return new ArrayList(0);
            }
            for (byte[] bytes : set) {
                Object t = JsonSerializer.deserialize(bytes, clazz);
                list.add(t);
            }
            return list;
        });
    }

    public Long zRank(String key, Object obj) {
        this.validateParam(key, obj);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.zrank(key.getBytes(), JsonSerializer.serialize(obj)));
    }

    public Long zRevRank(String key, Object obj) {
        this.validateParam(key, obj);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.zrevrank(key.getBytes(), JsonSerializer.serialize(obj)));
    }

    public Long zRem(String key, Object obj) {
        this.validateParam(key, obj);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.zrem(key.getBytes(), (byte[][])new byte[][]{JsonSerializer.serialize(obj)}));
    }

    public Long zRemRangeByRank(String key, int start, int end) {
        this.validateKeyParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.zremrangeByRank(key.getBytes(), (long)start, (long)end));
    }

    public Long zRemRangeByScore(String key, double startScore, double endScore) {
        this.validateKeyParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.zremrangeByScore(key.getBytes(), startScore, endScore));
    }

    public Double zScore(String key, Object obj) {
        this.validateParam(key, obj);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.zscore(key.getBytes(), JsonSerializer.serialize(obj)));
    }

    public Double zIncrby(String key, Object obj, double score) {
        this.validateParam(key, obj);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.zincrby(key.getBytes(), score, JsonSerializer.serialize(obj)));
    }

    public Long lRpushObject(String key, Object ... value) {
        this.validateParam(key, value);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.rpush(key.getBytes(), (byte[][])new byte[][]{JsonSerializer.serialize(value)}));
    }

    public Long lRem(String key, Object value) {
        this.validateParam(key, value);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.lrem(key.getBytes(), 0L, JsonSerializer.serialize(value)));
    }

    public Long lPush(String key, Object value) {
        this.validateParam(key, value);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.lpush(key.getBytes(), (byte[][])new byte[][]{JsonSerializer.serialize(value)}));
    }

    public Boolean lset(String key, long index, Object value) {
        this.validateParam(key, value);
        return this.redisClient.invoke(this.jedisPool, jedis -> {
            String result = jedis.lset(key.getBytes(), index, JsonSerializer.serialize(value));
            return this.isStringEquals(OK, result);
        });
    }

    public Long rpush(String key, Object value) {
        this.validateParam(key, value);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.rpush(key.getBytes(), (byte[][])new byte[][]{JsonSerializer.serialize(value)}));
    }

    public Long linsertBefore(String key, Object value, Object newValue) {
        this.validateParam(key, value);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.linsert(key.getBytes(), BinaryClient.LIST_POSITION.BEFORE, JsonSerializer.serialize(value), JsonSerializer.serialize(newValue)));
    }

    public Long linsertAfter(String key, Object value, Object newValue) {
        this.validateParam(key, value);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.linsert(key.getBytes(), BinaryClient.LIST_POSITION.AFTER, JsonSerializer.serialize(value), JsonSerializer.serialize(newValue)));
    }

    public Boolean ltrim(String key, long start, long end) {
        this.validateKeyParam(key);
        String result = this.redisClient.invoke(this.jedisPool, jedis -> jedis.ltrim(key.getBytes(), start, end));
        return this.isStringEquals(OK, result);
    }

    public long lLen(String key) {
        this.validateKeyParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.llen(key.getBytes()));
    }

    public <T> T lindex(String key, int index, Class<T> clazz) {
        this.validateParam(key, clazz);
        Object obj = this.redisClient.invoke(this.jedisPool, jedis -> {
            byte[] result = jedis.lindex(key.getBytes(), (long)index);
            if (result == null) {
                return null;
            }
            return JsonSerializer.deserialize(result, clazz);
        });
        return (T)obj;
    }

    public List<String> lRange(String key, int start, int end) {
        this.validateKeyParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> {
            List strList = jedis.lrange(key, (long)start, (long)end);
            if (CollectionUtils.isEmpty((Collection)strList)) {
                return new ArrayList(0);
            }
            return strList;
        });
    }

    public <T> List<T> lRange(String key, Class<T> clazz, int start, int end) {
        this.validateKeyParam(key);
        List result = this.redisClient.invoke(this.jedisPool, jedis -> {
            List set = jedis.lrange(key.getBytes(), (long)start, (long)end);
            ArrayList list = new ArrayList(set.size());
            if (CollectionUtils.isEmpty((Collection)set)) {
                return new ArrayList(0);
            }
            for (byte[] bytes : set) {
                Object t = JsonSerializer.deserialize(bytes, clazz);
                list.add(t);
            }
            return list;
        });
        return result;
    }

    public <T> T lpop(String key, Class<T> clazz) {
        this.validateParam(key, clazz);
        return (T)this.redisClient.invoke(this.jedisPool, jedis -> {
            byte[] result = jedis.lpop(key.getBytes());
            if (result == null) {
                return null;
            }
            return JsonSerializer.deserialize(result, clazz);
        });
    }

    public <T> T rpop(String key, Class<T> clazz) {
        this.validateParam(key, clazz);
        return (T)this.redisClient.invoke(this.jedisPool, jedis -> {
            byte[] result = jedis.rpop(key.getBytes());
            if (result == null) {
                return null;
            }
            return JsonSerializer.deserialize(result, clazz);
        });
    }

    public Long sadd(String key, Object value) {
        this.validateParam(key, value);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.sadd(key.getBytes(), (byte[][])new byte[][]{JsonSerializer.serialize(value)}));
    }

    public Long srem(String key, Object value) {
        this.validateParam(key, value);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.srem(key.getBytes(), (byte[][])new byte[][]{JsonSerializer.serialize(value)}));
    }

    public Long scard(String key) {
        this.validateKeyParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.scard(key.getBytes()));
    }

    public Boolean sismember(String key, Object value) {
        this.validateKeyParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.sismember(key.getBytes(), JsonSerializer.serialize(value)));
    }

    public <T> Set<T> smembers(String key, Class<T> clazz) {
        this.validateKeyParam(key);
        Set result = this.redisClient.invoke(this.jedisPool, jedis -> {
            Set setResult = jedis.smembers(key.getBytes());
            if (CollectionUtils.isEmpty((Collection)setResult)) {
                return new HashSet(0);
            }
            HashSet set = new HashSet(setResult.size());
            for (byte[] bytes : setResult) {
                Object t = JsonSerializer.deserialize(bytes, clazz);
                set.add(t);
            }
            return set;
        });
        return result;
    }

    public <T> Set<T> srandmember(String key, Class<T> clazz, int count) {
        this.validateKeyParam(key);
        Set result = this.redisClient.invoke(this.jedisPool, jedis -> {
            List setResult = jedis.srandmember(key.getBytes(), count);
            if (CollectionUtils.isEmpty((Collection)setResult)) {
                return new HashSet(0);
            }
            HashSet set = new HashSet(setResult.size());
            for (byte[] bytes : setResult) {
                Object t = JsonSerializer.deserialize(bytes, clazz);
                set.add(t);
            }
            return set;
        });
        return result;
    }

    public <T> Set<T> sinter(Set<String> keys, Class<T> clazz) {
        if (CollectionUtils.isEmpty(keys)) {
            return new HashSet(0);
        }
        String[] strKeys = new String[keys.size()];
        keys.toArray(strKeys);
        return this.redisClient.invoke(this.jedisPool, jedis -> {
            Set setResult = jedis.sinter(strKeys);
            if (CollectionUtils.isEmpty((Collection)setResult)) {
                return new HashSet(0);
            }
            HashSet set = new HashSet(setResult.size());
            for (String str : setResult) {
                Object t = JsonSerializer.deserialize(str.getBytes(), clazz);
                set.add(t);
            }
            return set;
        });
    }

    public <T> Set<T> sunion(Set<String> keys, Class<T> clazz) {
        if (CollectionUtils.isEmpty(keys)) {
            return new HashSet(0);
        }
        String[] strKeys = new String[keys.size()];
        keys.toArray(strKeys);
        return this.redisClient.invoke(this.jedisPool, jedis -> {
            Set setResult = jedis.sunion(strKeys);
            if (CollectionUtils.isEmpty((Collection)setResult)) {
                return new HashSet(0);
            }
            HashSet set = new HashSet(setResult.size());
            for (String str : setResult) {
                Object t = JsonSerializer.deserialize(str.getBytes(), clazz);
                set.add(t);
            }
            return set;
        });
    }

    public <T> Set<T> sdiff(List<String> keys, Class<T> clazz) {
        if (CollectionUtils.isEmpty(keys)) {
            return new HashSet(0);
        }
        String[] strKeys = new String[keys.size()];
        keys.toArray(strKeys);
        return this.redisClient.invoke(this.jedisPool, jedis -> {
            Set setResult = jedis.sdiff(strKeys);
            if (CollectionUtils.isEmpty((Collection)setResult)) {
                return new HashSet(0);
            }
            HashSet set = new HashSet(setResult.size());
            for (String str : setResult) {
                Object t = JsonSerializer.deserialize(str.getBytes(), clazz);
                set.add(t);
            }
            return set;
        });
    }

    public <T> T spop(String key, Class<T> clazz) {
        this.validateKeyParam(key);
        byte[] value = this.redisClient.invoke(this.jedisPool, jedis -> jedis.spop(key.getBytes()));
        if (value != null) {
            return JsonSerializer.deserialize(value, clazz);
        }
        return null;
    }

    public Long publish(String key, Object value) {
        this.validateParam(key, value);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.publish(key.getBytes(), JsonSerializer.serialize(value)));
    }

    public Boolean hSet(String key, String field, Object value) {
        this.validateKeyParam(key);
        Long result = this.redisClient.invoke(this.jedisPool, jedis -> jedis.hset(key.getBytes(), field.getBytes(), JsonSerializer.serialize(value)));
        return this.isLongEquals(LONG_ONE, result);
    }

    public Boolean hSet(String key, String field, Object value, int duration, TimeUnit timeUnit) {
        this.validateKeyParam(key);
        Long result = this.redisClient.invoke(this.jedisPool, jedis -> {
            Long hashResult = jedis.hset(key.getBytes(), field.getBytes(), JsonSerializer.serialize(value));
            jedis.pexpire(key.getBytes(), TimeUnitUtil.getMillis(timeUnit, duration));
            return hashResult;
        });
        return this.isLongEquals(LONG_ONE, result);
    }

    public Boolean hSetNx(String key, String field, Object value) {
        this.validateKeyParam(key);
        Long result = this.redisClient.invoke(this.jedisPool, jedis -> jedis.hsetnx(key.getBytes(), field.getBytes(), JsonSerializer.serialize(value)));
        return this.isLongEquals(LONG_ONE, result);
    }

    public Long hashIncr(String key, String field) {
        return this.hashIncrBy(key, field, 1L);
    }

    public Long hashIncrBy(String key, String field, long value) {
        this.validateKeyParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.hincrBy(key.getBytes(), field.getBytes(), value));
    }

    public Double hashIncrByFloat(String key, String field, Double value) {
        this.validateKeyParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.hincrByFloat(key.getBytes(), field.getBytes(), value.doubleValue()));
    }

    public <T> T hGet(String key, String field, Class<T> clazz) {
        this.validateKeyParam(key);
        byte[] value = this.redisClient.invoke(this.jedisPool, jedis -> jedis.hget(key.getBytes(), field.getBytes()));
        if (value != null) {
            return JsonSerializer.deserialize(value, clazz);
        }
        return null;
    }

    public <T> List<T> hmget(String key, List<String> fields, Class<T> classz) {
        if (CollectionUtils.isEmpty(fields)) {
            return Lists.newArrayList();
        }
        String[] strings = new String[fields.size()];
        fields.toArray(strings);
        List result = this.redisClient.invoke(this.jedisPool, jedis -> {
            List list = jedis.hmget(key, strings);
            ArrayList resultList = Lists.newArrayList();
            if (CollectionUtils.isEmpty((Collection)list)) {
                return new ArrayList();
            }
            for (String strValue : list) {
                if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{strValue})) continue;
                Object t = JsonSerializer.deserialize(strValue.getBytes(), classz);
                resultList.add(t);
            }
            return resultList;
        });
        return result;
    }

    public Long hdel(String key, String field) {
        this.validateParam(key, field);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.hdel(key.getBytes(), (byte[][])new byte[][]{field.getBytes()}));
    }

    public Boolean hexists(String key, String field) {
        this.validateParam(key, field);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.hexists(key.getBytes(), field.getBytes()));
    }

    public Long hlen(String key) {
        this.validateKeyParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.hlen(key.getBytes()));
    }

    public <T> Map<String, T> hgetAll(String key, Class<T> clazz) {
        this.validateKeyParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> {
            Map map = jedis.hgetAll(key.getBytes());
            HashMap resultMap = Maps.newHashMap();
            if (map != null) {
                for (Map.Entry item : map.entrySet()) {
                    byte[] newKey = (byte[])item.getKey();
                    Object newValue = JsonSerializer.deserialize((byte[])item.getValue(), clazz);
                    resultMap.put(new String(newKey), newValue);
                }
                return resultMap;
            }
            return null;
        });
    }

    public <T> List<T> hvals(String key, Class<T> clazz) {
        this.validateKeyParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> {
            List byteList = jedis.hvals(key.getBytes());
            ArrayList list = new ArrayList(byteList.size());
            if (CollectionUtils.isEmpty((Collection)byteList)) {
                return new ArrayList(0);
            }
            for (byte[] bytes : byteList) {
                Object t = JsonSerializer.deserialize(bytes, clazz);
                list.add(t);
            }
            return list;
        });
    }

    public Set<String> hkeys(String key) {
        this.validateKeyParam(key);
        return this.redisClient.invoke(this.jedisPool, jedis -> jedis.hkeys(key));
    }

    public Map<String, String> hgetall(String hashKey) {
        Map result = this.redisClient.invoke(this.jedisPool, jedis -> jedis.hgetAll(hashKey));
        return result;
    }

    public List<Map<String, String>> hgetallPipeline(List<String> hashKeys) {
        List result = this.redisClient.invoke(this.jedisPool, jedis -> {
            Pipeline pipeline = jedis.pipelined();
            ArrayList responseList = Lists.newArrayList();
            for (String hashKey : hashKeys) {
                responseList.add(pipeline.hgetAll(hashKey));
            }
            pipeline.sync();
            if (CollectionUtils.isEmpty((Collection)responseList)) {
                return new ArrayList();
            }
            ArrayList list = Lists.newArrayList();
            for (Response response : responseList) {
                list.add(response.get());
            }
            return list;
        });
        return result;
    }

    public List<String> hmgetallPipeline(List<String> hashKeys, String fieldKey) {
        List result = this.redisClient.invoke(this.jedisPool, jedis -> {
            Pipeline pipeline = jedis.pipelined();
            ArrayList responseList = Lists.newArrayList();
            for (String hashKey : hashKeys) {
                responseList.add(pipeline.hmget(hashKey, new String[]{fieldKey}));
            }
            pipeline.sync();
            if (CollectionUtils.isEmpty((Collection)responseList)) {
                return new ArrayList();
            }
            ArrayList list = Lists.newArrayList();
            for (Response response : responseList) {
                if (null == ((List)response.get()).get(0)) continue;
                list.add(((List)response.get()).get(0));
            }
            return list;
        });
        return result;
    }

    public void clearAll() {
        LOGGER.error("\u7f13\u5b58\u7684clear\u65b9\u6cd5\u88ab\u8c03\u7528\uff0c\u6240\u6709\u7f13\u5b58\u6570\u636e\u90fd\u88ab\u6e05\u9664\uff01");
        this.redisClient.invoke(this.jedisPool, BinaryJedis::flushAll);
    }

    public List<String> findKeys(String pattern) {
        Assert.hasText((String)pattern, (String)"\u67e5\u627e\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a");
        Charset charset = Charset.forName("UTF-8");
        return this.redisClient.invoke(this.jedisPool, jedis -> {
            Set sets = jedis.keys("*" + pattern + "*");
            if (sets != null) {
                ArrayList list = new ArrayList(sets.size());
                list.addAll(sets);
                return list;
            }
            return null;
        });
    }

    public <T> List<T> zrevrangePipeline(String key, Class<T> tClass, List<Integer> starts) {
        List result = this.redisClient.invoke(this.jedisPool, jedis -> {
            Pipeline pipeline = jedis.pipelined();
            ArrayList<Response> responseList = new ArrayList<Response>();
            for (Integer start : starts) {
                Response response = pipeline.zrevrange(key.getBytes(), (long)start.intValue(), (long)start.intValue());
                responseList.add(response);
            }
            pipeline.sync();
            if (CollectionUtils.isEmpty(responseList)) {
                return new ArrayList();
            }
            ArrayList list = new ArrayList(responseList.size());
            for (Response response : responseList) {
                for (byte[] bytes : (Set)response.get()) {
                    Object t = JsonSerializer.deserialize(bytes, tClass);
                    list.add(t);
                }
            }
            return list;
        });
        return result;
    }

    private void validateParam(String key, Object value) {
        this.validateKeyParam(key);
        Assert.notNull((Object)value, (String)"value\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isInstanceOf(Object.class, (Object)value, (String)"value\u6ca1\u6709\u5b9e\u73b0Object\u63a5\u53e3\uff0c\u65e0\u6cd5\u5e8f\u5217\u5316");
    }

    private void validateKeyParam(String key) {
        Assert.hasText((String)key, (String)"key\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)this.jedisPool, (String)"jedis\u8fde\u63a5\u521d\u59cb\u5316\u5931\u8d25");
    }

    private Boolean isLongEquals(Long valueOne, Long valueTwo) {
        if (null != valueOne && null != valueTwo) {
            return valueOne.intValue() == valueTwo.intValue();
        }
        return false;
    }

    private Boolean isStringEquals(String strOne, String strTwo) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{strOne}) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{strTwo})) {
            return strOne.equals(strTwo);
        }
        return false;
    }

    public synchronized Jedis getRedis() {
        return this.jedisPool.getResource();
    }

    public void setJedisPool(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }
}

