/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.auth.common.util;

import com.xiaoleilu.hutool.date.BetweenFormater;
import com.xiaoleilu.hutool.date.DateBetween;
import com.xiaoleilu.hutool.date.DateField;
import com.xiaoleilu.hutool.date.DateTime;
import com.xiaoleilu.hutool.date.DateUnit;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    public static final String LONG_DATE_PATTERN_LINE = "yyyy-MM-dd HH:mm:ss";
    public static final String SHORT_DATE_PATTERN_LINE = "yyyy-MM-dd";
    public static final String SHORT_DATE_PATTERN_NONE = "yyyyMMdd";
    public static final String COMPACT_TIME_PATTERN = "yyyyMMddHHmmss";
    private static final Logger LOGGER = LoggerFactory.getLogger(DateUtil.class);
    private static final Integer DATE_STR_COUNTS = 3;
    private static final Integer DATE_MAX_YEAR = 9999;
    private static final int IS_YEAR_FOUR = 4;
    private static final int IS_YEAR_HUNDRED = 100;
    private static final int IS_YEAR_FOUR_HUNDRED = 400;

    public static Date now() {
        return DateUtil.parseDateTime(com.xiaoleilu.hutool.date.DateUtil.now());
    }

    public static String today() {
        return com.xiaoleilu.hutool.date.DateUtil.today();
    }

    public static String formatTimeStamp(long time) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(LONG_DATE_PATTERN_LINE);
        return simpleDateFormat.format(time);
    }

    public static String formatDateSimple(Date date) {
        return com.xiaoleilu.hutool.date.DateUtil.format((Date)date, (String)SHORT_DATE_PATTERN_LINE);
    }

    public static String formatReqDate(Date date) {
        return com.xiaoleilu.hutool.date.DateUtil.format((Date)date, (String)SHORT_DATE_PATTERN_NONE);
    }

    public static String formatDate(Date date, String format) {
        return com.xiaoleilu.hutool.date.DateUtil.format((Date)date, (String)format);
    }

    public static String formatDateTime(Date date) {
        return com.xiaoleilu.hutool.date.DateUtil.formatDateTime((Date)date);
    }

    public static String formatDateCompact(Date date) {
        return DateUtil.formatDate(date, COMPACT_TIME_PATTERN);
    }

    public static String formatTime(Date date) {
        return com.xiaoleilu.hutool.date.DateUtil.formatTime((Date)date);
    }

    public static Date parseDate(String date, String format) {
        if (date == null || StringUtils.isEmpty((CharSequence)format)) {
            return null;
        }
        return com.xiaoleilu.hutool.date.DateUtil.parse((String)date, (String)format);
    }

    public static Date parseDateSimple(String date) {
        if (date == null) {
            return null;
        }
        return com.xiaoleilu.hutool.date.DateUtil.parse((String)date, (String)SHORT_DATE_PATTERN_LINE);
    }

    public static Date parseStringDate(String date) {
        if (date == null) {
            return null;
        }
        return com.xiaoleilu.hutool.date.DateUtil.parse((String)date, (String)LONG_DATE_PATTERN_LINE);
    }

    public static Date parseDateTime(String date) {
        if (date == null) {
            return null;
        }
        return com.xiaoleilu.hutool.date.DateUtil.parseDateTime((String)date);
    }

    public static Date parseDateTime(Long date) {
        if (date == null) {
            return null;
        }
        return com.xiaoleilu.hutool.date.DateUtil.parseDateTime((String)DateUtil.formatTimeStamp(date));
    }

    public static Date beginOfDay(Date date) {
        return new DateTime(DateUtil.beginOfDay(DateUtil.calendar(date)).getTime());
    }

    public static Date endOfDay(Date date) {
        return new DateTime(DateUtil.endOfDay(DateUtil.calendar(date)).getTime());
    }

    public static Date beginOfMonth(Date date) {
        return com.xiaoleilu.hutool.date.DateUtil.beginOfMonth((Date)date);
    }

    public static Date endOfMonth(Date date) {
        return com.xiaoleilu.hutool.date.DateUtil.endOfMonth((Date)date);
    }

    public static Date beginOfLastMonth() {
        return com.xiaoleilu.hutool.date.DateUtil.beginOfMonth((Date)DateUtil.lastMonth());
    }

    public static Date endOfLastMonth() {
        return com.xiaoleilu.hutool.date.DateUtil.endOfMonth((Date)DateUtil.lastMonth());
    }

    public static Date beginOfWeek(Date date) {
        return com.xiaoleilu.hutool.date.DateUtil.beginOfWeek((Date)date);
    }

    public static Date endOfWeek(Date date) {
        return com.xiaoleilu.hutool.date.DateUtil.endOfWeek((Date)date);
    }

    private static Calendar calendar(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    private static Calendar beginOfDay(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    private static Calendar endOfDay(Calendar calendar) {
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar;
    }

    public static Date yesterday() {
        return DateUtil.offsetDay(new Date(), -1);
    }

    public static Date tomorrow() {
        return DateUtil.offsetDay(new Date(), 1);
    }

    public static Date lastWeek() {
        return DateUtil.offsetWeek(new Date(), -1);
    }

    public static Date nextWeek() {
        return DateUtil.offsetWeek(new Date(), 1);
    }

    public static Date lastMonth() {
        return DateUtil.offsetMonth(new Date(), -1);
    }

    public static Date nextMonth() {
        return DateUtil.offsetMonth(new Date(), 1);
    }

    public static Date offsetMillisecond(Date date, int offset) {
        return DateUtil.offset(date, DateField.MILLISECOND, offset);
    }

    public static Date offsetSecond(Date date, int offset) {
        return DateUtil.offset(date, DateField.SECOND, offset);
    }

    public static Date offsetMinute(Date date, int offset) {
        return DateUtil.offset(date, DateField.MINUTE, offset);
    }

    public static Date offsetHour(Date date, int offset) {
        return DateUtil.offset(date, DateField.HOUR_OF_DAY, offset);
    }

    public static Date offsetDay(Date date, int offset) {
        return DateUtil.offset(date, DateField.DAY_OF_YEAR, offset);
    }

    public static Date offsetWeek(Date date, int offset) {
        return DateUtil.offset(date, DateField.WEEK_OF_YEAR, offset);
    }

    public static Date offsetMonth(Date date, int offset) {
        return DateUtil.offset(date, DateField.MONTH, offset);
    }

    public static DateTime offset(Date date, DateField dateField, int offset) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(dateField.getValue(), offset);
        return new DateTime(cal.getTime());
    }

    public static long between(Date beginDate, Date endDate, DateUnit unit) {
        return new DateBetween(beginDate, endDate).between(unit);
    }

    public static long betweenMs(Date beginDate, Date endDate) {
        return new DateBetween(beginDate, endDate).between(DateUnit.MS);
    }

    public static long betweenDay(Date beginDate, Date endDate, boolean isReset) {
        if (isReset) {
            beginDate = DateUtil.beginOfDay(beginDate);
            endDate = DateUtil.beginOfDay(endDate);
        }
        return DateUtil.between(beginDate, endDate, DateUnit.DAY);
    }

    public static long betweenMonth(Date beginDate, Date endDate, boolean isReset) {
        return new DateBetween(beginDate, endDate).betweenMonth(isReset);
    }

    public static long betweenYear(Date beginDate, Date endDate, boolean isReset) {
        return new DateBetween(beginDate, endDate).betweenYear(isReset);
    }

    public static String betweenFormat(Date beginDate, Date endDate, BetweenFormater.Level level) {
        return DateUtil.betweenFormat(DateUtil.between(beginDate, endDate, DateUnit.MS), level);
    }

    public static String betweenFormat(Date beginDate, Date endDate) {
        return DateUtil.betweenFormat(DateUtil.between(beginDate, endDate, DateUnit.MS));
    }

    public static String betweenFormat(long betweenMs, BetweenFormater.Level level) {
        return new BetweenFormater(betweenMs, level).format();
    }

    public static String betweenFormat(long betweenMs) {
        return new BetweenFormater(betweenMs, BetweenFormater.Level.MILLSECOND).format();
    }

    public static boolean isIn(Date date, Date beginDate, Date endDate) {
        if (date instanceof DateTime) {
            return ((DateTime)date).isIn(beginDate, endDate);
        }
        return new DateTime(date).isIn(beginDate, endDate);
    }

    public static long spendNt(long preTime) {
        return System.nanoTime() - preTime;
    }

    public static long spendMs(long preTime) {
        return System.currentTimeMillis() - preTime;
    }

    public static int toIntSecond(Date date) {
        return Integer.parseInt(com.xiaoleilu.hutool.date.DateUtil.format((Date)date, (String)"yyMMddHHmm"));
    }

    public static int weekCount(Date start, Date end) {
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(start);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(end);
        int startWeekofYear = startCalendar.get(3);
        int endWeekofYear = endCalendar.get(3);
        int count = endWeekofYear - startWeekofYear + 1;
        if (1 != startCalendar.get(7)) {
            --count;
        }
        return count;
    }

    public static int ageOfNow(String birthDay) {
        return com.xiaoleilu.hutool.date.DateUtil.ageOfNow((String)birthDay);
    }

    public static int ageOfNow(Date birthDay) {
        return com.xiaoleilu.hutool.date.DateUtil.ageOfNow((Date)birthDay);
    }

    public static boolean isAM(Date date) {
        return DateTime.of((Date)date).isAM();
    }

    public static boolean isPM(Date date) {
        return DateTime.of((Date)date).isPM();
    }

    public static boolean isLeapYear(int year) {
        return new GregorianCalendar().isLeapYear(year);
    }

    public static boolean isSameDate(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        boolean isSameYear = cal1.get(1) == cal2.get(1);
        boolean isSameMonth = isSameYear && cal1.get(2) == cal2.get(2);
        boolean isSameDate = isSameMonth && cal1.get(5) == cal2.get(5);
        return isSameDate;
    }

    private static String yearAndSeason(Calendar cal) {
        return "" + cal.get(1) + (cal.get(2) / 3 + 1);
    }

    public static int getDay() {
        return DateUtil.getDay(System.currentTimeMillis());
    }

    public static int getDay(Date date) {
        return DateUtil.getDay(date.getTime());
    }

    public static int getDay(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        return cal.get(5);
    }

    public static int getMonth() {
        return DateUtil.getMonth(System.currentTimeMillis());
    }

    public static int getMonth(Date date) {
        return DateUtil.getMonth(date.getTime());
    }

    public static int getMonth(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        return cal.get(2) + 1;
    }

    public static int getYear() {
        return DateUtil.getYear(System.currentTimeMillis());
    }

    public static int getYear(Date date) {
        return DateUtil.getYear(date.getTime());
    }

    public static int getYear(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        return cal.get(1);
    }

    public static boolean checkDateFormat(String dateStr, String separator, Date ... dates) {
        int day;
        int month;
        int year;
        if (StringUtils.isBlank((CharSequence)dateStr)) {
            return false;
        }
        String[] array = dateStr.split(separator);
        if (array.length != DATE_STR_COUNTS) {
            return false;
        }
        try {
            year = Integer.parseInt(array[0]);
            month = Integer.parseInt(array[1]);
            day = Integer.parseInt(array[2]);
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (dates != null && dates.length >= 1) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(year, month - 1, day);
            dates[0] = calendar.getTime();
        }
        if (year >= 1 && year <= DATE_MAX_YEAR) {
            switch (month) {
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 10: 
                case 12: {
                    return day >= 1 && day <= 31;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    return day >= 1 && day <= 30;
                }
                case 2: {
                    boolean isYear;
                    boolean bl = isYear = year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
                    if (isYear) {
                        return day >= 1 && day <= 29;
                    }
                    return day >= 1 && day <= 28;
                }
            }
            return false;
        }
        return false;
    }
}

