/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.auth.common.util;

import java.util.ArrayList;
import java.util.List;
import org.springframework.cglib.beans.BeanCopier;

public class BeanCopierUtil {
    public static <T> T copy(Object source, Class<T> targetClass) {
        T t = null;
        try {
            t = targetClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Create new instance of %s failed: %s");
        }
        BeanCopierUtil.copyProperty(source, t);
        return t;
    }

    public static <T> List<T> copyList(List orig, Class<T> dest) {
        try {
            ArrayList<T> resultList = new ArrayList<T>();
            if (orig == null || orig.size() <= 0) {
                return resultList;
            }
            for (Object o : orig) {
                T destObject = dest.newInstance();
                if (o == null) continue;
                BeanCopierUtil.copyProperty(o, destObject);
                resultList.add(destObject);
            }
            return resultList;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void copyProperty(Object source, Object target) {
        BeanCopier copier = BeanCopier.create(source.getClass(), target.getClass(), (boolean)false);
        copier.copy(source, target, null);
    }
}

