/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.auth.common.mode.result;

import com.fshows.auth.common.constant.NumberConstant;
import com.fshows.auth.common.mode.result.BasePageModel;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class BasePageModelResult<T>
extends BasePageModel {
    private static final long serialVersionUID = -1L;
    @ApiModelProperty(value="\u603b\u8bb0\u5f55\u6570 ", required=true)
    private long total;
    @ApiModelProperty(value="\u5206\u9875\u4fe1\u606f", required=true)
    private List<T> list;

    public BasePageModelResult() {
        this.total = 0L;
        this.page = NumberConstant.ONE;
        this.pageSize = NumberConstant.TEN;
        this.list = Lists.newArrayList();
    }

    public BasePageModelResult(int total, List<T> list) {
        this.total = total;
        this.list = list;
        if (CollectionUtils.isEmpty(list)) {
            this.list = Lists.newArrayList();
        }
    }

    public BasePageModelResult(int page, int pageSize, long total, List<T> returnDo) {
        this.page = page;
        this.pageSize = pageSize;
        this.total = total;
        this.list = returnDo;
    }

    public BasePageModelResult(PageInfo pageInfo) {
        this.page = pageInfo.getPageNum();
        this.pageSize = pageInfo.getPageSize();
        this.total = pageInfo.getTotal();
        this.list = pageInfo.getList();
    }

    public BasePageModelResult(PageInfo pageInfo, List<T> returnDo) {
        this.page = pageInfo.getPageNum();
        this.pageSize = pageInfo.getPageSize();
        this.total = pageInfo.getTotal();
        this.list = returnDo;
    }

    public static <T> BasePageModelResult<T> newBasePageResult(int total, List<T> list) {
        return new BasePageModelResult<T>(total, list);
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public List<T> getList() {
        return this.list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

