/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.transaction;

import com.aliyun.openservices.shade.org.apache.commons.lang3.time.DateFormatUtils;
import com.fshows.ark.spring.boot.starter.core.mq.base.FsMessage;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsMessageSendContext;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.transaction.TransactionMessageDao;
import com.fshows.ark.spring.boot.starter.enums.MsgTypeEnum;
import com.fshows.ark.spring.boot.starter.exception.MQProducerException;
import com.fshows.ark.spring.boot.starter.util.StrUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionMessageDaoImpl
implements TransactionMessageDao {
    private static final Logger log = LoggerFactory.getLogger(TransactionMessageDaoImpl.class);
    private static final String INSERT_MQ_SQL = "INSERT INTO `tp_lifecircle_mq_retry`(`original_date`, `topic`, `msg_key`, `tag`, `content`, `producer_group`, `msg_type`, `start_deliver_time`) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String QUERY_INSERT_ID = "SELECT LAST_INSERT_ID()";
    private static final String UPDATE_MSG_SEND_STATUS = "UPDATE `tp_lifecircle_mq_retry` SET RETRY_STATE = ? WHERE ID = ?";
    private static final int RETRY_STATE_SUCCESS = 1;

    @Override
    public void insertTransactionMessage(Connection conn, FsMessageSendContext context) {
        PreparedStatement pStatement = null;
        Statement statement = null;
        try {
            FsMessage fsMessage = context.getFsMessage();
            pStatement = conn.prepareStatement(INSERT_MQ_SQL);
            pStatement.setLong(1, Long.parseLong(DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")));
            pStatement.setString(2, StrUtil.ifNullDefaultEmpty(fsMessage.getTopic()));
            pStatement.setString(3, StrUtil.ifNullDefaultEmpty(fsMessage.getKey()));
            pStatement.setString(4, StrUtil.ifNullDefaultEmpty(fsMessage.getTag()));
            pStatement.setString(5, StrUtil.ifNullDefaultEmpty(fsMessage.getContent()));
            pStatement.setString(6, StrUtil.ifNullDefaultEmpty(context.getRocketSendMessageMethodModel().getGroupId()));
            pStatement.setInt(7, MsgTypeEnum.TRANSACTION_MESSAGE.getValue());
            String transactionLocalTimeOut = context.getRocketSendMessageMethodModel().getTransactionMessageMethodModel().getTransactionLocalTimeOut();
            pStatement.setLong(8, System.currentTimeMillis() + Long.parseLong(transactionLocalTimeOut));
            pStatement.executeUpdate();
            statement = conn.createStatement();
            ResultSet resultSet = statement.executeQuery(QUERY_INSERT_ID);
            if (resultSet.next()) {
                fsMessage.setTransactionMessageId(resultSet.getString(1));
            }
        }
        catch (SQLException e) {
            log.error("ark-spring-boot-starter >> \u4e8b\u52a1\u6d88\u606f\u63d2\u5165\u672c\u5730\u6d88\u606f\u8868\u5931\u8d25!context={}", (Object)e, (Object)context);
            throw new MQProducerException("ark-spring-boot-starter >> \u4e8b\u52a1\u6d88\u606f\u63d2\u5165\u672c\u5730\u6d88\u606f\u8868\u5931\u8d25\uff01");
        }
        finally {
            if (pStatement != null) {
                try {
                    pStatement.close();
                }
                catch (SQLException e) {
                    log.error("ark-spring-boot-starter >> \u4e8b\u52a1\u6d88\u606fpStatement\u5173\u95ed\u5931\u8d25\uff01context={}", (Object)e, (Object)context);
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    log.error("ark-spring-boot-starter >> \u4e8b\u52a1\u6d88\u606fpStatement\u5173\u95ed\u5931\u8d25\uff01context={}", (Object)e, (Object)context);
                }
            }
        }
    }

    @Override
    public void updateMsgSendStatusToSuccess(Connection conn, FsMessageSendContext context) {
        PreparedStatement pStatement = null;
        Statement statement = null;
        try {
            FsMessage fsMessage = context.getFsMessage();
            pStatement = conn.prepareStatement(UPDATE_MSG_SEND_STATUS);
            pStatement.setLong(1, 1L);
            pStatement.setLong(2, Long.parseLong(fsMessage.getTransactionMessageId()));
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            log.error("ark-spring-boot-starter >> \u4e8b\u52a1\u6d88\u606f\u66f4\u65b0\u53d1\u9001\u72b6\u6001\u5931\u8d25!context={}", (Object)e, (Object)context);
            throw new MQProducerException("ark-spring-boot-starter >> \u4e8b\u52a1\u6d88\u606f\u66f4\u65b0\u53d1\u9001\u72b6\u6001\u5931\u8d25\uff01");
        }
        finally {
            if (pStatement != null) {
                try {
                    pStatement.close();
                }
                catch (SQLException e) {
                    log.error("ark-spring-boot-starter >> \u4e8b\u52a1\u6d88\u606fpStatement\u5173\u95ed\u5931\u8d25\uff01context={}", (Object)e, (Object)context);
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    log.error("ark-spring-boot-starter >> \u4e8b\u52a1\u6d88\u606fpStatement\u5173\u95ed\u5931\u8d25\uff01context={}", (Object)e, (Object)context);
                }
            }
        }
    }
}

