/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.SendCallback;
import com.aliyun.openservices.ons.api.SendResult;
import com.aliyun.openservices.ons.api.bean.ProducerBean;
import com.fshows.ark.spring.boot.starter.core.mq.base.FsMessage;
import com.fshows.ark.spring.boot.starter.core.mq.base.FsMessageConvert;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsMessageSendContext;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendErrorCallback;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendResult;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendSuccessCallback;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.IFshowsProducer;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.TransactionCommitCallback;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.TransactionMessageManage;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.interceptor.ProducerInterceptorActuator;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.AliyunSendCallBackWrap;
import com.fshows.ark.spring.boot.starter.enums.ProducerSendTypeEnum;
import com.fshows.ark.spring.boot.starter.enums.ProducerTypeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunFshowsProducerImpl
implements IFshowsProducer {
    private static final Logger log = LoggerFactory.getLogger(AliyunFshowsProducerImpl.class);
    private ProducerBean producerBean;
    private String charsetName;
    private ProducerInterceptorActuator producerInterceptorActuator;
    private TransactionMessageManage transactionMessageManage;

    AliyunFshowsProducerImpl(ProducerBean producerBean, String charsetName) {
        this.producerBean = producerBean;
        this.charsetName = charsetName;
    }

    AliyunFshowsProducerImpl(ProducerBean producerBean, String charsetName, ProducerInterceptorActuator producerInterceptorActuator, TransactionMessageManage transactionMessageManage) {
        this.producerBean = producerBean;
        this.charsetName = charsetName;
        this.producerInterceptorActuator = producerInterceptorActuator;
        this.transactionMessageManage = transactionMessageManage;
    }

    @Override
    public void start() {
        this.producerBean.start();
    }

    @Override
    public void shutdown() {
        this.producerBean.shutdown();
    }

    @Override
    public FsSendResult send(FsMessage fsMessage) {
        FsMessageSendContext context = this.buildMsgContext(fsMessage, ProducerSendTypeEnum.SYNC, null, null);
        this.producerInterceptorActuator.doBeforeSend(context);
        FsSendResult fsSendResult = this.doSend(fsMessage);
        this.producerInterceptorActuator.doAfterSend(context, fsSendResult);
        return fsSendResult;
    }

    private FsSendResult doSend(FsMessage fsMessage) {
        Message message = FsMessageConvert.convertMessage(fsMessage, this.charsetName);
        SendResult sendResult = this.producerBean.send(message);
        FsSendResult fsSendResult = FsMessageConvert.convertFsSendResult(sendResult);
        return fsSendResult;
    }

    @Override
    public void sendOneway(FsMessage fsMessage) {
        FsMessageSendContext context = this.buildMsgContext(fsMessage, ProducerSendTypeEnum.ONE_WAY, null, null);
        this.producerInterceptorActuator.doBeforeSend(context);
        this.doSendOneway(fsMessage);
        this.producerInterceptorActuator.doAfterSend(context, null);
    }

    private void doSendOneway(FsMessage fsMessage) {
        Message message = FsMessageConvert.convertMessage(fsMessage, this.charsetName);
        this.producerBean.sendOneway(message);
    }

    @Override
    public void sendAsync(FsMessage fsMessage, FsSendSuccessCallback sendSuccessCallback, FsSendErrorCallback fsSendErrorCallback) {
        FsMessageSendContext context = this.buildMsgContext(fsMessage, ProducerSendTypeEnum.ASYNC, sendSuccessCallback, fsSendErrorCallback);
        this.producerInterceptorActuator.doBeforeSend(context);
        this.doSendAsync(context, sendSuccessCallback, fsSendErrorCallback, this.producerInterceptorActuator);
    }

    private FsMessageSendContext buildMsgContext(FsMessage fsMessage, ProducerSendTypeEnum sendTypeEnum, FsSendSuccessCallback successCallback, FsSendErrorCallback errorCallback) {
        FsMessageSendContext context = new FsMessageSendContext();
        context.setProducerSendTypeEnum(sendTypeEnum);
        context.setProducerTypeEnum(ProducerTypeEnum.DEFAULT_NOMAL_PRODUCER);
        context.setSuccessCallback(successCallback);
        context.setErrorCallback(errorCallback);
        context.setFsMessage(fsMessage);
        return context;
    }

    private void doSendAsync(FsMessageSendContext context, FsSendSuccessCallback sendSuccessCallback, FsSendErrorCallback fsSendErrorCallback, ProducerInterceptorActuator producerInterceptorActuator) {
        Message message = FsMessageConvert.convertMessage(context.getFsMessage(), this.charsetName);
        try {
            this.producerBean.sendAsync(message, (SendCallback)new AliyunSendCallBackWrap(sendSuccessCallback, fsSendErrorCallback, context, producerInterceptorActuator));
        }
        catch (Exception e) {
            producerInterceptorActuator.doAfterSend(context, new FsSendResult(e));
            throw e;
        }
    }

    @Override
    public void sendAsync(FsMessage fsMessage, FsSendSuccessCallback sendSuccessCallback) {
        FsMessageSendContext context = this.buildMsgContext(fsMessage, ProducerSendTypeEnum.ASYNC, sendSuccessCallback, null);
        this.producerInterceptorActuator.doBeforeSend(context);
        this.doSendAsync(context, sendSuccessCallback, null, this.producerInterceptorActuator);
    }

    @Override
    public void sendAsync(FsMessage fsMessage, FsSendErrorCallback fsSendErrorCallback) {
        FsMessageSendContext context = this.buildMsgContext(fsMessage, ProducerSendTypeEnum.ASYNC, null, fsSendErrorCallback);
        this.producerInterceptorActuator.doBeforeSend(context);
        this.doSendAsync(context, null, fsSendErrorCallback, this.producerInterceptorActuator);
    }

    @Override
    public FsSendResult send(FsMessageSendContext context) {
        if (ProducerTypeEnum.TRANSACTION_MESSAGE_PRODUCER.equals((Object)context.getProducerTypeEnum()) && this.transactionMessageManage.isInTransaction()) {
            return this.sendTransactionMsg(context);
        }
        return this.sendNormalMsg(context);
    }

    private FsSendResult sendTransactionMsg(FsMessageSendContext context) {
        this.producerInterceptorActuator.doBeforeSend(context);
        TransactionCommitCallback commitCallback = (msgctx, fsSendResult) -> {
            try {
                if (!fsSendResult.isSuccess()) {
                    return true;
                }
                this.producerInterceptorActuator.doAfterSend(context, fsSendResult);
                FsSendResult sendResult = this.doSend(context.getFsMessage());
                if (sendResult.isSuccess()) {
                    this.transactionMessageManage.updateMsgSendStatusToSuccess(msgctx);
                }
            }
            catch (Exception e) {
                log.error("ark-spring-boot-starter >> \u4e8b\u52a1\u6d88\u606f\u540e\u7f6e\u540c\u6b65\u5904\u7406\u5f02\u5e38\uff01message={}", (Object)e, (Object)context.getFsMessage());
                return false;
            }
            return true;
        };
        return this.transactionMessageManage.sendTransactionMsg(context, commitCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FsSendResult sendNormalMsg(FsMessageSendContext context) {
        FsSendResult fsSendResult = null;
        this.producerInterceptorActuator.doBeforeSend(context);
        if (ProducerSendTypeEnum.SYNC.equals((Object)context.getProducerSendTypeEnum())) {
            try {
                fsSendResult = this.doSend(context.getFsMessage());
            }
            catch (Exception ex) {
                fsSendResult = new FsSendResult(ex);
                if (context.getRocketSendMessageMethodModel() != null && context.getRocketSendMessageMethodModel().isSendErrorThrowEx()) {
                    throw ex;
                }
            }
            finally {
                this.producerInterceptorActuator.doAfterSend(context, fsSendResult);
            }
        }
        if (ProducerSendTypeEnum.ASYNC.equals((Object)context.getProducerSendTypeEnum())) {
            this.doSendAsync(context, context.getSuccessCallback(), context.getErrorCallback(), this.producerInterceptorActuator);
        }
        if (ProducerSendTypeEnum.ONE_WAY.equals((Object)context.getProducerSendTypeEnum())) {
            this.doSendOneway(context.getFsMessage());
            this.producerInterceptorActuator.doAfterSend(context, null);
        }
        return fsSendResult;
    }
}

