/**
 * fshows.com
 * Copyright (C) 2013-2019 All Rights Reserved.
 */
package com.fshows.ark.spring.boot.starter.extend.mq.configlistener;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.model.ConfigChange;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * 阿波罗配置变更监听器
 *
 * @author Liluqing
 * @version ConfigServicesListener.java, v 0.1 2019-10-08 16:15
 */
public class ApolloConfigServicesListener implements ApplicationRunner {

    @Autowired
    private ConsumeConfigChangeListener consumeConfigChangeListener;

    @Autowired
    private ProducerConfigChangeListener producerConfigChangeListener;

    private ExecutorService executorService = Executors.newFixedThreadPool(1);

    public ApolloConfigServicesListener() {

    }

    @Override
    public void run(ApplicationArguments args) {
        // 注册阿波罗监听
        Config config = ConfigService.getAppConfig();
        config.addChangeListener(changeEvent -> {
            List<ConfigChangeModel> configChangeModelList = new ArrayList<>();
            for (String key : changeEvent.changedKeys()) {
                ConfigChange change = changeEvent.getChange(key);
                configChangeModelList.add(convertConfigChangeModel(change));
            }
            // 排队等待工作线程处理,当前仅一个工作线程,避免频繁配置变更导致并发刷新配置
            executorService.execute(() -> consumeConfigChangeListener.reloadConfig(configChangeModelList));

            // 刷新生产者配置
            executorService.execute(() -> producerConfigChangeListener.reloadConfig(configChangeModelList));
        });
    }

    /**
     * ConfigChange 转 ConfigChangeModel
     *
     * @param change
     * @return
     */
    public ConfigChangeModel convertConfigChangeModel(ConfigChange change) {
        ConfigChangeModel configChangeModel = new ConfigChangeModel();
        configChangeModel.setKey(change.getPropertyName());
        configChangeModel.setOldValue(change.getOldValue());
        configChangeModel.setNewValue(change.getNewValue());
        return configChangeModel;
    }

}