/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.core.mq.rocketmq.interceptor.consumer;

import com.fshows.ark.spring.boot.starter.core.mq.base.FsMessage;
import com.fshows.ark.spring.boot.starter.core.mq.base.consumer.FsConsumerInterceptor;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsMessageSendContext;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsProducerInterceptor;

import java.util.List;

/**
 * 生产者拦截管理器
 *
 * @author liluqing
 * @version ProducerInterceptorManagement.java, v 0.1 2021-10-26 20:41
 */
public interface IConsumerInterceptorManagement {

    /**
     * 注册一个拦截器
     */
    void registerInterceptor(FsConsumerInterceptor fsConsumerInterceptor);

    /**
     * 获取所有的已注册的拦截器
     *
     * @return
     */
    List<FsConsumerInterceptor> getAllInterceptor();

    /**
     * 消息消费前置处理,如抛出异常会消费失败
     *
     * @param fsMessage
     */
    void doBeforeConsume(FsMessage fsMessage);

    /**
     * 执行消息发送之后的处理
     *
     * @param fsMessage
     */
    void doAfterConsume(FsMessage fsMessage, boolean consumeResult);
}