/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.core.mq.rocketmq.interceptor.consumer;

import com.fshows.ark.spring.boot.starter.core.mq.base.FsMessage;
import com.fshows.ark.spring.boot.starter.core.mq.base.consumer.FsConsumerInterceptor;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsMessageSendContext;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsProducerInterceptor;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.interceptor.DefaultProducerInterceptorActuator;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.interceptor.IProducerInterceptorManagement;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.interceptor.ProducerInterceptorActuator;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

/**
 * 生产者拦截器管理器
 *
 * @author liluqing
 * @version DefaultProducerInterceptorManagement.java, v 0.1 2021-10-26 20:51
 */
public class DefaultConsumerInterceptorManagement implements IConsumerInterceptorManagement, ApplicationContextAware, InitializingBean {

    /**
     * spring上下文
     */
    private ApplicationContext applicationContext;

    /**
     * 拦截器列表
     */
    private List<FsConsumerInterceptor> interceptorList = new CopyOnWriteArrayList<>();

    /**
     * 初始化生产者拦截器
     *
     * @throws Exception
     */
    @Override
    public void afterPropertiesSet() throws Exception {
        Map<String, FsConsumerInterceptor> map = applicationContext.getBeansOfType(FsConsumerInterceptor.class);
        if (map != null) {
            map.values().stream().forEach(interceptorList::add);
        }
        // 将拦截器按照spring的@Order注解进行排序
        AnnotationAwareOrderComparator.sort(interceptorList);
    }

    @Override
    public void registerInterceptor(FsConsumerInterceptor fsConsumerInterceptor) {
        if (fsConsumerInterceptor != null) {
            interceptorList.add(fsConsumerInterceptor);
            // 将拦截器按照spring的@Order注解进行排序
            AnnotationAwareOrderComparator.sort(interceptorList);
        }
    }

    @Override
    public List<FsConsumerInterceptor> getAllInterceptor() {
        return interceptorList;
    }

    @Override
    public void doBeforeConsume(FsMessage fsMessage) {
        for (FsConsumerInterceptor consumerInterceptor : interceptorList) {
            consumerInterceptor.beforeConsume(fsMessage);
        }
    }

    @Override
    public void doAfterConsume(FsMessage fsMessage, boolean consumeResult) {
        for (FsConsumerInterceptor consumerInterceptor : interceptorList) {
            consumerInterceptor.afterConsume(fsMessage, consumeResult);
        }
    }


    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}