/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.core.mq.base.producer;

import com.fshows.ark.spring.boot.starter.core.mq.base.FsMessage;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.RocketSendMessageMethodModel;
import com.fshows.ark.spring.boot.starter.enums.ProducerSendTypeEnum;
import com.fshows.ark.spring.boot.starter.enums.ProducerTypeEnum;
import lombok.Data;

/**
 * 消息发送上下文
 *
 * @author liluqing
 * @version FsMessageSendContext.java, v 0.1 2021-11-19 15:06
 */
@Data
public class FsMessageSendContext {

    /**
     * 本次发送的消息内容
     */
    private FsMessage fsMessage;

    /**
     * 生产者源数据
     */
    private RocketSendMessageMethodModel rocketSendMessageMethodModel;

    /**
     * 发送成功之后的回调，异步发送才有值
     */
    private FsSendSuccessCallback successCallback;

    /**
     * 消息发送失败回调，异步发送才有值
     */
    private FsSendErrorCallback errorCallback;

    /**
     * 消息发送类型
     */
    private ProducerSendTypeEnum producerSendTypeEnum;

    /**
     * 本次发送的发送器类型
     */
    private ProducerTypeEnum producerTypeEnum;
}