/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.annotation.mq;

import com.fshows.ark.spring.boot.starter.enums.ProducerSendTypeEnum;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 *
 * @author liluqing
 * @version RocketMessage.java, v 0.1 2021-08-12 19:54
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD, ElementType.ANNOTATION_TYPE})
@Inherited
public @interface RocketMessage {

    /**
     * topic
     *
     * @return
     */
    String topic() default "";

    /**
     * msg key前缀
     *  （消息的key都会默认添加该前缀）
     *
     * @return
     */
    String msgKeyPrefix() default "";


    /**
     * 生产者组
     *
     * @return
     */
    String tag() default "";

    /**
     * 延迟投递时间,单位毫秒
     *
     * @return
     */
    String delayTime() default "0";

    /**
     * 发送失败时是否抛出异常：true-抛出异常    false: 将异常封装成FsSendResult结果正常返回
     *
     * @return
     */
    boolean sendErrorThrowEx() default false;

    /**
     * 消息发送方式
     *
     * @return
     */
    ProducerSendTypeEnum sendType() default ProducerSendTypeEnum.SYNC;
}