/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.SendCallback;
import com.aliyun.openservices.ons.api.SendResult;
import com.aliyun.openservices.ons.api.bean.ProducerBean;
import com.fshows.ark.spring.boot.starter.core.mq.base.FsMessage;
import com.fshows.ark.spring.boot.starter.core.mq.base.FsMessageConvert;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsMessageSendContext;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendErrorCallback;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendResult;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendSuccessCallback;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.IFshowsProducer;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.AliyunSendCallBackWrap;
import com.fshows.ark.spring.boot.starter.enums.ProducerSendTypeEnum;
import com.fshows.ark.spring.boot.starter.enums.ProducerTypeEnum;

public class SimpleFshowsProducerImpl
implements IFshowsProducer {
    private ProducerBean producerBean;
    private String charsetName;

    SimpleFshowsProducerImpl(ProducerBean producerBean, String charsetName) {
        this.producerBean = producerBean;
        this.charsetName = charsetName;
    }

    @Override
    public void start() {
        this.producerBean.start();
    }

    @Override
    public void shutdown() {
        this.producerBean.shutdown();
    }

    @Override
    public FsSendResult send(FsMessage fsMessage) {
        FsSendResult fsSendResult = this.doSend(fsMessage);
        return fsSendResult;
    }

    private FsSendResult doSend(FsMessage fsMessage) {
        Message message = FsMessageConvert.convertMessage(fsMessage, this.charsetName);
        SendResult sendResult = this.producerBean.send(message);
        FsSendResult fsSendResult = FsMessageConvert.convertFsSendResult(sendResult);
        return fsSendResult;
    }

    @Override
    public void sendOneway(FsMessage fsMessage) {
        this.doSendOneway(fsMessage);
    }

    private void doSendOneway(FsMessage fsMessage) {
        Message message = FsMessageConvert.convertMessage(fsMessage, this.charsetName);
        this.producerBean.sendOneway(message);
    }

    @Override
    public void sendAsync(FsMessage fsMessage, FsSendSuccessCallback sendSuccessCallback, FsSendErrorCallback fsSendErrorCallback) {
        FsMessageSendContext context = this.buildMsgContext(fsMessage, ProducerSendTypeEnum.ASYNC, sendSuccessCallback, fsSendErrorCallback);
        this.doSendAsync(context, sendSuccessCallback, fsSendErrorCallback);
    }

    private FsMessageSendContext buildMsgContext(FsMessage fsMessage, ProducerSendTypeEnum sendTypeEnum, FsSendSuccessCallback successCallback, FsSendErrorCallback errorCallback) {
        FsMessageSendContext context = new FsMessageSendContext();
        context.setProducerSendTypeEnum(sendTypeEnum);
        context.setProducerTypeEnum(ProducerTypeEnum.TRANSACTION_MESSAGE_PRODUCER);
        context.setSuccessCallback(successCallback);
        context.setErrorCallback(errorCallback);
        context.setFsMessage(fsMessage);
        return context;
    }

    private void doSendAsync(FsMessageSendContext context, FsSendSuccessCallback sendSuccessCallback, FsSendErrorCallback fsSendErrorCallback) {
        Message message = FsMessageConvert.convertMessage(context.getFsMessage(), this.charsetName);
        this.producerBean.sendAsync(message, (SendCallback)new AliyunSendCallBackWrap(sendSuccessCallback, fsSendErrorCallback));
    }

    @Override
    public void sendAsync(FsMessage fsMessage, FsSendSuccessCallback sendSuccessCallback) {
        FsMessageSendContext context = this.buildMsgContext(fsMessage, ProducerSendTypeEnum.ASYNC, sendSuccessCallback, null);
        this.doSendAsync(context, sendSuccessCallback, null);
    }

    @Override
    public void sendAsync(FsMessage fsMessage, FsSendErrorCallback fsSendErrorCallback) {
        FsMessageSendContext context = this.buildMsgContext(fsMessage, ProducerSendTypeEnum.ASYNC, null, fsSendErrorCallback);
        this.doSendAsync(context, null, fsSendErrorCallback);
    }

    @Override
    public FsSendResult send(FsMessageSendContext context) {
        FsSendResult fsSendResult;
        block5: {
            fsSendResult = null;
            if (ProducerSendTypeEnum.SYNC.equals((Object)context.getProducerSendTypeEnum())) {
                try {
                    fsSendResult = this.doSend(context.getFsMessage());
                }
                catch (Exception ex) {
                    fsSendResult = new FsSendResult(ex);
                    if (context.getRocketSendMessageMethodModel() == null || !context.getRocketSendMessageMethodModel().isSendErrorThrowEx()) break block5;
                    throw ex;
                }
            }
        }
        if (ProducerSendTypeEnum.ASYNC.equals((Object)context.getProducerSendTypeEnum())) {
            this.doSendAsync(context, context.getSuccessCallback(), context.getErrorCallback());
        }
        if (ProducerSendTypeEnum.ONE_WAY.equals((Object)context.getProducerSendTypeEnum())) {
            this.doSendOneway(context.getFsMessage());
        }
        return fsSendResult;
    }
}

