/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.enums;

/**
 * 生产者代理方法返回值类型
 *
 * @author liluqing
 * @version ProducerReturnTypeEnum.java, v 0.1 2021-08-29 13:49
 */
public enum ProducerReturnTypeEnum {

    /**
     * 枚举列表
     */
    VOID("无返回值", "void", new ProducerSendTypeEnum[]{
            ProducerSendTypeEnum.SYNC, ProducerSendTypeEnum.ASYNC, ProducerSendTypeEnum.ONE_WAY
    }),
    FS_SEND_RESULT("fs消息发送结果对象", "com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendResult",
            new ProducerSendTypeEnum[]{ProducerSendTypeEnum.SYNC});

    private String name;
    private String value;
    /**
     * 支持的消息发送类型
     */
    private ProducerSendTypeEnum[] sendTypeEnum;

    ProducerReturnTypeEnum(String name, String value, ProducerSendTypeEnum[] sendTypeEnum) {
        this.name = name;
        this.value = value;
        this.sendTypeEnum = sendTypeEnum;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    public ProducerSendTypeEnum[] getSendTypeEnum() {
        return sendTypeEnum;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }

    public static ProducerReturnTypeEnum getByValue(String value) {
        ProducerReturnTypeEnum[] valueList = ProducerReturnTypeEnum.values();
        for (ProducerReturnTypeEnum v : valueList) {
            if (v.getValue().equalsIgnoreCase(value)) {
                return v;
            }
        }
        return null;
    }
}