package com.fshows.ark.spring.boot.starter.core.sensitive.encrypt.interceptor;

import cn.hutool.core.collection.CollUtil;
import com.fshows.ark.spring.boot.starter.annotation.encrypt.LifecircleEncrypt;
import com.fshows.ark.spring.boot.starter.core.sensitive.encrypt.DefaultFieldEncryptExecutor;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.lang.reflect.Field;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;

/**
 * 敏感字段解密拦截器
 *
 * @author zhaoxumin
 * @version DecryptInterceptor.java, v 0.1 2024-05-29 21:55 zhaoxumin
 */
@Component
@Intercepts(
        @Signature(type = ResultSetHandler.class, method = "handleResultSets", args = {Statement.class})
)
public class DecryptInterceptor implements Interceptor {

    @Autowired
    private DefaultFieldEncryptExecutor defaultFieldEncryptExecutor;

    @Override
    public Object intercept(Invocation invocation) throws Throwable {
        Object resultObject = invocation.proceed();
        if (resultObject == null) {
            return null;
        }
        // 基于selectList
        if (resultObject instanceof ArrayList) {
            ArrayList resultList = (ArrayList) resultObject;
            if (CollUtil.isNotEmpty(resultList)) {
                for (Object result : resultList) {
                    Class<?> resultClass = result.getClass();
                    Field[] declaredFields = resultClass.getDeclaredFields();
                    for (Field field : declaredFields) {
                        LifecircleEncrypt encryptField = field.getAnnotation(LifecircleEncrypt.class);
                        if (encryptField != null) {
                            field.setAccessible(true);
                            Object object = field.get(result);
                            if (object instanceof String) {
                                String value = (String) object;
                                field.set(result, defaultFieldEncryptExecutor.decrypt(value));
                            }
                        }
                    }
                }
            }
        } else {
            Class<?> resultClass = resultObject.getClass();
            Field[] declaredFields = resultClass.getDeclaredFields();
            for (Field field : declaredFields) {
                LifecircleEncrypt encryptField = field.getAnnotation(LifecircleEncrypt.class);
                if (encryptField != null) {
                    field.setAccessible(true);
                    Object object = field.get(resultObject);
                    if (object instanceof String) {
                        String value = (String) object;
                        field.set(resultObject, defaultFieldEncryptExecutor.decrypt(value));
                    }
                }
            }
        }
        return resultObject;
    }

    @Override
    public Object plugin(Object target) {
        return Plugin.wrap(target, this);
    }

    @Override
    public void setProperties(Properties properties) {

    }
}
