/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.transaction;

import com.aliyun.openservices.shade.org.apache.commons.lang3.time.DateFormatUtils;
import com.fshows.ark.spring.boot.starter.core.mq.base.FsMessage;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsMessageSendContext;
import com.fshows.ark.spring.boot.starter.enums.MsgTypeEnum;
import com.fshows.ark.spring.boot.starter.exception.MQProducerException;
import com.fshows.ark.spring.boot.starter.util.StrUtil;
import lombok.extern.slf4j.Slf4j;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;

/**
 *
 *
 * @author liluqing
 * @version TransactionMessageDaoImpl.java, v 0.1 2021-12-21 18:00
 */
@Slf4j
public class TransactionMessageDaoImpl implements TransactionMessageDao {

    // 消息入库sql
    private static final String INSERT_MQ_SQL = "INSERT INTO `tp_lifecircle_mq_retry`(`original_date`, `topic`, `msg_key`, `tag`, `content`, `producer_group`, `msg_type`, `start_deliver_time`) "
            + "VALUES (?, ?, ?, ?, ?, ?, ?, ?)";

    // 查询最后一次插入的ID
    private static final String QUERY_INSERT_ID = "SELECT LAST_INSERT_ID()";

    // 更新消息发送状态
    private static final String UPDATE_MSG_SEND_STATUS = "UPDATE `tp_lifecircle_mq_retry` SET RETRY_STATE = ? WHERE ID = ?";

    // 消息重试成功
    private static final int RETRY_STATE_SUCCESS = 1;

    @Override
    public void insertTransactionMessage(Connection conn, FsMessageSendContext context) {
        PreparedStatement pStatement = null;
        Statement statement = null;
        //前面的索引对应上面的问号,传递参数。
        try {
            FsMessage fsMessage = context.getFsMessage();

            //预编译
            pStatement = conn.prepareStatement(INSERT_MQ_SQL);
            pStatement.setLong(1, Long.parseLong(DateFormatUtils.format(new Date(), "yyyyMMdd")));
            pStatement.setString(2, StrUtil.ifNullDefaultEmpty(fsMessage.getTopic()));
            pStatement.setString(3, StrUtil.ifNullDefaultEmpty(fsMessage.getKey()));
            pStatement.setString(4, StrUtil.ifNullDefaultEmpty(fsMessage.getTag()));
            pStatement.setString(5, StrUtil.ifNullDefaultEmpty(fsMessage.getContent()));
            pStatement.setString(6, StrUtil.ifNullDefaultEmpty(context.getRocketSendMessageMethodModel().getGroupId()));
            pStatement.setInt(7, MsgTypeEnum.TRANSACTION_MESSAGE.getValue());
            String transactionLocalTimeOut = context.getRocketSendMessageMethodModel().getTransactionMessageMethodModel().getTransactionLocalTimeOut();
            pStatement.setLong(8, System.currentTimeMillis() + Long.parseLong(transactionLocalTimeOut));
            pStatement.executeUpdate();

            // 查询消息ID
            statement = conn.createStatement();
            ResultSet resultSet = statement.executeQuery(QUERY_INSERT_ID);
            while (resultSet.next()){
                fsMessage.setTransactionMessageId(resultSet.getString(1));
                break;
            }
        } catch (SQLException e) {
            log.error("ark-spring-boot-starter >> 事务消息插入本地消息表失败!context={}", e, context);
            throw new MQProducerException("ark-spring-boot-starter >> 事务消息插入本地消息表失败！");
        } finally {
            if (pStatement != null) {
                try {
                    pStatement.close();
                } catch (SQLException e) {
                    log.error("ark-spring-boot-starter >> 事务消息pStatement关闭失败！context={}", e, context);
                }
            }

            if (statement != null) {
                try {
                    statement.close();
                } catch (SQLException e) {
                    log.error("ark-spring-boot-starter >> 事务消息pStatement关闭失败！context={}", e, context);
                }
            }
        }
    }

    @Override
    public void updateMsgSendStatusToSuccess(Connection conn, FsMessageSendContext context) {
        PreparedStatement pStatement = null;
        Statement statement = null;
        //前面的索引对应上面的问号,传递参数。
        try {
            // 获取消息
            FsMessage fsMessage = context.getFsMessage();
            //预编译
            pStatement = conn.prepareStatement(UPDATE_MSG_SEND_STATUS);
            pStatement.setLong(1, RETRY_STATE_SUCCESS);
            pStatement.setLong(2, Long.parseLong(fsMessage.getTransactionMessageId()));
            pStatement.executeUpdate();
        } catch (SQLException e) {
            log.error("ark-spring-boot-starter >> 事务消息更新发送状态失败!context={}", e, context);
            throw new MQProducerException("ark-spring-boot-starter >> 事务消息更新发送状态失败！");
        } finally {
            if (pStatement != null) {
                try {
                    pStatement.close();
                } catch (SQLException e) {
                    log.error("ark-spring-boot-starter >> 事务消息pStatement关闭失败！context={}", e, context);
                }
            }

            if (statement != null) {
                try {
                    statement.close();
                } catch (SQLException e) {
                    log.error("ark-spring-boot-starter >> 事务消息pStatement关闭失败！context={}", e, context);
                }
            }
        }
    }
}