/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.core.mq.base.producer;

import com.fshows.ark.spring.boot.starter.core.mq.base.FsMessage;

/**
 * fs mq生产者接口
 *
 * @author liluqing
 * @version IFshowsProducer.java, v 0.1 2021-08-19 16:59
 */
public interface IFshowsProducer {

    /**
     * 启动服务
     */
    void start();

    /**
     * 关闭服务
     */
    void shutdown();

    /**
     * 同步发送消息，只要不抛异常就表示成功
     *
     * @param fsMessage 要发送的消息对象
     * @return 发送结果，含消息Id, 消息主题
     */
    FsSendResult send(FsMessage fsMessage);

    /**
     * 发送消息，Oneway形式，服务器不应答，无法保证消息是否成功到达服务器
     *
     * @param fsMessage 要发送的消息
     */
    void sendOneway(FsMessage fsMessage);

    /**
     * 发送消息，异步Callback形式
     *
     * @param fsMessage 消息体
     * @param sendSuccessCallback 发送成功回调
     * @param fsSendErrorCallback 发送失败回调
     */
    void sendAsync(FsMessage fsMessage, FsSendSuccessCallback sendSuccessCallback, FsSendErrorCallback fsSendErrorCallback);

    /**
     * 发送消息，异步Callback形式
     *
     * @param fsMessage 消息体
     * @param sendSuccessCallback 发送成功回调
     */
    void sendAsync(FsMessage fsMessage, FsSendSuccessCallback sendSuccessCallback);

    /**
     * 发送消息，异步Callback形式
     *
     * @param fsMessage 消息体
     * @param fsSendErrorCallback 发送失败回调
     */
    void sendAsync(FsMessage fsMessage, FsSendErrorCallback fsSendErrorCallback);

    /**
     * 同步发送消息，只要不抛异常就表示成功
     *
     * @param context 消息上下文
     * @return 发送结果，含消息Id, 消息主题
     */
    FsSendResult send(FsMessageSendContext context);
}