/**
 * fshows.com
 * Copyright (C) 2013-2019 All Rights Reserved.
 */
package com.fshows.ark.spring.boot.starter.core.mq.base.producer;

import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.RocketSendMessageMethodModel;
import lombok.Data;

import java.lang.reflect.Method;
import java.util.Map;

/**
 * 生产者属性
 *
 * @author Liluqing
 * @version RocketConsumerProperties.java, v 0.1 2019-08-15 10:28
 */
@Data
public class FsProducerModel {

    /**
     * 生产者接口Class
     */
    private Class producerClass;

    /**
     * 生产者GID
     */
    private String groupId;

    /**
     * msg key前缀
     *  （消息的key都会默认添加该前缀）
     *
     * @return
     */
    private String msgKeyPrefix;

    /**
     * 生产者消费发送默认超时时间（单位：毫秒）
     *
     * @return
     */
    private String sendMsgTimeoutMillis;

    /**
     * mq nameSever地址
     */
    private String namesrvAddr;

    /**
     * 消息内容字符集编码
     */
    private String charsetName;

    /**
     * 授权key
     */
    private String accessKey;

    /**
     * 密钥
     */
    private String secretKey;

    /**
     * 发送消息数据元信息
     */
    private Map<Method, RocketSendMessageMethodModel> sendMessageMethodModelMap;
}