/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.transaction;

import com.fshows.ark.spring.boot.starter.core.mq.base.FsMessageConvert;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsMessageSendContext;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendResult;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.TransactionCommitCallback;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.TransactionMessageManage;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.transaction.DefaultTransactionSynchronization;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer.transaction.TransactionMessageDao;
import java.sql.Connection;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class DefaultTransactionMessageManageImpl
implements TransactionMessageManage {
    private static final Logger log = LoggerFactory.getLogger(DefaultTransactionMessageManageImpl.class);
    private DataSource dataSource;
    @Autowired
    private TransactionMessageDao transactionMessageDao;

    public DefaultTransactionMessageManageImpl(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public FsSendResult sendTransactionMsg(FsMessageSendContext context, TransactionCommitCallback transactionCommitCallback) {
        ConnectionHolder conHolder = (ConnectionHolder)TransactionSynchronizationManager.getResource((Object)this.dataSource);
        Connection conn = conHolder.getConnection();
        this.transactionMessageDao.insertTransactionMessage(conn, context);
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new DefaultTransactionSynchronization(context, transactionCommitCallback));
        return FsMessageConvert.buildSendResult(context.getFsMessage(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateMsgSendStatusToSuccess(FsMessageSendContext context) {
        Connection conn = null;
        try {
            conn = DataSourceUtils.getConnection((DataSource)this.dataSource);
            if (DataSourceUtils.isConnectionTransactional((Connection)conn, (DataSource)this.dataSource)) {
                this.transactionMessageDao.updateMsgSendStatusToSuccess(conn, context);
                conn.commit();
            }
        }
        catch (Exception e) {
            log.error("ark-spring-boot-starter >> \u66f4\u65b0\u672c\u5730\u6d88\u606f\u8868\u6d88\u606f\u53d1\u9001\u72b6\u6001\u66f4\u65b0\u5931\u8d25! message={}", (Object)e, (Object)context.getFsMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            DataSourceUtils.releaseConnection((Connection)conn, (DataSource)this.dataSource);
        }
        return true;
    }

    @Override
    public boolean isInTransaction() {
        if (!TransactionSynchronizationManager.isActualTransactionActive() || !TransactionSynchronizationManager.isSynchronizationActive()) {
            return false;
        }
        ConnectionHolder conHolder = (ConnectionHolder)TransactionSynchronizationManager.getResource((Object)this.dataSource);
        if (conHolder == null) {
            return false;
        }
        Connection conn = conHolder.getConnection();
        return conn != null;
    }
}

