/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ark.spring.boot.starter.core.sensitive.encrypt.strategy;

import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.symmetric.SM4;
import com.fshows.ark.spring.boot.starter.core.sensitive.encrypt.IFieldEncryptStrategy;
import com.fshows.ark.spring.boot.starter.core.sensitive.enums.AlgorithmTypeEnum;
import com.fshows.ark.spring.boot.starter.core.sensitive.model.SecretKeyModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class Sm4FieldEncryptStrategy
implements IFieldEncryptStrategy {
    private static final Logger log = LoggerFactory.getLogger(Sm4FieldEncryptStrategy.class);

    @Override
    public byte[] encrypt(byte[] plaintext, SecretKeyModel model) {
        SM4 sm4 = SmUtil.sm4((byte[])model.getPrivateKey());
        return sm4.encrypt(plaintext);
    }

    @Override
    public byte[] decrypt(byte[] ciphertext, SecretKeyModel model) {
        SM4 sm4 = SmUtil.sm4((byte[])model.getPrivateKey());
        return sm4.decrypt(ciphertext);
    }

    @Override
    public AlgorithmTypeEnum getAlgorithmTypeEnum() {
        return AlgorithmTypeEnum.SM4;
    }
}

