/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ark.spring.boot.starter.core.sensitive.encrypt;

import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.DigestAlgorithm;
import cn.hutool.crypto.digest.Digester;
import com.alibaba.fastjson.JSONArray;
import com.fshows.ark.spring.boot.starter.core.sensitive.encrypt.SecretKeyManage;
import com.fshows.ark.spring.boot.starter.core.sensitive.enums.AlgorithmTypeEnum;
import com.fshows.ark.spring.boot.starter.core.sensitive.model.SecretKeyModel;
import com.fshows.ark.spring.boot.starter.core.sensitive.model.SensitiveConfigModel;
import com.fshows.ark.spring.boot.starter.exception.DbSensitiveException;
import com.fshows.ark.spring.boot.starter.util.LogUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DefaultSecretKeyManage
implements SecretKeyManage {
    private static final Logger log = LoggerFactory.getLogger(DefaultSecretKeyManage.class);
    private final Map<String, SecretKeyModel> KEY_CACHE_MAP = new ConcurrentHashMap<String, SecretKeyModel>();
    @Value(value="${ark.sensitive.secrekey.config:}")
    private String sensitiveConfig;
    private volatile SecretKeyModel defaultSecretKey;

    @PostConstruct
    public void initMap() {
        if (StrUtil.isBlank((CharSequence)this.sensitiveConfig)) {
            LogUtil.error(log, "ark-spring-boot-starter >>  \u6570\u636e\u5e93\u654f\u611f\u5b57\u6bb5\u5bc6\u94a5\u914d\u7f6e\u4e3a\u7a7a >> \u8bf7\u68c0\u67e5\u2018ark.sensitive.secrekey.config\u2019\u914d\u7f6e");
            throw new DbSensitiveException("ark-spring-boot-starter >> \u6570\u636e\u5e93\u654f\u611f\u5b57\u6bb5\u5bc6\u94a5\u914d\u7f6e\u4e3a\u7a7a >> \u8bf7\u68c0\u67e5\u2018ark.sensitive.secrekey.config\u2019\u914d\u7f6e");
        }
        List configList = JSONArray.parseArray((String)this.sensitiveConfig, SensitiveConfigModel.class);
        for (SensitiveConfigModel config : configList) {
            AlgorithmTypeEnum algorithmType = AlgorithmTypeEnum.getByName(config.getAlgorithmType());
            if (algorithmType == null) {
                LogUtil.error(log, "ark-spring-boot-starter >>  \u6570\u636e\u5e93\u654f\u611f\u5b57\u6bb5\u52a0\u5bc6\u914d\u7f6e\u521d\u59cb\u5316\u5f02\u5e38 >> \u672a\u8bc6\u522b\u7684algorithmType,\u8bf7\u68c0\u67e5\u2018ark.sensitive.secrekey.config\u2019\u914d\u7f6e\u662f\u5426\u6b63\u786e >> {}", config.getAlgorithmType());
                throw new DbSensitiveException("ark-spring-boot-starter >> \u6570\u636e\u5e93\u654f\u611f\u5b57\u6bb5\u52a0\u5bc6\u914d\u7f6e\u521d\u59cb\u5316\u5f02\u5e38\uff01 >> \u672a\u8bc6\u522b\u7684algorithmType");
            }
            if (StrUtil.isBlank((CharSequence)config.getKeyId())) {
                LogUtil.error(log, "ark-spring-boot-starter >>  \u6570\u636e\u5e93\u654f\u611f\u5b57\u6bb5\u52a0\u5bc6\u914d\u7f6e\u521d\u59cb\u5316\u5f02\u5e38 >> keyId\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u2018ark.sensitive.secrekey.config\u2019\u914d\u7f6e\u662f\u5426\u6b63\u786e >> {}", config.getKeyId());
                throw new DbSensitiveException("ark-spring-boot-starter >> \u6570\u636e\u5e93\u654f\u611f\u5b57\u6bb5\u52a0\u5bc6\u914d\u7f6e\u521d\u59cb\u5316\u5f02\u5e38\uff01 >> keyId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            int keyId = Integer.parseInt(config.getKeyId());
            if (keyId < 0 || keyId > 65535) {
                LogUtil.error(log, "ark-spring-boot-starter >>  \u6570\u636e\u5e93\u654f\u611f\u5b57\u6bb5\u52a0\u5bc6\u914d\u7f6e\u521d\u59cb\u5316\u5f02\u5e38 >> \u65e0\u6548\u7684keyId,keyId\u7684\u53d6\u503c\u8303\u56f4\u4e3a\uff080-65535\u7684\u6570\u5b57\uff09,\u8bf7\u68c0\u67e5\u2018ark.sensitive.secrekey.config\u2019\u914d\u7f6e\u662f\u5426\u6b63\u786e >> {}", config.getKeyId());
                throw new DbSensitiveException("ark-spring-boot-starter >> \u6570\u636e\u5e93\u654f\u611f\u5b57\u6bb5\u52a0\u5bc6\u914d\u7f6e\u521d\u59cb\u5316\u5f02\u5e38\uff01 >> keyId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StrUtil.isBlank((CharSequence)config.getSeed())) {
                LogUtil.error(log, "ark-spring-boot-starter >>  \u6570\u636e\u5e93\u654f\u611f\u5b57\u6bb5\u52a0\u5bc6\u914d\u7f6e\u521d\u59cb\u5316\u5f02\u5e38 >> seed\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u2018ark.sensitive.secrekey.config\u2019\u914d\u7f6e\u662f\u5426\u6b63\u786e >> {}", config.getSeed());
                throw new DbSensitiveException("ark-spring-boot-starter >> \u6570\u636e\u5e93\u654f\u611f\u5b57\u6bb5\u52a0\u5bc6\u914d\u7f6e\u521d\u59cb\u5316\u5f02\u5e38\uff01 >> seed\u4e0d\u80fd\u4e3a\u7a7a");
            }
            SecretKeyModel keyModel = new SecretKeyModel();
            keyModel.setKeyId(keyId);
            keyModel.setAlgorithmType(algorithmType);
            Digester md5 = new Digester(DigestAlgorithm.MD5);
            String digestHex = md5.digestHex(config.getSeed());
            byte[] privateKey = md5.digest(digestHex + config.getSeed());
            keyModel.setPrivateKey(privateKey);
            String key = StrUtil.format((CharSequence)"{}_{}", (Object[])new Object[]{config.getKeyId(), algorithmType.getValue()});
            this.KEY_CACHE_MAP.put(key, keyModel);
            if (!StrUtil.equalsIgnoreCase((CharSequence)"true", (CharSequence)config.getIsDefault()) && configList.size() != 1) continue;
            this.defaultSecretKey = keyModel;
        }
    }

    @Override
    public SecretKeyModel getSecretKey(String keyId, AlgorithmTypeEnum algorithmType) {
        if (StrUtil.isBlank((CharSequence)this.sensitiveConfig)) {
            return null;
        }
        String key = StrUtil.format((CharSequence)"{}_{}", (Object[])new Object[]{keyId, algorithmType.getValue()});
        return this.KEY_CACHE_MAP.get(key);
    }

    @Override
    public SecretKeyModel getDefaultSecretKey() {
        return this.defaultSecretKey;
    }
}

