/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ark.spring.boot.starter.core.sensitive.encrypt;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import com.fshows.ark.spring.boot.starter.core.sensitive.encrypt.DefaultSecretKeyManage;
import com.fshows.ark.spring.boot.starter.core.sensitive.encrypt.FieldEncryptExecutor;
import com.fshows.ark.spring.boot.starter.core.sensitive.encrypt.FieldEncryptFactory;
import com.fshows.ark.spring.boot.starter.core.sensitive.encrypt.IFieldEncryptStrategy;
import com.fshows.ark.spring.boot.starter.core.sensitive.enums.AlgorithmTypeEnum;
import com.fshows.ark.spring.boot.starter.core.sensitive.model.SecretKeyModel;
import com.fshows.ark.spring.boot.starter.util.FsByteUtil;
import java.nio.charset.Charset;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultFieldEncryptExecutor
implements FieldEncryptExecutor {
    @Autowired
    private FieldEncryptFactory fieldEncryptFactory;
    @Autowired
    private DefaultSecretKeyManage defaultSecretKeyManage;

    @Override
    public String encrypt(String plaintext) {
        if (StrUtil.isBlank((CharSequence)plaintext)) {
            return plaintext;
        }
        if (!this.isPlaintext(plaintext)) {
            return plaintext;
        }
        SecretKeyModel secretKeyModel = this.defaultSecretKeyManage.getDefaultSecretKey();
        AlgorithmTypeEnum algorithmTypeEnum = secretKeyModel.getAlgorithmType();
        byte[] keyIdByte = FsByteUtil.splitBytes(secretKeyModel.getKeyId());
        byte[] algorithmTypeByte = FsByteUtil.splitBytes(algorithmTypeEnum.getValue());
        byte[] headBytes = new byte[]{keyIdByte[0], keyIdByte[1], algorithmTypeByte[0], algorithmTypeByte[1]};
        IFieldEncryptStrategy encryptStrategy = this.fieldEncryptFactory.getFieldEncryptStrategy(algorithmTypeEnum);
        byte[] cipherBytes = encryptStrategy.encrypt(StrUtil.bytes((CharSequence)plaintext, (Charset)CharsetUtil.CHARSET_UTF_8), secretKeyModel);
        byte[] reslutCipherBytes = FsByteUtil.mergeByteArrays(headBytes, cipherBytes);
        StringBuilder sb = new StringBuilder(1000);
        sb.append("$fb$");
        sb.append(Base64.encode((byte[])reslutCipherBytes));
        return sb.toString();
    }

    @Override
    public String decrypt(String ciphertext) {
        if (this.isPlaintext(ciphertext)) {
            return ciphertext;
        }
        List base64DataArray = StrUtil.split((CharSequence)ciphertext, (CharSequence)"$");
        if (base64DataArray == null || base64DataArray.size() < 2) {
            return null;
        }
        String base64Data = (String)base64DataArray.get(2);
        byte[] plain = Base64.decode((CharSequence)base64Data);
        if (plain == null || plain.length <= 4) {
            return null;
        }
        int keyId = FsByteUtil.mergeBytes(plain[1], plain[0]);
        int algorithmType = FsByteUtil.mergeBytes(plain[3], plain[2]);
        AlgorithmTypeEnum algorithmTypeEnum = AlgorithmTypeEnum.getByValue(algorithmType);
        SecretKeyModel secretKeyModel = this.defaultSecretKeyManage.getSecretKey(Integer.toString(keyId), algorithmTypeEnum);
        IFieldEncryptStrategy encryptStrategy = this.fieldEncryptFactory.getFieldEncryptStrategy(algorithmTypeEnum);
        byte[] body = new byte[plain.length - 4];
        System.arraycopy(plain, 4, body, 0, body.length);
        byte[] plainData = encryptStrategy.decrypt(body, secretKeyModel);
        return StrUtil.str((byte[])plainData, (Charset)CharsetUtil.CHARSET_UTF_8);
    }

    private boolean isPlaintext(String plaintext) {
        return !StrUtil.startWith((CharSequence)plaintext, (CharSequence)"$fb$");
    }
}

