/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ark.spring.boot.starter.core.sensitive;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.RSA;
import cn.hutool.crypto.digest.DigestAlgorithm;
import cn.hutool.crypto.digest.Digester;
import cn.hutool.crypto.symmetric.SM4;
import cn.hutool.crypto.symmetric.SymmetricAlgorithm;
import cn.hutool.crypto.symmetric.SymmetricCrypto;
import com.fshows.ark.spring.boot.starter.core.sensitive.enums.AlgorithmTypeEnum;
import java.io.UnsupportedEncodingException;

public class Sm4EncryptionExample {
    public static void main(String[] args) throws UnsupportedEncodingException {
        String content = "\u6d59\u6c5f\u7701\u676d\u5dde\u5e02\u4f59\u676d\u533a\u672a\u6765\u79d1\u6280\u57ce\u4e07\u8fbe\u5e7f\u573aA\u5ea727\u697c1909\u4e0a\u8bfe\u65f6\u5730\u65b9\u6d41\u53e3\u6c34\u7684\u9632\u5b88\u5bf9\u65b9\u8003\u8bd5\u7684\u5206\u6570\u8003\u7684\u5206\u6570";
        byte[] contentByte = content.getBytes(CharsetUtil.CHARSET_UTF_8);
        byte[] key = SecureUtil.generateKey((String)SymmetricAlgorithm.AES.getValue()).getEncoded();
        SymmetricCrypto aes = new SymmetricCrypto(SymmetricAlgorithm.AES, key);
        byte[] encrypt = aes.encrypt(contentByte);
        System.out.println("\u660e\u6587\uff1a" + content);
        System.out.println("\u957f\u5ea6\uff1a" + content.length());
        System.out.println("AES-Base64\u5bc6\u6587\uff1a" + Base64.encode((byte[])encrypt));
        System.out.println("\u957f\u5ea6\uff1a" + Base64.encode((byte[])encrypt).length());
        RSA rsa = new RSA();
        String encryptedData = rsa.encryptBase64(contentByte, KeyType.PublicKey);
        System.out.println("RSA-Base64\u5bc6\u6587\uff1a" + encryptedData);
        System.out.println("\u957f\u5ea6\uff1a" + encryptedData.length());
        String seed = "123456";
        Digester md5 = new Digester(DigestAlgorithm.MD5);
        String digestHex = md5.digestHex(seed);
        byte[] mkey = md5.digest(digestHex + seed);
        SM4 sm4 = SmUtil.sm4((byte[])mkey);
        byte[] sm4Encrypt = sm4.encrypt(contentByte);
        System.out.println("SM4-Base64\u5bc6\u6587\uff1a" + Base64.encode((byte[])sm4Encrypt));
        System.out.println("\u957f\u5ea6\uff1a" + Base64.encode((byte[])sm4Encrypt).length());
        byte[] sm4Decrypt = sm4.decrypt(sm4Encrypt);
        System.out.println("\u89e3\u5bc6\uff1a" + new String(sm4Decrypt));
        AlgorithmTypeEnum algorithmTypeEnum = AlgorithmTypeEnum.SM4;
        Integer keyId = 1;
        Integer AlgorithmType = algorithmTypeEnum.getValue();
        int intValue = 65535;
        int low16Bits = intValue & 0xFFFF;
        byte lowByte = (byte)(low16Bits & 0xFF);
        byte highByte = (byte)(low16Bits >> 8 & 0xFF);
        System.out.println("intValue: " + intValue);
        System.out.println("Low byte: " + lowByte);
        System.out.println("High byte: " + highByte);
        System.out.println("txt (\u4e8c\u8fdb\u5236) :     " + Sm4EncryptionExample.intToBinaryString32Bit(intValue));
        System.out.println("High byte(\u4e8c\u8fdb\u5236):                 " + Sm4EncryptionExample.byteToBinaryString(highByte));
        System.out.println("Low byte(\u4e8c\u8fdb\u5236) :                         " + Sm4EncryptionExample.byteToBinaryString(lowByte));
        int newIntValue = Sm4EncryptionExample.mergeBytes(highByte, lowByte);
        System.out.println("newIntValue: " + newIntValue);
        System.out.println("newIntValue (\u4e8c\u8fdb\u5236) : " + Sm4EncryptionExample.intToBinaryString32Bit(newIntValue));
        System.out.println("High byte(\u4e8c\u8fdb\u5236):                     " + Sm4EncryptionExample.byteToBinaryString(highByte));
        System.out.println("Low byte(\u4e8c\u8fdb\u5236) :                             " + Sm4EncryptionExample.byteToBinaryString(lowByte));
    }

    public static String intToBinaryString32Bit(int number) {
        String binaryString = Integer.toBinaryString(number);
        return String.format("%32s", binaryString).replace(' ', '0');
    }

    public static String byteToBinaryString(byte number) {
        StringBuilder binaryString = new StringBuilder(8);
        for (int i = 7; i >= 0; --i) {
            binaryString.append(number >> i & 1);
        }
        return binaryString.toString();
    }

    public static int mergeBytes(byte high, byte low) {
        int highInt = high & 0xFF;
        int lowInt = low & 0xFF;
        return highInt << 8 | lowInt;
    }
}

