/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ark.spring.boot.starter.core.mq.rocketmq.producer;

import com.aliyun.openservices.ons.api.OnExceptionContext;
import com.aliyun.openservices.ons.api.SendCallback;
import com.aliyun.openservices.ons.api.SendResult;
import com.fshows.ark.spring.boot.starter.core.mq.base.FsMessageConvert;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsMessageSendContext;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendErrorCallback;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendExceptionHolder;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendResult;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendSuccessCallback;
import com.fshows.ark.spring.boot.starter.core.mq.rocketmq.interceptor.ProducerInterceptorActuator;

public class AliyunSendCallBackWrap
implements SendCallback {
    private FsSendSuccessCallback sendSuccessCallback;
    private FsSendErrorCallback fsSendErrorCallback;
    private FsMessageSendContext context;
    private ProducerInterceptorActuator producerInterceptorActuator;

    public AliyunSendCallBackWrap(FsSendSuccessCallback sendSuccessCallback, FsSendErrorCallback fsSendErrorCallback) {
        this.sendSuccessCallback = sendSuccessCallback;
        this.fsSendErrorCallback = fsSendErrorCallback;
    }

    public AliyunSendCallBackWrap(FsSendSuccessCallback sendSuccessCallback, FsSendErrorCallback fsSendErrorCallback, FsMessageSendContext context, ProducerInterceptorActuator producerInterceptorActuator) {
        this.sendSuccessCallback = sendSuccessCallback;
        this.fsSendErrorCallback = fsSendErrorCallback;
        this.producerInterceptorActuator = producerInterceptorActuator;
        this.context = context;
    }

    public void onSuccess(SendResult sendResult) {
        if (this.sendSuccessCallback != null) {
            FsSendResult result = FsMessageConvert.convertFsSendResult(sendResult);
            if (this.producerInterceptorActuator != null) {
                this.producerInterceptorActuator.doAfterSend(this.context, result);
            }
            this.sendSuccessCallback.onSuccess(result, this.context);
        }
    }

    public void onException(OnExceptionContext onExceptionContext) {
        if (this.fsSendErrorCallback != null) {
            FsSendResult result = FsMessageConvert.convertFsSendResult(onExceptionContext);
            if (this.producerInterceptorActuator != null) {
                this.producerInterceptorActuator.doAfterSend(this.context, result);
            }
            FsSendExceptionHolder exceptionHolder = FsMessageConvert.convertFsSendExceptionContext(onExceptionContext);
            this.fsSendErrorCallback.onException(exceptionHolder, this.context);
        }
    }
}

