/*
 * Decompiled with CFR 0.152.
 */
package com.shouzhan.upload;

import android.content.Context;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.shouzhan.clientcommon.CommonUtils;
import com.shouzhan.clientcommon.FileUtils;
import com.shouzhan.clientcommon.InternalUtils;
import com.shouzhan.clientcommon.WeakReferenceHandler;
import com.shouzhan.network.BaseResult;
import com.shouzhan.network.HttpCallback;
import com.shouzhan.network.HttpTask;
import com.shouzhan.network.TaskDispatcher;
import com.shouzhan.upload.Compress;
import com.shouzhan.upload.CompressBuilder;
import com.shouzhan.upload.FileUploadCallback;
import com.shouzhan.upload.FileUploadMessageObj;
import com.shouzhan.upload.GetPicUrlRequest;
import com.shouzhan.upload.GetPicUrlResult;
import com.shouzhan.upload.OssService;
import com.shouzhan.upload.OssUploadCallback;
import java.io.File;

public class FileUploadTask
implements Runnable,
WeakReferenceHandler.IHandlerCallback,
HttpCallback,
OssUploadCallback {
    private static final String TAG = FileUploadTask.class.getSimpleName();
    public static final String INVALID_ACCESS_KEY_ID = "InvalidAccessKeyId";
    public static final String TEST_BACKET_NAME = "services-test-images";
    public static final String BETA_BACKET_NAME = "services-beta-images";
    public static final String SIGN_BACKET_NAME = "services-images";
    private Context context;
    private String filePath;
    private FileUploadCallback callback;
    private int taskId;
    private CompressBuilder builder;
    private String key;
    private File tempFile;
    private TaskDispatcher taskDispatcher;
    private WeakReferenceHandler handler = new WeakReferenceHandler(Looper.getMainLooper(), this);
    private static final int MSG_UPLOAD_START = 1;
    private static final int MSG_UPLOAD_PROGRESS = 2;
    private static final int MSG_UPLOAD_SUCCESS = 3;
    private static final int MSG_UPLOAD_FAIL = 4;

    @Override
    public void handleMessage(Message msg) {
        FileUploadMessageObj obj = (FileUploadMessageObj)msg.obj;
        if (obj == null || this.callback == null) {
            Log.d((String)TAG, (String)"obj == null or callback == null");
            return;
        }
        switch (msg.what) {
            case 1: {
                this.callback.onUploadStart(obj.getId());
                break;
            }
            case 2: {
                this.callback.onUploadProgress(obj.getProgress(), obj.getTotal(), obj.getId());
                break;
            }
            case 3: {
                this.callback.onUploadSuccess(obj.getFileUrl(), FileUploadTask.getBacketName(), this.key, obj.getId());
                break;
            }
            case 4: {
                this.callback.onUploadFail(obj.getId());
                break;
            }
        }
    }

    public FileUploadTask(Context context, String filePath, FileUploadCallback callback, int id2) {
        this.taskDispatcher = TaskDispatcher.getInstance();
        this.context = context;
        this.filePath = filePath;
        this.callback = callback;
        this.taskId = id2;
    }

    public void setBuilder(CompressBuilder builder) {
        this.builder = builder;
    }

    @Override
    public void run() {
        File file = new File(this.filePath);
        if (!file.exists()) {
            Log.d((String)TAG, (String)"file is not exist!!!");
            return;
        }
        this.sendUploadStart();
        if (this.builder == null) {
            this.builder = new CompressBuilder(this.context);
        }
        try {
            this.tempFile = this.builder.isPic() ? new Compress(this.context).setBuilder(this.builder).compressToFile(file) : file;
            if (this.tempFile == null || !this.tempFile.exists()) {
                return;
            }
            String ossUploadDir = this.builder.getUploadDir();
            this.key = CommonUtils.isStringInvalid(ossUploadDir) ? FileUtils.genKeyForUrl(this.tempFile) : ossUploadDir + FileUtils.genKeyForUrl(this.tempFile);
            OssService ossService = new OssService(this.context);
            ossService.setOSSUploadCallback(this);
            ossService.setBucketName(FileUploadTask.getBacketName());
            ossService.uploadImage(this.key, this.tempFile.getAbsolutePath(), this.taskId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onProgress(long progress, long total, int id2) {
        this.sendUploadProgress(progress, total);
    }

    @Override
    public void onSuccess(String backetName, String key, int id2) {
        this.deleteTempFile();
        this.getFinalUrl();
    }

    @Override
    public void onFailure(String errorCode, int id2) {
        Log.i((String)TAG, (String)("onFailure: " + errorCode));
        if (!INVALID_ACCESS_KEY_ID.equals(errorCode)) {
            this.sendUploadFail();
        }
    }

    public void deleteTempFile() {
        if (this.tempFile != null && this.tempFile.exists()) {
            this.tempFile.delete();
        }
    }

    private void getFinalUrl() {
        GetPicUrlRequest request = new GetPicUrlRequest(this.context, new GetPicUrlResult(this.context), FileUploadTask.getBacketName(), this.key);
        HttpTask task = new HttpTask(this.context, request, this, this.taskId);
        this.taskDispatcher.dispatch(task);
    }

    @Override
    public void onRequestSuccess(int id2, BaseResult result) {
        if (this.taskId == id2) {
            GetPicUrlResult r = (GetPicUrlResult)result;
            String fileUrl = r.getPicUrl();
            if (CommonUtils.isStringInvalid(fileUrl)) {
                return;
            }
            this.sendUploadSuccess(fileUrl);
        }
    }

    @Override
    public void onRequestFail(int id2, BaseResult result) {
        this.sendUploadFail();
    }

    @Override
    public void onRequestCancel(int id2) {
        this.sendUploadCancel();
    }

    private void sendUploadStart() {
        Message message = this.handler.obtainMessage();
        message.what = 1;
        FileUploadMessageObj obj = new FileUploadMessageObj();
        obj.setId(this.taskId);
        message.obj = obj;
        this.handler.sendMessage(message);
    }

    private void sendUploadProgress(long progress, long total) {
        Message message = this.handler.obtainMessage();
        message.what = 2;
        FileUploadMessageObj obj = new FileUploadMessageObj();
        obj.setId(this.taskId);
        obj.setProgress(progress);
        obj.setTotal(total);
        message.obj = obj;
        this.handler.sendMessage(message);
    }

    private void sendUploadSuccess(String fileUrl) {
        Message message = this.handler.obtainMessage();
        message.what = 3;
        FileUploadMessageObj obj = new FileUploadMessageObj();
        obj.setId(this.taskId);
        obj.setFileUrl(fileUrl);
        message.obj = obj;
        this.handler.sendMessage(message);
    }

    private void sendUploadFail() {
        Message message = this.handler.obtainMessage();
        message.what = 4;
        FileUploadMessageObj obj = new FileUploadMessageObj();
        obj.setId(this.taskId);
        message.obj = obj;
        this.handler.sendMessage(message);
    }

    private void sendUploadCancel() {
        Log.i((String)TAG, (String)"sendUploadCancel");
    }

    public static String getBacketName() {
        switch (InternalUtils.getServer()) {
            case 0: {
                return TEST_BACKET_NAME;
            }
            case 1: {
                return BETA_BACKET_NAME;
            }
            case 2: {
                return SIGN_BACKET_NAME;
            }
        }
        return "";
    }
}

