/*
 * Decompiled with CFR 0.152.
 */
package com.shouzhan.network;

import android.content.Context;
import com.shouzhan.network.BaseRequest;
import com.shouzhan.network.HttpCallback;
import com.shouzhan.network.TaskDispatcher;

public class HttpTask
implements Runnable {
    private static final String TAG = "HttpTask";
    private Context context;
    protected BaseRequest request;
    protected HttpCallback callback;
    protected int id;
    protected TaskDispatcher dispatcher;
    protected Boolean requestResult;
    private Runnable r = new Runnable(){

        @Override
        public void run() {
            if (HttpTask.this.callback == null) {
                return;
            }
            if (HttpTask.this.isAlive()) {
                if (HttpTask.this.requestResult.booleanValue()) {
                    HttpTask.this.callback.onRequestSuccess(HttpTask.this.id, HttpTask.this.request.result);
                } else {
                    HttpTask.this.callback.onRequestFail(HttpTask.this.id, HttpTask.this.request.result);
                }
            } else {
                HttpTask.this.callback.onRequestCancel(HttpTask.this.id);
            }
        }
    };

    public HttpTask(Context context, BaseRequest request, int id2) {
        this(context, request, null, id2);
    }

    public HttpTask(Context context, BaseRequest request, HttpCallback callback, int id2) {
        this.context = context;
        this.request = request;
        this.callback = callback == null ? new HttpCallback.SimpleCallback() : callback;
        this.id = id2;
    }

    public BaseRequest getRequest() {
        return this.request;
    }

    public void setDispatcher(TaskDispatcher dispatcher) {
        this.dispatcher = dispatcher;
        this.request.setDispatcher(dispatcher);
    }

    public void setCallback(HttpCallback callback) {
        if (callback == null) {
            throw new NullPointerException("callback should not be null !!!");
        }
        this.callback = callback;
    }

    public void cancel() {
        this.request.cancel();
    }

    public boolean isAlive() {
        return this.request.isAlive();
    }

    @Override
    public void run() {
        this.requestResult = this.request.send();
        this.publishResult();
        this.cleanRef();
    }

    private void cleanRef() {
        this.dispatcher.remove(this.id);
    }

    private void publishResult() {
        TaskDispatcher.HANDLER.post(this.r);
    }
}

