/*
 * Decompiled with CFR 0.152.
 */
package com.shouzhan.log;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.os.Environment;
import android.util.Log;
import com.shouzhan.log.FormatDebug;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

public class LogUtils {
    private static final String TAG = FormatDebug.closelyCallOuterClassName();
    private static final String LOG = "log";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeStackTrace(Context context, File logFile, String deviceInfo, Throwable ex) {
        if (!logFile.exists()) {
            try {
                logFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        if (!logFile.exists() || !logFile.canWrite()) {
            return false;
        }
        FileOutputStream os = null;
        OutputStreamWriter ow = null;
        BufferedWriter writer = null;
        try {
            os = new FileOutputStream(logFile);
            ow = new OutputStreamWriter((OutputStream)os, "utf-8");
            writer = new BufferedWriter(ow);
            writer.write("===========printStackTrace()============\n");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            ex.printStackTrace(pw);
            writer.write(sw.getBuffer().toString());
            writer.flush();
            writer.write("\n\n===========next============\n");
            writer.flush();
            writer.write(ex.getMessage() + "\n");
            writer.flush();
            StackTraceElement[] elements = ex.getStackTrace();
            if (null != elements) {
                for (StackTraceElement e : elements) {
                    writer.write(e.toString() + '\n');
                }
                writer.flush();
            }
            writer.write("Cause by " + ex.getCause() + "\n");
            writer.flush();
            writer.write("\n\n===========device info============\n");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINA);
            writer.write("Local time: " + df.format(Calendar.getInstance().getTime()) + "\n");
            writer.write("Fubei Host time: " + df.format(System.currentTimeMillis()) + "\n");
            writer.flush();
            writer.write(deviceInfo);
            writer.flush();
        }
        catch (IOException io) {
            io.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (null != writer) {
                    writer.close();
                }
                if (null != ow) {
                    ow.close();
                }
                if (null != os) {
                    os.close();
                }
                logFile.setReadable(true, false);
            }
            catch (IOException ignore) {
                ignore.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public static String getDeviceInfo(Context context) {
        PackageInfo pkInfo;
        StringBuilder builder = new StringBuilder();
        int level = Build.VERSION.SDK_INT;
        builder.append("Build.VERSION.RELEASE: " + Build.VERSION.RELEASE + "\n");
        builder.append("Build.VERSION.SDK_INT: " + Build.VERSION.SDK_INT + "\n");
        if (level < 21) {
            builder.append("Build.CPU_ABI: " + Build.CPU_ABI + "\n");
            builder.append("Build.CPU_ABI2: " + Build.CPU_ABI2 + "\n");
        }
        builder.append("Build.BOARD: " + Build.BOARD + "\n");
        builder.append("Build.PRODUCT: " + Build.PRODUCT + "\n");
        builder.append("Build.MODEL: " + Build.MODEL + "\n");
        builder.append("Build.ID: " + Build.ID + "\n");
        builder.append("Build.HARDWARE: " + Build.HARDWARE + "\n");
        if (null == context.getPackageManager()) {
            return builder.toString();
        }
        if (null == context.getPackageName()) {
            return builder.toString();
        }
        try {
            pkInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            return builder.toString();
        }
        if (null != pkInfo) {
            builder.append("packageName: " + context.getPackageName() + "\n");
            builder.append("versionCode: " + pkInfo.versionCode + "\n");
            builder.append("versionName: " + pkInfo.versionName + "\n");
        }
        return builder.toString();
    }

    public static File[] getLogFiles(Context context) {
        String logWritePath = LogUtils.logWriteDir(context);
        if (null == logWritePath) {
            Log.w((String)TAG, (String)"getLogFiles, logWritePath: null");
            return null;
        }
        File file = new File(logWritePath);
        if (!file.exists()) {
            return null;
        }
        return file.listFiles();
    }

    public static String logWriteDir(Context context) {
        String dir = Build.VERSION.SDK_INT < 19 ? LogUtils.innerSdcardDirectory(context) : LogUtils.sdcardAndroidDataDirectory(context);
        if (null == dir) {
            dir = LogUtils.appDataDirectory(context);
        }
        if (null != dir) {
            File f = new File(dir);
            f.setReadable(true, false);
            f.setExecutable(true, false);
            Object var2_2 = null;
        }
        return dir;
    }

    private static String sdcardAndroidDataDirectory(Context context) {
        if (!Environment.isExternalStorageEmulated()) {
            return null;
        }
        File cacheFile = context.getExternalCacheDir();
        if (null == cacheFile || null == cacheFile.getParentFile()) {
            return null;
        }
        File dataFile = cacheFile.getParentFile();
        File f = new File(dataFile.getAbsolutePath(), LOG);
        if (!f.exists() && !f.mkdirs()) {
            return null;
        }
        if (!f.isDirectory() || !f.canWrite()) {
            return null;
        }
        return f.getAbsolutePath();
    }

    private static String innerSdcardDirectory(Context context) {
        String dir = Environment.getExternalStorageDirectory().getAbsolutePath();
        File pkFile = new File(dir);
        if (!pkFile.exists() && !pkFile.mkdirs()) {
            return null;
        }
        if (!pkFile.isDirectory() || !pkFile.canWrite()) {
            return null;
        }
        File f = new File(dir = dir + File.separator + context.getPackageName(), LOG);
        if (!f.exists() && !f.mkdirs()) {
            return null;
        }
        if (!f.isDirectory() || !f.canWrite()) {
            return null;
        }
        return f.getAbsolutePath();
    }

    private static String appDataDirectory(Context context) {
        File dataFile = context.getCacheDir().getParentFile();
        File f = new File(dataFile.getAbsolutePath(), LOG);
        if (!f.exists() && !f.mkdirs()) {
            return null;
        }
        if (!f.isDirectory() || !f.canWrite()) {
            return null;
        }
        return f.getAbsolutePath();
    }

    public static String logFileName(Context context) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss", Locale.CHINA);
        String time = df.format(System.currentTimeMillis());
        return "fubeilog" + time + ".txt";
    }

    public static String logFileName(Context context, String name) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss", Locale.CHINA);
        String time = df.format(System.currentTimeMillis());
        return name + time + ".txt";
    }
}

