/*
 * Decompiled with CFR 0.152.
 */
package com.shouzhan.log;

import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;

public class FormatDebug {
    private static final int LOG_MAX = 3000;
    private final String TAG;
    private static boolean mIsDebugGlobal = false;
    private boolean mIsDebugLocal = true;
    private static final IWriter mDefaultWriter = new IWriter(){

        @Override
        public void write(String tag, String log) {
            Log.d((String)tag, (String)log);
        }
    };

    public FormatDebug() {
        this.TAG = FormatDebug.closelyCallOuterClassName();
    }

    public FormatDebug(String tag) {
        this.TAG = tag;
    }

    public <T> FormatDebug(Class<T> clazz) {
        this.TAG = clazz.getSimpleName();
    }

    public FormatDebug(Object thiz) {
        this.TAG = thiz.getClass().getSimpleName();
    }

    public static String closelyCallOuterClassName() {
        StackTraceElement element = FormatDebug.closelyCallStackTraceElement();
        String className = element.getClassName();
        int start = className.lastIndexOf(46);
        int end = className.indexOf(36);
        start = -1 == start ? 0 : ++start;
        if (-1 == end) {
            end = className.length();
        }
        return className.substring(start, end);
    }

    private static StackTraceElement closelyCallStackTraceElement() {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        int self = 0;
        StackTraceElement e = null;
        for (int i = 0; i < elements.length; ++i) {
            e = elements[i];
            if (TextUtils.equals((CharSequence)FormatDebug.class.getName(), (CharSequence)e.getClassName())) {
                ++self;
                continue;
            }
            if (self > 0) break;
        }
        return e;
    }

    public void enableGlobalDebug(boolean enable) {
        mIsDebugGlobal = enable;
    }

    public void enableLocalDebug(boolean enable) {
        this.mIsDebugLocal = enable;
    }

    public void debug(String log) {
        this.debug(this.TAG, log, mDefaultWriter, false);
    }

    public void debug2(String log) {
        this.debug(this.TAG, log, mDefaultWriter, true);
    }

    public void debug3(String log, Object ... args) {
        this.debug(this.TAG, String.format(log, args), mDefaultWriter, false);
    }

    public void debug(String tag, String log) {
        this.debug(tag, log, mDefaultWriter, false);
    }

    public void debug(String tag, String log, IWriter writer, boolean prefixLn) {
        int len;
        if (!mIsDebugGlobal) {
            return;
        }
        if (!this.mIsDebugLocal) {
            return;
        }
        if (prefixLn) {
            StackTraceElement e = FormatDebug.closelyCallStackTraceElement();
            log = e.getMethodName() + "()<" + e.getLineNumber() + ">  " + log;
        }
        if ((len = log.length()) < 3001) {
            writer.write(tag, log);
            return;
        }
        writer.write(tag, "max length ==begin==");
        int line = 0;
        int start = 0;
        String szline = null;
        start = 0;
        while (start + 3000 < len) {
            szline = "line[" + line + "]: ";
            writer.write(tag, szline + log.substring(start, start + 3000));
            start += 3000;
            ++line;
        }
        if (start < len) {
            szline = "line[" + line + "]: ";
            writer.write(tag, szline + log.substring(start, len));
        }
        writer.write(tag, "max length ==end==");
    }

    public void debug2file(String content) {
        if (mIsDebugGlobal) {
            FormatDebug.debug2file("/sdcard/log1.txt", this.TAG, content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void debug2file(String path, String tag, String content) {
        File f = new File(path);
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileOutputStream os = null;
        FilterOutputStream buf = null;
        try {
            os = new FileOutputStream(path, true);
            buf = new BufferedOutputStream(os);
            buf.write(String.format("%s   %s", tag, content).getBytes());
            ((BufferedOutputStream)buf).write(10);
            ((BufferedOutputStream)buf).flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != buf) {
                    buf.close();
                    buf = null;
                }
                if (null != os) {
                    os.close();
                    os = null;
                }
            }
            catch (IOException ie) {
                ie.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveThrowable2File(String path, Throwable thr) {
        File f = new File(path);
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileOutputStream os = null;
        FilterOutputStream buf = null;
        try {
            StackTraceElement[] elements;
            os = new FileOutputStream(path, true);
            buf = new BufferedOutputStream(os);
            if (null != thr.getMessage()) {
                buf.write(thr.getMessage().getBytes());
            } else {
                buf.write("error message null".getBytes());
            }
            ((BufferedOutputStream)buf).write(10);
            ((BufferedOutputStream)buf).flush();
            for (StackTraceElement e : elements = thr.getStackTrace()) {
                buf.write(e.toString().getBytes());
                ((BufferedOutputStream)buf).write(10);
                ((BufferedOutputStream)buf).flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != buf) {
                    buf.close();
                    buf = null;
                }
                if (null != os) {
                    os.close();
                    os = null;
                }
            }
            catch (IOException ie) {
                ie.printStackTrace();
            }
        }
    }

    static interface IWriter {
        public void write(String var1, String var2);
    }
}

