/*
 * Decompiled with CFR 0.152.
 */
package com.shouzhan.download;

import android.content.Context;
import com.shouzhan.download.DownloadCallback;
import com.shouzhan.download.DownloadDispatcher;
import com.shouzhan.download.DownloadTask;

public class Downloader {
    private static final String TAG = "Downloader";
    private static Downloader INSTANCE = null;
    private Context context;
    private DownloadDispatcher dispatcher;

    private Downloader(Context context) {
        this.context = context;
        this.dispatcher = DownloadDispatcher.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Downloader getInstance(Context context) {
        if (INSTANCE != null) return INSTANCE;
        Class<Downloader> clazz = Downloader.class;
        synchronized (Downloader.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new Downloader(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public void download(String url) {
        this.download(url, null);
    }

    public void download(String url, DownloadCallback callback) {
        this.download(url, null, callback);
    }

    public void download(String url, String md5, DownloadCallback callback) {
        this.download(url, md5, callback, 0L);
    }

    public void download(String url, String md5, DownloadCallback callback, long totalSize) {
        DownloadTask tsk = new DownloadTask(this.context, url, md5, callback, totalSize);
        tsk.setDispatcher(this.dispatcher);
        this.dispatcher.dispatch(tsk);
    }

    public void cancel(String url) {
        DownloadTask tsk = this.dispatcher.getTask(url);
        if (tsk == null) {
            return;
        }
        if (this.dispatcher.remove(tsk) == 0) {
            return;
        }
        tsk.cancel();
    }

    public void delete(String url) {
        DownloadTask tsk = this.dispatcher.getTask(url);
        if (tsk == null) {
            return;
        }
        if (this.dispatcher.delete(tsk) == 0) {
            return;
        }
        tsk.delete();
    }

    public void close() {
        this.dispatcher.shutdown();
        INSTANCE = null;
    }
}

