/*
 * Decompiled with CFR 0.152.
 */
package com.shouzhan.crash.compat;

import android.content.Intent;
import android.os.IBinder;
import android.os.Message;
import com.shouzhan.crash.compat.IActivityKiller;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ActivityKillerV15_V20
implements IActivityKiller {
    @Override
    public void finishLaunchActivity(Message message) {
        try {
            Object activityClientRecord = message.obj;
            Field tokenField = activityClientRecord.getClass().getDeclaredField("token");
            tokenField.setAccessible(true);
            IBinder binder = (IBinder)tokenField.get(activityClientRecord);
            this.finish(binder);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void finishResumeActivity(Message message) {
        try {
            this.finish((IBinder)message.obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void finishPauseActivity(Message message) {
        try {
            this.finish((IBinder)message.obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void finishStopActivity(Message message) {
        try {
            this.finish((IBinder)message.obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void finish(IBinder binder) throws Exception {
        Class<?> activityManagerNativeClass = Class.forName("android.app.ActivityManagerNative");
        Method getDefaultMethod = activityManagerNativeClass.getDeclaredMethod("getDefault", new Class[0]);
        Object activityManager = getDefaultMethod.invoke(null, new Object[0]);
        Method finishActivityMethod = activityManager.getClass().getDeclaredMethod("finishActivity", IBinder.class, Integer.TYPE, Intent.class);
        finishActivityMethod.invoke(activityManager, binder, 0, null);
    }
}

