/*
 * Decompiled with CFR 0.152.
 */
package com.shouzhan.crash;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.shouzhan.crash.AbstractExceptionHandler;
import com.shouzhan.crash.compat.ActivityKillerV15_V20;
import com.shouzhan.crash.compat.ActivityKillerV21_V23;
import com.shouzhan.crash.compat.ActivityKillerV24_V25;
import com.shouzhan.crash.compat.ActivityKillerV26;
import com.shouzhan.crash.compat.ActivityKillerV28;
import com.shouzhan.crash.compat.IActivityKiller;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import me.weishu.reflection.Reflection;

public final class Cockroach {
    private static IActivityKiller mActivityKiller;
    private static AbstractExceptionHandler mAbstractExceptionHandler;
    private static volatile Cockroach mInstance;
    private static boolean mInstalled;
    private static boolean mIsSafeMode;
    private static final int LAUNCH_ACTIVITY = 100;
    private static final int PAUSE_ACTIVITY = 101;
    private static final int PAUSE_ACTIVITY_FINISHING = 102;
    private static final int STOP_ACTIVITY_HIDE = 104;
    private static final int RESUME_ACTIVITY = 107;
    private static final int DESTROY_ACTIVITY = 109;
    private static List<WeakReference<Activity>> sActivitysWRef;
    private Application.ActivityLifecycleCallbacks mActivityLifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){

        public void onActivityCreated(Activity activity, Bundle bundle) {
            sActivitysWRef.add(new WeakReference<Activity>(activity));
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        public void onActivityDestroyed(Activity activity) {
            for (WeakReference reference : sActivitysWRef) {
                Activity act = (Activity)reference.get();
                if (act != activity) continue;
                sActivitysWRef.remove(reference);
                return;
            }
        }
    };

    private Cockroach(Application context) {
        context.registerActivityLifecycleCallbacks(this.mActivityLifecycleCallbacks);
        Cockroach.install((Context)context, new AbstractExceptionHandler((Context)context){

            @Override
            protected void onUncaughtExceptionHappened(Thread thread, Throwable throwable) {
                Log.e((String)"nUncaught", (String)throwable.getMessage());
            }

            @Override
            protected void onBandageExceptionHappened(Throwable throwable) {
                Log.e((String)"onBandage", (String)throwable.getMessage());
            }

            @Override
            protected void onEnterSafeMode() {
                Log.e((String)"onEnterSafeMode", (String)"onUncaughtExceptionHappened");
            }

            @Override
            protected void onMayBeBlackScreen(Throwable e) {
                Log.e((String)"onMayBeBlack", (String)e.getMessage());
            }
        });
    }

    public static synchronized Cockroach getInstance(Application context) {
        if (null == mInstance) {
            mInstance = new Cockroach(context);
        }
        return mInstance;
    }

    public static void install(Context ctx, AbstractExceptionHandler abstractExceptionHandler) {
        if (mInstalled) {
            return;
        }
        try {
            Reflection.unseal((Context)ctx);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        mInstalled = true;
        mAbstractExceptionHandler = abstractExceptionHandler;
        Cockroach.initActivityKiller();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                if (mAbstractExceptionHandler != null) {
                    mAbstractExceptionHandler.uncaughtExceptionHappened(t, e);
                }
                if (t == Looper.getMainLooper().getThread()) {
                    Cockroach.isChoreographerException(e);
                    Cockroach.safeMode();
                }
            }
        });
    }

    private static void initActivityKiller() {
        if (Build.VERSION.SDK_INT >= 28) {
            mActivityKiller = new ActivityKillerV28();
        } else if (Build.VERSION.SDK_INT >= 26) {
            mActivityKiller = new ActivityKillerV26();
        } else if (Build.VERSION.SDK_INT == 25 || Build.VERSION.SDK_INT == 24) {
            mActivityKiller = new ActivityKillerV24_V25();
        } else if (Build.VERSION.SDK_INT >= 21 && Build.VERSION.SDK_INT <= 23) {
            mActivityKiller = new ActivityKillerV21_V23();
        } else if (Build.VERSION.SDK_INT >= 15 && Build.VERSION.SDK_INT <= 20) {
            mActivityKiller = new ActivityKillerV15_V20();
        } else if (Build.VERSION.SDK_INT < 15) {
            mActivityKiller = new ActivityKillerV15_V20();
        }
        try {
            Cockroach.hookmH();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static void hookmH() throws Exception {
        Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
        Object activityThread = activityThreadClass.getDeclaredMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
        Field mhField = activityThreadClass.getDeclaredField("mH");
        mhField.setAccessible(true);
        final Handler mhHandler = (Handler)mhField.get(activityThread);
        Field callbackField = Handler.class.getDeclaredField("mCallback");
        callbackField.setAccessible(true);
        callbackField.set(mhHandler, new Handler.Callback(){

            public boolean handleMessage(Message msg) {
                if (Build.VERSION.SDK_INT >= 28) {
                    int EXECUTE_TRANSACTION = 159;
                    if (msg.what == 159) {
                        try {
                            mhHandler.handleMessage(msg);
                        }
                        catch (Throwable throwable) {
                            mActivityKiller.finishLaunchActivity(msg);
                            Cockroach.notifyException(throwable);
                        }
                        return true;
                    }
                    return false;
                }
                switch (msg.what) {
                    case 100: {
                        try {
                            mhHandler.handleMessage(msg);
                        }
                        catch (Throwable throwable) {
                            mActivityKiller.finishLaunchActivity(msg);
                            Cockroach.notifyException(throwable);
                        }
                        return true;
                    }
                    case 107: {
                        try {
                            mhHandler.handleMessage(msg);
                        }
                        catch (Throwable throwable) {
                            mActivityKiller.finishResumeActivity(msg);
                            Cockroach.notifyException(throwable);
                        }
                        return true;
                    }
                    case 102: {
                        try {
                            mhHandler.handleMessage(msg);
                        }
                        catch (Throwable throwable) {
                            mActivityKiller.finishPauseActivity(msg);
                            Cockroach.notifyException(throwable);
                        }
                        return true;
                    }
                    case 101: {
                        try {
                            mhHandler.handleMessage(msg);
                        }
                        catch (Throwable throwable) {
                            mActivityKiller.finishPauseActivity(msg);
                            Cockroach.notifyException(throwable);
                        }
                        return true;
                    }
                    case 104: {
                        try {
                            mhHandler.handleMessage(msg);
                        }
                        catch (Throwable throwable) {
                            mActivityKiller.finishStopActivity(msg);
                            Cockroach.notifyException(throwable);
                        }
                        return true;
                    }
                    case 109: {
                        try {
                            mhHandler.handleMessage(msg);
                        }
                        catch (Throwable throwable) {
                            Cockroach.notifyException(throwable);
                        }
                        return true;
                    }
                }
                return false;
            }
        });
    }

    private static void notifyException(Throwable throwable) {
        if (mAbstractExceptionHandler == null) {
            return;
        }
        if (Cockroach.isSafeMode()) {
            mAbstractExceptionHandler.bandageExceptionHappened(throwable);
        } else {
            mAbstractExceptionHandler.uncaughtExceptionHappened(Looper.getMainLooper().getThread(), throwable);
            Cockroach.safeMode();
        }
    }

    public static boolean isSafeMode() {
        return mIsSafeMode;
    }

    private static void safeMode() {
        mIsSafeMode = true;
        if (mAbstractExceptionHandler != null) {
            mAbstractExceptionHandler.enterSafeMode();
        }
        while (true) {
            try {
                while (true) {
                    Looper.loop();
                }
            }
            catch (Throwable e) {
                boolean choreographerException = Cockroach.isChoreographerException(e);
                if (mAbstractExceptionHandler == null || choreographerException) continue;
                mAbstractExceptionHandler.bandageExceptionHappened(e);
                continue;
            }
            break;
        }
    }

    private static boolean isChoreographerException(Throwable e) {
        if (e == null || mAbstractExceptionHandler == null) {
            return false;
        }
        StackTraceElement[] elements = e.getStackTrace();
        if (elements == null) {
            return false;
        }
        for (int i = elements.length - 1; i > -1; --i) {
            WeakReference<Activity> weakReference;
            if (elements.length - i > 20) {
                return false;
            }
            StackTraceElement element = elements[i];
            if (!"android.view.Choreographer".equals(element.getClassName()) || !"Choreographer.java".equals(element.getFileName()) || !"doFrame".equals(element.getMethodName())) continue;
            mAbstractExceptionHandler.mayBeBlackScreen(e);
            if (sActivitysWRef.size() > 0 && !((Activity)(weakReference = sActivitysWRef.get(sActivitysWRef.size() - 1)).get()).isFinishing()) {
                ((Activity)weakReference.get()).finish();
            }
            return true;
        }
        return false;
    }

    static {
        mInstance = null;
        mInstalled = false;
        sActivitysWRef = new ArrayList<WeakReference<Activity>>();
    }
}

