/*
 * Decompiled with CFR 0.152.
 */
package com.shouzhan.crash;

import android.content.Context;
import android.widget.Toast;
import com.shouzhan.log.LogUtils;
import java.io.File;

public abstract class AbstractExceptionHandler {
    private Context mContext;
    private String mDeviceInfo;
    private Toast mToast;
    private long mLastTime = 0L;

    public AbstractExceptionHandler(Context context) {
        this.mContext = context;
        try {
            this.mDeviceInfo = LogUtils.getDeviceInfo(context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    final void uncaughtExceptionHappened(Thread thread, Throwable throwable) {
        try {
            this.onUncaughtExceptionHappened(thread, throwable);
            this.saveCrash2sdcard(throwable);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    final void bandageExceptionHappened(Throwable throwable) {
        try {
            this.onBandageExceptionHappened(throwable);
            this.saveCrash2sdcard(throwable);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    final void enterSafeMode() {
        try {
            this.onEnterSafeMode();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    final void mayBeBlackScreen(Throwable throwable) {
        try {
            this.onMayBeBlackScreen(throwable);
            this.saveCrash2sdcard(throwable);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected abstract void onUncaughtExceptionHappened(Thread var1, Throwable var2);

    protected abstract void onBandageExceptionHappened(Throwable var1);

    protected abstract void onEnterSafeMode();

    protected void onMayBeBlackScreen(Throwable e) {
    }

    private void saveCrash2sdcard(Throwable ex) {
        long maxInterval;
        long nowTime = System.currentTimeMillis();
        if (nowTime - this.mLastTime < (maxInterval = 1500L)) {
            return;
        }
        this.mLastTime = nowTime;
        this.showToast();
        String writeDir = LogUtils.logWriteDir(this.mContext);
        if (null == writeDir) {
            return;
        }
        String logFileName = LogUtils.logFileName(this.mContext);
        File writeFile = new File(writeDir, logFileName);
        if (!writeFile.getParentFile().canWrite()) {
            return;
        }
        LogUtils.writeStackTrace(this.mContext, writeFile, this.mDeviceInfo, ex);
    }

    private void showToast() {
    }
}

